/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.view.config;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.tools.DateTimeUtils;

public enum DateAggregationType {
    RAW("H"),
    FULL_MINUTE("yyyy-MM-dd HH:mm"),
    MINUTE("mm"),
    FULL_HOUR("yyyy-MM-dd HH"),
    HOUR("HH"),
    FULL_DATE("yyyy-MM-dd"),
    DAY("e"),
    DATE("dd"),
    START_OF_WEEK("yyyy-MM-dd"),
    WEEK_OF_YEAR("ww"),
    WEEK_OF_MONTH("W"),
    MONTH("MM"),
    YEARMONTH("yyyy-MMM"),
    QUARTER("'Q'Q"),
    FULL_QUARTER("yyyy-'Q'Q"),
    YEAR("yyyy");

    private static final Set<DateAggregationType> notLoadableAggregations;
    private static final Set<DateAggregationType> dateTimeSet;
    private final DateTimeFormatter formatter;

    private DateAggregationType(String pattern) {
        this.formatter = new DateTimeFormatterBuilder().appendPattern(pattern).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).toFormatter(Locale.getDefault());
    }

    public boolean isCyclic() {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[this.ordinal()]) {
            case 1, 2, 3, 4, 5, 6, 7, 8 -> true;
            default -> false;
        };
    }

    public String apply(long ts, ZoneId zoneId) {
        return String.valueOf(switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[this.ordinal()]) {
            case 9 -> ts;
            case 10 -> DateTimeUtils.fromTs((long)DateTimeUtils.extendedTruncateTo((long)ts, (ZoneId)zoneId, (ChronoUnit)ChronoUnit.WEEKS), (ZoneId)zoneId).format(this.formatter);
            case 5 -> DateTimeUtils.fromTs((long)ts, (ZoneId)zoneId).get(WeekFields.of(DayOfWeek.MONDAY, 1).weekOfYear());
            case 6 -> DateTimeUtils.fromTs((long)ts, (ZoneId)zoneId).get(WeekFields.of(DayOfWeek.MONDAY, 1).weekOfMonth());
            default -> DateTimeUtils.fromTs((long)ts, (ZoneId)zoneId).format(this.formatter);
        });
    }

    public long apply(String date, ZoneId zoneId) {
        LocalDateTime result;
        if (FULL_QUARTER.equals((Object)this)) {
            String[] parts = date.split("-Q");
            int year = Integer.parseInt(parts[0]);
            int quarter = Integer.parseInt(parts[1]);
            int month = (quarter - 1) * 3 + 1;
            result = LocalDateTime.of(year, month, 1, 0, 0);
        } else {
            result = dateTimeSet.contains(this) ? LocalDateTime.parse(date, this.formatter) : LocalDate.parse(date, this.formatter).atStartOfDay();
        }
        return result.atZone(zoneId).toInstant().toEpochMilli();
    }

    public DateAggregationUnit mapToUnit() {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[this.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 11 -> DateAggregationUnit.MINUTE;
            case 2, 12 -> DateAggregationUnit.HOUR;
            case 3, 4, 5, 6, 13 -> DateAggregationUnit.DAY;
            case 10 -> DateAggregationUnit.WEEK;
            case 7, 14 -> DateAggregationUnit.MONTH;
            case 8, 15 -> DateAggregationUnit.QUARTER;
            case 16 -> DateAggregationUnit.YEAR;
            case 9 -> throw new IllegalArgumentException("Unsupported DateAggregationType: " + String.valueOf(this));
        };
    }

    public List<ViewField> getCachingDateAggregationFieldList() {
        ViewField viewField = new ViewField();
        viewField.setVirtualDateField(true);
        viewField.setDateGrouping(this);
        return Collections.singletonList(viewField);
    }

    public static DateAggregationType getAggregationTypeForRange(long startTs, long endTs) {
        long deltaMillis = endTs - startTs;
        if (deltaMillis < ChronoUnit.HOURS.getDuration().toMillis()) {
            return MINUTE;
        }
        if (deltaMillis < ChronoUnit.DAYS.getDuration().toMillis()) {
            return HOUR;
        }
        if (deltaMillis < ChronoUnit.WEEKS.getDuration().toMillis()) {
            return DAY;
        }
        if (deltaMillis < ChronoUnit.MONTHS.getDuration().toMillis()) {
            return WEEK_OF_MONTH;
        }
        return MONTH;
    }

    public static DateAggregationType getDateGroupingFromPicker(String rangeBy) {
        if (StringUtils.isNotBlank((CharSequence)rangeBy)) {
            return switch (rangeBy) {
                case "minute" -> FULL_MINUTE;
                case "hour" -> FULL_HOUR;
                case "day" -> FULL_DATE;
                case "week" -> START_OF_WEEK;
                case "month" -> YEARMONTH;
                case "year" -> YEAR;
                default -> throw new IllegalArgumentException("Can't define date grouping");
            };
        }
        throw new IllegalArgumentException("Can't define date grouping");
    }

    public static String getPickerFromGrouping(DateAggregationType type) {
        if (type != null) {
            return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[type.ordinal()]) {
                case 1, 11 -> "minute";
                case 2, 12 -> "hour";
                case 3, 4, 5, 6, 13 -> "day";
                case 10 -> "week";
                case 7, 8, 14, 15 -> "month";
                case 16 -> "year";
                default -> throw new IllegalArgumentException("Can't define date grouping");
            };
        }
        throw new IllegalArgumentException("Can't define date grouping");
    }

    public static ChronoUnit mapDateAggregationToChronoUnit(DateAggregationType dateAggregationType) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[dateAggregationType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 11 -> ChronoUnit.MINUTES;
            case 2, 12 -> ChronoUnit.HOURS;
            case 3, 4, 5, 6, 13 -> ChronoUnit.DAYS;
            case 10 -> ChronoUnit.WEEKS;
            case 7, 8, 14, 15 -> ChronoUnit.MONTHS;
            case 16 -> ChronoUnit.YEARS;
            case 9 -> throw new IllegalArgumentException("DateAggregationType is not supported: " + String.valueOf(dateAggregationType));
        };
    }

    public static DateAggregationType getFullType(DateAggregationType type) {
        if (type == null) {
            return null;
        }
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[type.ordinal()]) {
            case 1, 11 -> FULL_MINUTE;
            case 2, 12 -> FULL_HOUR;
            case 3, 4, 5, 6, 13 -> FULL_DATE;
            case 10 -> START_OF_WEEK;
            case 7, 14 -> YEARMONTH;
            case 8, 15 -> FULL_QUARTER;
            case 16 -> YEAR;
            default -> throw new IllegalArgumentException("Unsupported DateAggregationType: " + String.valueOf(type));
        };
    }

    public static boolean isNotLoadableAggregationType(DateAggregationType type) {
        if (type == null) {
            return false;
        }
        return notLoadableAggregations.contains(type);
    }

    public static DateAggregationType mapUnitToType(DateAggregationUnit unit, boolean isCyclic) {
        if (isCyclic) {
            return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationUnit[unit.ordinal()]) {
                case 1 -> MINUTE;
                case 2 -> HOUR;
                case 3 -> DAY;
                case 4 -> WEEK_OF_MONTH;
                case 5 -> MONTH;
                case 6 -> QUARTER;
                default -> throw new TrendzInternalException("Unsupported time unit: " + String.valueOf(unit));
            };
        }
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationUnit[unit.ordinal()]) {
            case 1 -> FULL_MINUTE;
            case 2 -> FULL_HOUR;
            case 3 -> FULL_DATE;
            case 4 -> START_OF_WEEK;
            case 5 -> YEARMONTH;
            case 6 -> FULL_QUARTER;
            case 7 -> YEAR;
            default -> throw new TrendzInternalException("Unsupported time unit: " + String.valueOf(unit));
        };
    }

    static {
        notLoadableAggregations = Set.of(RAW, MINUTE);
        dateTimeSet = Set.of(FULL_MINUTE, MINUTE, FULL_HOUR, HOUR);
    }
}

