/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.calculation;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTaskData;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.runtime.ItemLite;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculationFieldTaskData {
    private UUID calculationFieldId;
    private boolean enabled;
    private String tzName;
    private Set<ItemLite> itemSet;
    private DatePickerConfig reprocessDatePickerConfig;
    private DateAggregationUnit refreshTimeUnit;
    private int refreshTimeUnitCount;
    private boolean refreshTimeUnitTruncated;
    private long schedulingTime;

    public CalculationFieldTaskData(CalculationFieldTaskData that) {
        this.calculationFieldId = that.calculationFieldId;
        this.enabled = that.enabled;
        this.tzName = that.tzName;
        this.itemSet = that.itemSet.stream().map(ItemLite::new).collect(Collectors.toSet());
        this.reprocessDatePickerConfig = new DatePickerConfig(that.reprocessDatePickerConfig);
        this.refreshTimeUnit = that.refreshTimeUnit;
        this.refreshTimeUnitCount = that.refreshTimeUnitCount;
        this.refreshTimeUnitTruncated = that.refreshTimeUnitTruncated;
        this.schedulingTime = that.schedulingTime;
    }

    public static CalculationFieldTaskData getDefault(UUID calculationFieldId) {
        return CalculationFieldTaskData.builder().calculationFieldId(calculationFieldId).enabled(false).tzName("UTC").itemSet(Collections.emptySet()).reprocessDatePickerConfig(null).refreshTimeUnit(DateAggregationUnit.HOUR).refreshTimeUnitCount(1).schedulingTime(0L).build();
    }

    public static CalculationFieldTaskDataBuilder builder() {
        return new CalculationFieldTaskDataBuilder();
    }

    public UUID getCalculationFieldId() {
        return this.calculationFieldId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTzName() {
        return this.tzName;
    }

    public Set<ItemLite> getItemSet() {
        return this.itemSet;
    }

    public DatePickerConfig getReprocessDatePickerConfig() {
        return this.reprocessDatePickerConfig;
    }

    public DateAggregationUnit getRefreshTimeUnit() {
        return this.refreshTimeUnit;
    }

    public int getRefreshTimeUnitCount() {
        return this.refreshTimeUnitCount;
    }

    public boolean isRefreshTimeUnitTruncated() {
        return this.refreshTimeUnitTruncated;
    }

    public long getSchedulingTime() {
        return this.schedulingTime;
    }

    public void setCalculationFieldId(UUID calculationFieldId) {
        this.calculationFieldId = calculationFieldId;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    public void setItemSet(Set<ItemLite> itemSet) {
        this.itemSet = itemSet;
    }

    public void setReprocessDatePickerConfig(DatePickerConfig reprocessDatePickerConfig) {
        this.reprocessDatePickerConfig = reprocessDatePickerConfig;
    }

    public void setRefreshTimeUnit(DateAggregationUnit refreshTimeUnit) {
        this.refreshTimeUnit = refreshTimeUnit;
    }

    public void setRefreshTimeUnitCount(int refreshTimeUnitCount) {
        this.refreshTimeUnitCount = refreshTimeUnitCount;
    }

    public void setRefreshTimeUnitTruncated(boolean refreshTimeUnitTruncated) {
        this.refreshTimeUnitTruncated = refreshTimeUnitTruncated;
    }

    public void setSchedulingTime(long schedulingTime) {
        this.schedulingTime = schedulingTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculationFieldTaskData)) {
            return false;
        }
        CalculationFieldTaskData other = (CalculationFieldTaskData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getRefreshTimeUnitCount() != other.getRefreshTimeUnitCount()) {
            return false;
        }
        if (this.isRefreshTimeUnitTruncated() != other.isRefreshTimeUnitTruncated()) {
            return false;
        }
        if (this.getSchedulingTime() != other.getSchedulingTime()) {
            return false;
        }
        UUID this$calculationFieldId = this.getCalculationFieldId();
        UUID other$calculationFieldId = other.getCalculationFieldId();
        if (this$calculationFieldId == null ? other$calculationFieldId != null : !((Object)this$calculationFieldId).equals(other$calculationFieldId)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        if (this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName)) {
            return false;
        }
        Set this$itemSet = this.getItemSet();
        Set other$itemSet = other.getItemSet();
        if (this$itemSet == null ? other$itemSet != null : !((Object)this$itemSet).equals(other$itemSet)) {
            return false;
        }
        DatePickerConfig this$reprocessDatePickerConfig = this.getReprocessDatePickerConfig();
        DatePickerConfig other$reprocessDatePickerConfig = other.getReprocessDatePickerConfig();
        if (this$reprocessDatePickerConfig == null ? other$reprocessDatePickerConfig != null : !this$reprocessDatePickerConfig.equals(other$reprocessDatePickerConfig)) {
            return false;
        }
        DateAggregationUnit this$refreshTimeUnit = this.getRefreshTimeUnit();
        DateAggregationUnit other$refreshTimeUnit = other.getRefreshTimeUnit();
        return !(this$refreshTimeUnit == null ? other$refreshTimeUnit != null : !this$refreshTimeUnit.equals(other$refreshTimeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalculationFieldTaskData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getRefreshTimeUnitCount();
        result = result * 59 + (this.isRefreshTimeUnitTruncated() ? 79 : 97);
        long $schedulingTime = this.getSchedulingTime();
        result = result * 59 + (int)($schedulingTime >>> 32 ^ $schedulingTime);
        UUID $calculationFieldId = this.getCalculationFieldId();
        result = result * 59 + ($calculationFieldId == null ? 43 : ((Object)$calculationFieldId).hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        Set $itemSet = this.getItemSet();
        result = result * 59 + ($itemSet == null ? 43 : ((Object)$itemSet).hashCode());
        DatePickerConfig $reprocessDatePickerConfig = this.getReprocessDatePickerConfig();
        result = result * 59 + ($reprocessDatePickerConfig == null ? 43 : $reprocessDatePickerConfig.hashCode());
        DateAggregationUnit $refreshTimeUnit = this.getRefreshTimeUnit();
        result = result * 59 + ($refreshTimeUnit == null ? 43 : $refreshTimeUnit.hashCode());
        return result;
    }

    public String toString() {
        return "CalculationFieldTaskData(calculationFieldId=" + String.valueOf(this.getCalculationFieldId()) + ", enabled=" + this.isEnabled() + ", tzName=" + this.getTzName() + ", itemSet=" + String.valueOf(this.getItemSet()) + ", reprocessDatePickerConfig=" + String.valueOf(this.getReprocessDatePickerConfig()) + ", refreshTimeUnit=" + String.valueOf(this.getRefreshTimeUnit()) + ", refreshTimeUnitCount=" + this.getRefreshTimeUnitCount() + ", refreshTimeUnitTruncated=" + this.isRefreshTimeUnitTruncated() + ", schedulingTime=" + this.getSchedulingTime() + ")";
    }

    public CalculationFieldTaskData() {
    }

    public CalculationFieldTaskData(UUID calculationFieldId, boolean enabled, String tzName, Set<ItemLite> itemSet, DatePickerConfig reprocessDatePickerConfig, DateAggregationUnit refreshTimeUnit, int refreshTimeUnitCount, boolean refreshTimeUnitTruncated, long schedulingTime) {
        this.calculationFieldId = calculationFieldId;
        this.enabled = enabled;
        this.tzName = tzName;
        this.itemSet = itemSet;
        this.reprocessDatePickerConfig = reprocessDatePickerConfig;
        this.refreshTimeUnit = refreshTimeUnit;
        this.refreshTimeUnitCount = refreshTimeUnitCount;
        this.refreshTimeUnitTruncated = refreshTimeUnitTruncated;
        this.schedulingTime = schedulingTime;
    }
}

