/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.cache.LoadedCachingData;
import org.thingsboard.trendz.domain.runtime.FieldValue;

public class LoadedCachingData {
    private List<FieldValue> data;
    private long latestTs;

    public LoadedCachingData() {
        this.data = new ArrayList();
        this.latestTs = 0L;
    }

    public LoadedCachingData(LoadedCachingData that) {
        this.data = that.data.stream().map(FieldValue::new).collect(Collectors.toList());
        this.latestTs = that.latestTs;
    }

    public static LoadedCachingDataBuilder builder() {
        return new LoadedCachingDataBuilder();
    }

    public List<FieldValue> getData() {
        return this.data;
    }

    public long getLatestTs() {
        return this.latestTs;
    }

    public void setData(List<FieldValue> data) {
        this.data = data;
    }

    public void setLatestTs(long latestTs) {
        this.latestTs = latestTs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadedCachingData)) {
            return false;
        }
        LoadedCachingData other = (LoadedCachingData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getLatestTs() != other.getLatestTs()) {
            return false;
        }
        List this$data = this.getData();
        List other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoadedCachingData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $latestTs = this.getLatestTs();
        result = result * 59 + (int)($latestTs >>> 32 ^ $latestTs);
        List $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "LoadedCachingData(data=" + String.valueOf(this.getData()) + ", latestTs=" + this.getLatestTs() + ")";
    }

    public LoadedCachingData(List<FieldValue> data, long latestTs) {
        this.data = data;
        this.latestTs = latestTs;
    }
}

