/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.base;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.LongSummaryStatistics;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.tools.DateTimeUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TimeSeriesStatistic {
    private Long minTs;
    private Long maxTs;
    private Long count;
    private Long averageStep;

    public TimeSeriesStatistic() {
        this(Collections.emptyList());
    }

    public TimeSeriesStatistic(List<Point> points) {
        if (points.isEmpty()) {
            this.minTs = null;
            this.maxTs = null;
            this.count = 0L;
            this.averageStep = null;
            return;
        }
        LongSummaryStatistics statistics = points.stream().mapToLong(Point::getTs).summaryStatistics();
        this.minTs = statistics.getMin();
        this.maxTs = statistics.getMax();
        this.count = statistics.getCount();
        if (this.count > 1L) {
            List<Long> timestamps = points.stream().map(Point::getTs).sorted().toList();
            long totalStep = 0L;
            for (int i = 1; i < timestamps.size(); ++i) {
                totalStep += timestamps.get(i) - timestamps.get(i - 1);
            }
            this.averageStep = totalStep / (long)(timestamps.size() - 1);
        } else {
            this.averageStep = 0L;
        }
    }

    public TimeSeriesStatistic(TimeSeriesStatistic that) {
        this.minTs = that.minTs;
        this.maxTs = that.maxTs;
        this.count = that.count;
        this.averageStep = that.averageStep;
    }

    public String toString() {
        return this.toString(ZoneId.systemDefault());
    }

    public String toString(ZoneId zoneId) {
        if (this.count == 0L) {
            return "[empty]";
        }
        return "[%s - %s, count = %s, averageStep = %s]".formatted(DateTimeUtils.fromTs((long)this.minTs, (ZoneId)zoneId), DateTimeUtils.fromTs((long)this.maxTs, (ZoneId)zoneId), this.count, this.averageStep);
    }

    public Long getMinTs() {
        return this.minTs;
    }

    public Long getMaxTs() {
        return this.maxTs;
    }

    public Long getCount() {
        return this.count;
    }

    public Long getAverageStep() {
        return this.averageStep;
    }

    public void setMinTs(Long minTs) {
        this.minTs = minTs;
    }

    public void setMaxTs(Long maxTs) {
        this.maxTs = maxTs;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public void setAverageStep(Long averageStep) {
        this.averageStep = averageStep;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSeriesStatistic)) {
            return false;
        }
        TimeSeriesStatistic other = (TimeSeriesStatistic)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$minTs = this.getMinTs();
        Long other$minTs = other.getMinTs();
        if (this$minTs == null ? other$minTs != null : !((Object)this$minTs).equals(other$minTs)) {
            return false;
        }
        Long this$maxTs = this.getMaxTs();
        Long other$maxTs = other.getMaxTs();
        if (this$maxTs == null ? other$maxTs != null : !((Object)this$maxTs).equals(other$maxTs)) {
            return false;
        }
        Long this$count = this.getCount();
        Long other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Long this$averageStep = this.getAverageStep();
        Long other$averageStep = other.getAverageStep();
        return !(this$averageStep == null ? other$averageStep != null : !((Object)this$averageStep).equals(other$averageStep));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeSeriesStatistic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $minTs = this.getMinTs();
        result = result * 59 + ($minTs == null ? 43 : ((Object)$minTs).hashCode());
        Long $maxTs = this.getMaxTs();
        result = result * 59 + ($maxTs == null ? 43 : ((Object)$maxTs).hashCode());
        Long $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Long $averageStep = this.getAverageStep();
        result = result * 59 + ($averageStep == null ? 43 : ((Object)$averageStep).hashCode());
        return result;
    }
}

