/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.assistance.model;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.assistance.model.LlmSettings;
import org.thingsboard.trendz.domain.chat.ChatType;

/*
 * Exception performing whole class analysis ignored.
 */
public class LlmSettings {
    private UUID id;
    private UUID tenantId;
    private boolean active;
    private boolean useDefault;
    private UUID defaultLlmConfigId;
    private Map<ChatType, UUID> chatTypeToLlmConfigMap;

    public LlmSettings(LlmSettings that) {
        this.id = that.id;
        this.tenantId = that.tenantId;
        this.active = that.active;
        this.useDefault = that.useDefault;
        this.defaultLlmConfigId = that.defaultLlmConfigId;
        this.chatTypeToLlmConfigMap = that.chatTypeToLlmConfigMap == null ? null : (Map)that.chatTypeToLlmConfigMap.entrySet().stream().collect(() -> new EnumMap(ChatType.class), (m, e) -> m.put((ChatType)e.getKey(), (UUID)e.getValue()), Map::putAll);
    }

    public static LlmSettings getDefault(UUID tenantId, UUID defaultModelId) {
        return LlmSettings.builder().id(TimeStampUUIDGenerator.generateId()).tenantId(tenantId).active(defaultModelId != null).useDefault(true).defaultLlmConfigId(defaultModelId).chatTypeToLlmConfigMap(Collections.emptyMap()).build();
    }

    public static LlmSettingsBuilder builder() {
        return new LlmSettingsBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    public UUID getDefaultLlmConfigId() {
        return this.defaultLlmConfigId;
    }

    public Map<ChatType, UUID> getChatTypeToLlmConfigMap() {
        return this.chatTypeToLlmConfigMap;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setUseDefault(boolean useDefault) {
        this.useDefault = useDefault;
    }

    public void setDefaultLlmConfigId(UUID defaultLlmConfigId) {
        this.defaultLlmConfigId = defaultLlmConfigId;
    }

    public void setChatTypeToLlmConfigMap(Map<ChatType, UUID> chatTypeToLlmConfigMap) {
        this.chatTypeToLlmConfigMap = chatTypeToLlmConfigMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LlmSettings)) {
            return false;
        }
        LlmSettings other = (LlmSettings)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isUseDefault() != other.isUseDefault()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$defaultLlmConfigId = this.getDefaultLlmConfigId();
        UUID other$defaultLlmConfigId = other.getDefaultLlmConfigId();
        if (this$defaultLlmConfigId == null ? other$defaultLlmConfigId != null : !((Object)this$defaultLlmConfigId).equals(other$defaultLlmConfigId)) {
            return false;
        }
        Map this$chatTypeToLlmConfigMap = this.getChatTypeToLlmConfigMap();
        Map other$chatTypeToLlmConfigMap = other.getChatTypeToLlmConfigMap();
        return !(this$chatTypeToLlmConfigMap == null ? other$chatTypeToLlmConfigMap != null : !((Object)this$chatTypeToLlmConfigMap).equals(other$chatTypeToLlmConfigMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LlmSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isUseDefault() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $defaultLlmConfigId = this.getDefaultLlmConfigId();
        result = result * 59 + ($defaultLlmConfigId == null ? 43 : ((Object)$defaultLlmConfigId).hashCode());
        Map $chatTypeToLlmConfigMap = this.getChatTypeToLlmConfigMap();
        result = result * 59 + ($chatTypeToLlmConfigMap == null ? 43 : ((Object)$chatTypeToLlmConfigMap).hashCode());
        return result;
    }

    public String toString() {
        return "LlmSettings(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", active=" + this.isActive() + ", useDefault=" + this.isUseDefault() + ", defaultLlmConfigId=" + String.valueOf(this.getDefaultLlmConfigId()) + ", chatTypeToLlmConfigMap=" + String.valueOf(this.getChatTypeToLlmConfigMap()) + ")";
    }

    public LlmSettings() {
    }

    public LlmSettings(UUID id, UUID tenantId, boolean active, boolean useDefault, UUID defaultLlmConfigId, Map<ChatType, UUID> chatTypeToLlmConfigMap) {
        this.id = id;
        this.tenantId = tenantId;
        this.active = active;
        this.useDefault = useDefault;
        this.defaultLlmConfigId = defaultLlmConfigId;
        this.chatTypeToLlmConfigMap = chatTypeToLlmConfigMap;
    }
}

