/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.assistance.model;

import java.util.Arrays;
import java.util.List;
import org.thingsboard.trendz.domain.assistance.model.LlmName;
import org.thingsboard.trendz.exception.assistance.LlmProviderNotFoundException;

/*
 * Exception performing whole class analysis ignored.
 */
public enum LlmProvider {
    CUSTOM(List.of(LlmName.CUSTOM)),
    OPEN_AI(List.of(LlmName.GPT_4_O, LlmName.GPT_4_O_MINI, LlmName.O3_MINI, LlmName.O4_MINI)),
    GOOGLE(List.of(LlmName.GEMINI_1_5_FLASH, LlmName.GEMINI_1_5_PRO, LlmName.GEMINI_2_0_FLASH, LlmName.GEMINI_2_0_FLASH_LITE, LlmName.GEMINI_2_5_FLASH)),
    AMAZON_BEDROCK(List.of(LlmName.META_LLAMA_3_1_70b_INSTRUCT, LlmName.META_LLAMA_3_2_90b_INSTRUCT, LlmName.META_LLAMA_3_3_70b_INSTRUCT, LlmName.ANTHROPIC_CLAUDE_3_5_HAIKU, LlmName.ANTHROPIC_CLAUDE_3_5_SONNET, LlmName.ANTHROPIC_CLAUDE_3_7_SONNET, LlmName.AMAZON_NOVA_LITE, LlmName.AMAZON_NOVA_PRO, LlmName.MISTRAL_LARGE));

    private final List<LlmName> modelNames;

    public static LlmProvider from(String modelProvider) {
        return Arrays.stream(LlmProvider.values()).filter(llmProvider -> llmProvider.name().equals(modelProvider)).findAny().orElseThrow(() -> new LlmProviderNotFoundException(modelProvider));
    }

    public List<LlmName> getModelNames() {
        return this.modelNames;
    }

    private LlmProvider(List<LlmName> modelNames) {
        this.modelNames = modelNames;
    }
}

