/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.anomaly;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.anomaly.ClusterInfo;
import org.thingsboard.trendz.domain.anomaly.ScoredPoint;

public class ClusterInfo {
    private UUID id;
    private long clusterId;
    private int segmentsCount;
    private int segmentsPercent;
    private long durationMs;
    private double minScore;
    private double maxScore;
    private List<ScoredPoint> centroid;
    private Map<UUID, List<ScoredPoint>> clusterExamples;
    private List<ScoredPoint> histogram;

    public ClusterInfo(ClusterInfo that) {
        this.id = that.id;
        this.clusterId = that.clusterId;
        this.segmentsCount = that.segmentsCount;
        this.segmentsPercent = that.segmentsPercent;
        this.durationMs = that.durationMs;
        this.minScore = that.minScore;
        this.maxScore = that.maxScore;
        this.centroid = that.centroid == null ? null : that.centroid.stream().map(ScoredPoint::new).collect(Collectors.toList());
        this.clusterExamples = that.clusterExamples == null ? null : that.clusterExamples.entrySet().stream().map(entry -> {
            UUID key = (UUID)entry.getKey();
            List value = entry.getValue() == null ? null : ((List)entry.getValue()).stream().map(ScoredPoint::new).collect(Collectors.toList());
            return Map.entry(key, value);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.histogram = that.histogram == null ? null : that.histogram.stream().map(ScoredPoint::new).collect(Collectors.toList());
    }

    public static ClusterInfoBuilder builder() {
        return new ClusterInfoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public int getSegmentsCount() {
        return this.segmentsCount;
    }

    public int getSegmentsPercent() {
        return this.segmentsPercent;
    }

    public long getDurationMs() {
        return this.durationMs;
    }

    public double getMinScore() {
        return this.minScore;
    }

    public double getMaxScore() {
        return this.maxScore;
    }

    public List<ScoredPoint> getCentroid() {
        return this.centroid;
    }

    public Map<UUID, List<ScoredPoint>> getClusterExamples() {
        return this.clusterExamples;
    }

    public List<ScoredPoint> getHistogram() {
        return this.histogram;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setClusterId(long clusterId) {
        this.clusterId = clusterId;
    }

    public void setSegmentsCount(int segmentsCount) {
        this.segmentsCount = segmentsCount;
    }

    public void setSegmentsPercent(int segmentsPercent) {
        this.segmentsPercent = segmentsPercent;
    }

    public void setDurationMs(long durationMs) {
        this.durationMs = durationMs;
    }

    public void setMinScore(double minScore) {
        this.minScore = minScore;
    }

    public void setMaxScore(double maxScore) {
        this.maxScore = maxScore;
    }

    public void setCentroid(List<ScoredPoint> centroid) {
        this.centroid = centroid;
    }

    public void setClusterExamples(Map<UUID, List<ScoredPoint>> clusterExamples) {
        this.clusterExamples = clusterExamples;
    }

    public void setHistogram(List<ScoredPoint> histogram) {
        this.histogram = histogram;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterInfo)) {
            return false;
        }
        ClusterInfo other = (ClusterInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getClusterId() != other.getClusterId()) {
            return false;
        }
        if (this.getSegmentsCount() != other.getSegmentsCount()) {
            return false;
        }
        if (this.getSegmentsPercent() != other.getSegmentsPercent()) {
            return false;
        }
        if (this.getDurationMs() != other.getDurationMs()) {
            return false;
        }
        if (Double.compare(this.getMinScore(), other.getMinScore()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxScore(), other.getMaxScore()) != 0) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List this$centroid = this.getCentroid();
        List other$centroid = other.getCentroid();
        if (this$centroid == null ? other$centroid != null : !((Object)this$centroid).equals(other$centroid)) {
            return false;
        }
        Map this$clusterExamples = this.getClusterExamples();
        Map other$clusterExamples = other.getClusterExamples();
        if (this$clusterExamples == null ? other$clusterExamples != null : !((Object)this$clusterExamples).equals(other$clusterExamples)) {
            return false;
        }
        List this$histogram = this.getHistogram();
        List other$histogram = other.getHistogram();
        return !(this$histogram == null ? other$histogram != null : !((Object)this$histogram).equals(other$histogram));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $clusterId = this.getClusterId();
        result = result * 59 + (int)($clusterId >>> 32 ^ $clusterId);
        result = result * 59 + this.getSegmentsCount();
        result = result * 59 + this.getSegmentsPercent();
        long $durationMs = this.getDurationMs();
        result = result * 59 + (int)($durationMs >>> 32 ^ $durationMs);
        long $minScore = Double.doubleToLongBits(this.getMinScore());
        result = result * 59 + (int)($minScore >>> 32 ^ $minScore);
        long $maxScore = Double.doubleToLongBits(this.getMaxScore());
        result = result * 59 + (int)($maxScore >>> 32 ^ $maxScore);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List $centroid = this.getCentroid();
        result = result * 59 + ($centroid == null ? 43 : ((Object)$centroid).hashCode());
        Map $clusterExamples = this.getClusterExamples();
        result = result * 59 + ($clusterExamples == null ? 43 : ((Object)$clusterExamples).hashCode());
        List $histogram = this.getHistogram();
        result = result * 59 + ($histogram == null ? 43 : ((Object)$histogram).hashCode());
        return result;
    }

    public String toString() {
        return "ClusterInfo(id=" + String.valueOf(this.getId()) + ", clusterId=" + this.getClusterId() + ", segmentsCount=" + this.getSegmentsCount() + ", segmentsPercent=" + this.getSegmentsPercent() + ", durationMs=" + this.getDurationMs() + ", minScore=" + this.getMinScore() + ", maxScore=" + this.getMaxScore() + ", centroid=" + String.valueOf(this.getCentroid()) + ", clusterExamples=" + String.valueOf(this.getClusterExamples()) + ", histogram=" + String.valueOf(this.getHistogram()) + ")";
    }

    public ClusterInfo() {
    }

    public ClusterInfo(UUID id, long clusterId, int segmentsCount, int segmentsPercent, long durationMs, double minScore, double maxScore, List<ScoredPoint> centroid, Map<UUID, List<ScoredPoint>> clusterExamples, List<ScoredPoint> histogram) {
        this.id = id;
        this.clusterId = clusterId;
        this.segmentsCount = segmentsCount;
        this.segmentsPercent = segmentsPercent;
        this.durationMs = durationMs;
        this.minScore = minScore;
        this.maxScore = maxScore;
        this.centroid = centroid;
        this.clusterExamples = clusterExamples;
        this.histogram = histogram;
    }
}

