/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.anomaly;

import java.util.Set;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.anomaly.AnomalyReprocessRequest;
import org.thingsboard.trendz.domain.runtime.ItemLite;

public class AnomalyReprocessRequest {
    boolean alarmCreationEnabled;
    boolean saveToTbEnabled;
    private Set<ItemLite> itemSet;
    private long startTs;
    private long endTs;
    private String tzName;

    public AnomalyReprocessRequest(AnomalyReprocessRequest that) {
        this.alarmCreationEnabled = that.alarmCreationEnabled;
        this.saveToTbEnabled = that.saveToTbEnabled;
        this.itemSet = that.itemSet == null ? null : that.itemSet.stream().map(ItemLite::new).collect(Collectors.toSet());
        this.startTs = that.startTs;
        this.endTs = that.endTs;
        this.tzName = that.tzName;
    }

    public static AnomalyReprocessRequestBuilder builder() {
        return new AnomalyReprocessRequestBuilder();
    }

    public boolean isAlarmCreationEnabled() {
        return this.alarmCreationEnabled;
    }

    public boolean isSaveToTbEnabled() {
        return this.saveToTbEnabled;
    }

    public Set<ItemLite> getItemSet() {
        return this.itemSet;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public String getTzName() {
        return this.tzName;
    }

    public void setAlarmCreationEnabled(boolean alarmCreationEnabled) {
        this.alarmCreationEnabled = alarmCreationEnabled;
    }

    public void setSaveToTbEnabled(boolean saveToTbEnabled) {
        this.saveToTbEnabled = saveToTbEnabled;
    }

    public void setItemSet(Set<ItemLite> itemSet) {
        this.itemSet = itemSet;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnomalyReprocessRequest)) {
            return false;
        }
        AnomalyReprocessRequest other = (AnomalyReprocessRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isAlarmCreationEnabled() != other.isAlarmCreationEnabled()) {
            return false;
        }
        if (this.isSaveToTbEnabled() != other.isSaveToTbEnabled()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        Set this$itemSet = this.getItemSet();
        Set other$itemSet = other.getItemSet();
        if (this$itemSet == null ? other$itemSet != null : !((Object)this$itemSet).equals(other$itemSet)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        return !(this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnomalyReprocessRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAlarmCreationEnabled() ? 79 : 97);
        result = result * 59 + (this.isSaveToTbEnabled() ? 79 : 97);
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        Set $itemSet = this.getItemSet();
        result = result * 59 + ($itemSet == null ? 43 : ((Object)$itemSet).hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        return result;
    }

    public String toString() {
        return "AnomalyReprocessRequest(alarmCreationEnabled=" + this.isAlarmCreationEnabled() + ", saveToTbEnabled=" + this.isSaveToTbEnabled() + ", itemSet=" + String.valueOf(this.getItemSet()) + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", tzName=" + this.getTzName() + ")";
    }

    public AnomalyReprocessRequest() {
    }

    public AnomalyReprocessRequest(boolean alarmCreationEnabled, boolean saveToTbEnabled, Set<ItemLite> itemSet, long startTs, long endTs, String tzName) {
        this.alarmCreationEnabled = alarmCreationEnabled;
        this.saveToTbEnabled = saveToTbEnabled;
        this.itemSet = itemSet;
        this.startTs = startTs;
        this.endTs = endTs;
        this.tzName = tzName;
    }
}

