/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.anomaly;

import org.thingsboard.trendz.domain.anomaly.AnomalyAlarmConfig;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnomalyAlarmConfig {
    private int warningScoreThreshold;
    private int minorScoreThreshold;
    private int majorScoreThreshold;
    private int criticalScoreThreshold;

    public AnomalyAlarmConfig(AnomalyAlarmConfig anomalyAlarmConfig) {
        this.warningScoreThreshold = anomalyAlarmConfig.getWarningScoreThreshold();
        this.minorScoreThreshold = anomalyAlarmConfig.getMinorScoreThreshold();
        this.majorScoreThreshold = anomalyAlarmConfig.getMajorScoreThreshold();
        this.criticalScoreThreshold = anomalyAlarmConfig.getCriticalScoreThreshold();
    }

    public static AnomalyAlarmConfig defaultAlertConfig(double anomalyScoreThreshold) {
        return AnomalyAlarmConfig.builder().warningScoreThreshold((int)(anomalyScoreThreshold * 1.2)).minorScoreThreshold((int)(anomalyScoreThreshold * 1.6)).majorScoreThreshold((int)(anomalyScoreThreshold * 3.0)).criticalScoreThreshold((int)(anomalyScoreThreshold * 4.0)).build();
    }

    public int getAlarmCreationThreshold() {
        if (this.warningScoreThreshold > 0) {
            return this.warningScoreThreshold;
        }
        if (this.minorScoreThreshold > 0) {
            return this.minorScoreThreshold;
        }
        if (this.majorScoreThreshold > 0) {
            return this.majorScoreThreshold;
        }
        if (this.criticalScoreThreshold > 0) {
            return this.criticalScoreThreshold;
        }
        return Integer.MAX_VALUE;
    }

    public static AnomalyAlarmConfigBuilder builder() {
        return new AnomalyAlarmConfigBuilder();
    }

    public int getWarningScoreThreshold() {
        return this.warningScoreThreshold;
    }

    public int getMinorScoreThreshold() {
        return this.minorScoreThreshold;
    }

    public int getMajorScoreThreshold() {
        return this.majorScoreThreshold;
    }

    public int getCriticalScoreThreshold() {
        return this.criticalScoreThreshold;
    }

    public void setWarningScoreThreshold(int warningScoreThreshold) {
        this.warningScoreThreshold = warningScoreThreshold;
    }

    public void setMinorScoreThreshold(int minorScoreThreshold) {
        this.minorScoreThreshold = minorScoreThreshold;
    }

    public void setMajorScoreThreshold(int majorScoreThreshold) {
        this.majorScoreThreshold = majorScoreThreshold;
    }

    public void setCriticalScoreThreshold(int criticalScoreThreshold) {
        this.criticalScoreThreshold = criticalScoreThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnomalyAlarmConfig)) {
            return false;
        }
        AnomalyAlarmConfig other = (AnomalyAlarmConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getWarningScoreThreshold() != other.getWarningScoreThreshold()) {
            return false;
        }
        if (this.getMinorScoreThreshold() != other.getMinorScoreThreshold()) {
            return false;
        }
        if (this.getMajorScoreThreshold() != other.getMajorScoreThreshold()) {
            return false;
        }
        return this.getCriticalScoreThreshold() == other.getCriticalScoreThreshold();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnomalyAlarmConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWarningScoreThreshold();
        result = result * 59 + this.getMinorScoreThreshold();
        result = result * 59 + this.getMajorScoreThreshold();
        result = result * 59 + this.getCriticalScoreThreshold();
        return result;
    }

    public String toString() {
        return "AnomalyAlarmConfig(warningScoreThreshold=" + this.getWarningScoreThreshold() + ", minorScoreThreshold=" + this.getMinorScoreThreshold() + ", majorScoreThreshold=" + this.getMajorScoreThreshold() + ", criticalScoreThreshold=" + this.getCriticalScoreThreshold() + ")";
    }

    public AnomalyAlarmConfig() {
    }

    public AnomalyAlarmConfig(int warningScoreThreshold, int minorScoreThreshold, int majorScoreThreshold, int criticalScoreThreshold) {
        this.warningScoreThreshold = warningScoreThreshold;
        this.minorScoreThreshold = minorScoreThreshold;
        this.majorScoreThreshold = majorScoreThreshold;
        this.criticalScoreThreshold = criticalScoreThreshold;
    }
}

