/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.anomaly;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.ScoredPoint;
import org.thingsboard.trendz.service.model.anomaly.util.AnomaliesUtil;

public class Anomaly {
    private UUID id;
    private UUID modelId;
    private UUID itemId;
    private UUID alarmId;
    private String itemName;
    private long startTs;
    private long endTs;
    private long clusterId;
    private double score;
    private int scoreIndex;
    private List<ScoredPoint> data;

    public Anomaly(Anomaly that) {
        this.id = that.id;
        this.modelId = that.modelId;
        this.itemId = that.itemId;
        this.alarmId = that.alarmId;
        this.itemName = that.itemName;
        this.startTs = that.startTs;
        this.endTs = that.endTs;
        this.clusterId = that.clusterId;
        this.score = that.score;
        this.scoreIndex = that.scoreIndex;
        this.data = that.data == null ? null : that.data.stream().map(ScoredPoint::new).collect(Collectors.toList());
    }

    public void populateFromScoredPoints(List<ScoredPoint> scoredPoints) {
        this.data = scoredPoints.stream().map(ScoredPoint::new).collect(Collectors.toList());
        this.startTs = scoredPoints.stream().mapToLong(ScoredPoint::getT).min().orElseThrow();
        this.endTs = scoredPoints.stream().mapToLong(ScoredPoint::getT).max().orElseThrow();
        double scoreIndex = 0.0;
        for (int i = 1; i < scoredPoints.size(); ++i) {
            ScoredPoint sp1 = scoredPoints.get(i - 1);
            ScoredPoint sp2 = scoredPoints.get(i);
            scoreIndex += AnomaliesUtil.calculateScoreIndexDiff((ScoredPoint)sp1, (ScoredPoint)sp2);
        }
        this.scoreIndex = (int)scoreIndex;
        this.score = scoredPoints.stream().mapToDouble(ScoredPoint::getS).max().orElseThrow();
    }

    public static AnomalyBuilder builder() {
        return new AnomalyBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getModelId() {
        return this.modelId;
    }

    public UUID getItemId() {
        return this.itemId;
    }

    public UUID getAlarmId() {
        return this.alarmId;
    }

    public String getItemName() {
        return this.itemName;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public double getScore() {
        return this.score;
    }

    public int getScoreIndex() {
        return this.scoreIndex;
    }

    public List<ScoredPoint> getData() {
        return this.data;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setModelId(UUID modelId) {
        this.modelId = modelId;
    }

    public void setItemId(UUID itemId) {
        this.itemId = itemId;
    }

    public void setAlarmId(UUID alarmId) {
        this.alarmId = alarmId;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setClusterId(long clusterId) {
        this.clusterId = clusterId;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public void setScoreIndex(int scoreIndex) {
        this.scoreIndex = scoreIndex;
    }

    public void setData(List<ScoredPoint> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        if (this.getClusterId() != other.getClusterId()) {
            return false;
        }
        if (Double.compare(this.getScore(), other.getScore()) != 0) {
            return false;
        }
        if (this.getScoreIndex() != other.getScoreIndex()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$modelId = this.getModelId();
        UUID other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !((Object)this$modelId).equals(other$modelId)) {
            return false;
        }
        UUID this$itemId = this.getItemId();
        UUID other$itemId = other.getItemId();
        if (this$itemId == null ? other$itemId != null : !((Object)this$itemId).equals(other$itemId)) {
            return false;
        }
        UUID this$alarmId = this.getAlarmId();
        UUID other$alarmId = other.getAlarmId();
        if (this$alarmId == null ? other$alarmId != null : !((Object)this$alarmId).equals(other$alarmId)) {
            return false;
        }
        String this$itemName = this.getItemName();
        String other$itemName = other.getItemName();
        if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
            return false;
        }
        List this$data = this.getData();
        List other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Anomaly;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        long $clusterId = this.getClusterId();
        result = result * 59 + (int)($clusterId >>> 32 ^ $clusterId);
        long $score = Double.doubleToLongBits(this.getScore());
        result = result * 59 + (int)($score >>> 32 ^ $score);
        result = result * 59 + this.getScoreIndex();
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : ((Object)$modelId).hashCode());
        UUID $itemId = this.getItemId();
        result = result * 59 + ($itemId == null ? 43 : ((Object)$itemId).hashCode());
        UUID $alarmId = this.getAlarmId();
        result = result * 59 + ($alarmId == null ? 43 : ((Object)$alarmId).hashCode());
        String $itemName = this.getItemName();
        result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
        List $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "Anomaly(id=" + String.valueOf(this.getId()) + ", modelId=" + String.valueOf(this.getModelId()) + ", itemId=" + String.valueOf(this.getItemId()) + ", alarmId=" + String.valueOf(this.getAlarmId()) + ", itemName=" + this.getItemName() + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", clusterId=" + this.getClusterId() + ", score=" + this.getScore() + ", scoreIndex=" + this.getScoreIndex() + ", data=" + String.valueOf(this.getData()) + ")";
    }

    public Anomaly() {
    }

    public Anomaly(UUID id, UUID modelId, UUID itemId, UUID alarmId, String itemName, long startTs, long endTs, long clusterId, double score, int scoreIndex, List<ScoredPoint> data) {
        this.id = id;
        this.modelId = modelId;
        this.itemId = itemId;
        this.alarmId = alarmId;
        this.itemName = itemName;
        this.startTs = startTs;
        this.endTs = endTs;
        this.clusterId = clusterId;
        this.score = score;
        this.scoreIndex = scoreIndex;
        this.data = data;
    }
}

