/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.view;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.PredictionType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.FieldIdTriple;
import org.thingsboard.trendz.domain.definition.view.config.ScriptLanguage;
import org.thingsboard.trendz.domain.definition.view.config.StateProperty;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.service.alarm.alarmfield.AlarmField;
import org.thingsboard.trendz.service.model.anomaly.anomalyfield.AnomalyField;
import org.thingsboard.trendz.service.view.proto.FillGapSettings;
import org.thingsboard.trendz.service.view.proto.FillGapStrategy;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Entity(name="view_field")
@Table(name="view_field")
public class ViewFieldDto {
    @Id
    @Column(name="id")
    private UUID id;
    @Column(name="entity_field_id")
    private UUID entityFieldId;
    @Column(name="business_entity_id")
    private UUID businessEntityId;
    @Column(name="view_config_id")
    private UUID viewConfigId;
    @Column(name="dataset_config_id")
    private UUID datasetConfigId;
    @Column(name="aggregation_type")
    private String aggregationType;
    @Column(name="use_delta")
    private boolean useDelta;
    @Column(name="field_order")
    private int order;
    @Column(name="field_definition")
    private String fieldDefinition;
    @Column(name="field_label")
    private String label;
    @Column(name="unit")
    private String unit;
    @Column(name="scale_value")
    private boolean scaleValue;
    @Column(name="hidden")
    private boolean hidden;
    @Column(name="skip_render")
    private boolean skipRender;
    @Column(name="missed_relation_field")
    private boolean missedRelationField;
    @Column(name="enable_runtime_filter")
    private boolean enableRuntimeFilter;
    @Column(name="local_calculation")
    private boolean localCalculation;
    @Column(name="from_template_entity_field")
    private boolean fromTemplateEntityField;
    @Column(name="calculated_field")
    private boolean calculatedField;
    @Column(name="batch_calculation")
    private boolean batchCalculation;
    @Column(name="native_calculation")
    private boolean nativeCalculation;
    @Column(name="calc_function")
    private String calcFunction;
    @Column(name="parsed_function")
    private String parsedFunction;
    @Column(name="state_field")
    private boolean stateField;
    @Column(name="state_condition")
    private String stateCondition;
    @Column(name="state_max_duration")
    private long stateMaxDuration;
    @Enumerated(value=EnumType.STRING)
    @Column(name="state_property")
    private StateProperty stateProperty;
    @Column(name="is_alarm_field")
    private boolean alarmField;
    @Enumerated(value=EnumType.STRING)
    @Column(name="selected_alarm_field")
    private AlarmField selectedAlarmField;
    @Column(name="for_state_condition")
    private boolean forStateCondition;
    @Column(name="parsed_condition")
    private String parsedCondition;
    @Column(name="condition_field_ids")
    private String conditionFieldIds;
    @Enumerated(value=EnumType.STRING)
    @Column(name="script_language")
    private ScriptLanguage scriptLanguage;
    @Column(name="fill_gap_enable")
    private boolean fillGapEnable;
    @Enumerated(value=EnumType.STRING)
    @Column(name="fill_gap_time_unit")
    private DateAggregationUnit fillGapTimeUnit;
    @Enumerated(value=EnumType.STRING)
    @Column(name="fill_gap_strategy")
    private FillGapStrategy fillGapStrategy;
    @Column(name="is_anomaly_field")
    private boolean isAnomalyField;
    @Column(name="anomaly_model_id")
    private UUID anomalyModelId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="selected_anomaly_field")
    private AnomalyField selectedAnomalyField;
    @Column(name="is_prediction_model_field")
    private boolean isPredictionModelField;
    @Column(name="prediction_model_id")
    private UUID predictionModelId;
    @Column(name="prediction_model_orig_entity_field_id")
    private UUID predictionModelOrigEntityFieldId;
    @Column(name="is_set_prediction_period")
    private boolean usingPredictionPeriod;
    @Column(name="prediction_period_unit")
    private String predictionPeriodUnit;
    @Column(name="prediction_period_unit_count")
    private int predictionPeriodUnitCount;
    @Column(name="prediction_enabled")
    private boolean predictionEnabled;
    @Column(name="prediction_range_sec")
    private int predictionRangeSec;
    @Column(name="prediction_method")
    private String predictionMethod;
    @Column(name="include_historical_data")
    private boolean includeHistoricalData;
    @Column(name="custom_prediction_method")
    private String customPredictionMethod;
    @Column(name="prediction_pre_aggregation_disabled")
    private boolean predictionPreAggregationDisabled;
    @Column(name="multivariable_prediction_field_ids")
    private String multivariablePredictionFieldIdListJson;
    @Column(name="local_time_range")
    private String localTimeRange;
    @Column(name="virtual_date_field")
    private boolean virtualDateField;
    @Column(name="date_grouping")
    private String dateGrouping;
    @Column(name="separate_view_group")
    private boolean separateViewGroup;
    @Column(name="separate_axis")
    private boolean separateAxis;
    @Column(name="seria_type")
    private String seriaType;
    @Column(name="color_config")
    private String colorConfig;
    @Column(name="visually_hidden_field")
    private boolean visuallyHiddenField;

    public ViewField toData() {
        ViewField viewField = new ViewField();
        viewField.setId(this.id);
        viewField.setEntityFieldId(this.entityFieldId);
        viewField.setBusinessEntityId(this.businessEntityId);
        viewField.setAggregationType(this.aggregationType != null ? FieldAggregation.valueOf((String)this.aggregationType) : null);
        viewField.setUseDelta(this.useDelta);
        viewField.setLabel(this.label);
        viewField.setUnit(this.unit);
        viewField.setScaleValue(this.scaleValue);
        viewField.setHidden(this.hidden);
        viewField.setSkipRender(this.skipRender);
        viewField.setMissedRelationField(this.missedRelationField);
        viewField.setEnableRuntimeFilter(this.enableRuntimeFilter);
        viewField.setLocalCalculation(this.localCalculation);
        viewField.setFromTemplateEntityField(this.fromTemplateEntityField);
        viewField.setCalculatedField(this.calculatedField);
        viewField.setBatchCalculation(this.batchCalculation);
        viewField.setNativeCalculation(this.nativeCalculation);
        viewField.setCalcFunction(this.calcFunction);
        viewField.setParsedFunction(this.parsedFunction);
        viewField.setStateField(this.stateField);
        viewField.setStateCondition(this.stateCondition);
        viewField.setStateProperty(this.stateProperty);
        viewField.setStateMaxDuration(this.stateMaxDuration);
        viewField.setForStateCondition(this.forStateCondition);
        viewField.setParsedCondition(this.parsedCondition);
        viewField.setScriptLanguage(this.scriptLanguage);
        viewField.setFillGapSettings(FillGapSettings.builder().enableFillGap(this.fillGapEnable).fillGapStrategy(this.fillGapStrategy).timeUnit(this.fillGapTimeUnit).build());
        viewField.setAnomalyField(this.isAnomalyField);
        viewField.setAnomalyModelId(this.anomalyModelId);
        viewField.setPredictionModelField(this.isPredictionModelField);
        viewField.setPredictionModelId(this.predictionModelId);
        viewField.setPredictionModelOrigEntityFieldId(this.predictionModelOrigEntityFieldId);
        viewField.setAnomalyModelId(this.anomalyModelId);
        viewField.setSelectedAnomalyField(this.selectedAnomalyField);
        viewField.setAlarmField(this.alarmField);
        viewField.setSelectedAlarmField(this.selectedAlarmField);
        viewField.setUsingPredictionPeriod(this.usingPredictionPeriod);
        viewField.setPredictionPeriodUnit(this.predictionPeriodUnit);
        viewField.setPredictionPeriodUnitCount(this.predictionPeriodUnitCount);
        viewField.setPredictionEnabled(this.predictionEnabled);
        viewField.setPredictionRangeSec(this.predictionRangeSec);
        viewField.setPredictionMethod(this.predictionMethod != null ? PredictionType.valueOf((String)this.predictionMethod) : null);
        viewField.setIncludeHistoricalData(this.includeHistoricalData);
        viewField.setCustomPredictionMethod(this.customPredictionMethod);
        viewField.setPredictionPreAggregationDisabled(this.predictionPreAggregationDisabled);
        if (this.multivariablePredictionFieldIdListJson == null) {
            viewField.setMultivariablePredictionFieldIdList(null);
        } else {
            CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, FieldIdTriple.class);
            List idList = (List)JsonUtils.fromJson((String)this.multivariablePredictionFieldIdListJson, (JavaType)type);
            viewField.setMultivariablePredictionFieldIdList(idList);
        }
        viewField.setVirtualDateField(this.virtualDateField);
        viewField.setDateGrouping(this.dateGrouping != null ? DateAggregationType.valueOf((String)this.dateGrouping) : null);
        viewField.setSeparateViewGroup(this.separateViewGroup);
        viewField.setSeparateAxis(this.separateAxis);
        viewField.setSeriaType(this.seriaType);
        viewField.setColorConfig(this.colorConfig != null ? JsonUtils.toNodeFromRaw((String)this.colorConfig) : null);
        viewField.setLocalTimeRange(this.localTimeRange != null && !"null".equals(this.localTimeRange) ? (DatePickerConfig)JsonUtils.fromJson((String)this.localTimeRange, DatePickerConfig.class) : null);
        viewField.setVisuallyHiddenField(this.visuallyHiddenField);
        return viewField;
    }

    public static ViewFieldDto from(String fieldDefinition, ViewField entity, UUID viewConfigId) {
        ViewFieldDto dto = new ViewFieldDto();
        dto.setId(entity.getId());
        dto.setViewConfigId(viewConfigId);
        dto.setFieldDefinition(fieldDefinition);
        dto.setEntityFieldId(entity.getEntityFieldId());
        dto.setBusinessEntityId(entity.getBusinessEntityId());
        dto.setAggregationType(entity.getAggregationType() != null ? entity.getAggregationType().name() : null);
        dto.setUseDelta(entity.isUseDelta());
        dto.setLabel(entity.getLabel());
        dto.setUnit(entity.getUnit());
        dto.setScaleValue(entity.isScaleValue());
        dto.setHidden(entity.isHidden());
        dto.setSkipRender(entity.isSkipRender());
        dto.setMissedRelationField(entity.isMissedRelationField());
        dto.setEnableRuntimeFilter(entity.isEnableRuntimeFilter());
        dto.setLocalCalculation(entity.isLocalCalculation());
        dto.setFromTemplateEntityField(entity.isFromTemplateEntityField());
        dto.setCalculatedField(entity.isCalculatedField());
        dto.setBatchCalculation(entity.isBatchCalculation());
        dto.setNativeCalculation(entity.isNativeCalculation());
        dto.setCalcFunction(entity.getCalcFunction());
        dto.setParsedFunction(entity.getParsedFunction());
        dto.setStateField(entity.isStateField());
        dto.setStateCondition(entity.getStateCondition());
        dto.setStateProperty(entity.getStateProperty());
        dto.setForStateCondition(entity.isForStateCondition());
        dto.setParsedCondition(entity.getParsedCondition());
        dto.setScriptLanguage(entity.getScriptLanguage());
        if (entity.getFillGapSettings() != null) {
            dto.setFillGapEnable(entity.getFillGapSettings().isEnableFillGap());
            dto.setFillGapStrategy(entity.getFillGapSettings().getFillGapStrategy());
            dto.setFillGapTimeUnit(entity.getFillGapSettings().getTimeUnit());
        }
        dto.setAnomalyField(entity.isAnomalyField());
        dto.setAnomalyModelId(entity.getAnomalyModelId());
        dto.setPredictionModelField(entity.isPredictionModelField());
        dto.setPredictionModelId(entity.getPredictionModelId());
        dto.setPredictionModelOrigEntityFieldId(entity.getPredictionModelOrigEntityFieldId());
        dto.setUsingPredictionPeriod(entity.isUsingPredictionPeriod());
        dto.setPredictionPeriodUnit(Objects.requireNonNullElse(entity.getPredictionPeriodUnit(), "day"));
        dto.setPredictionPeriodUnitCount(entity.getPredictionPeriodUnitCount());
        dto.setSelectedAnomalyField(entity.getSelectedAnomalyField());
        dto.setAlarmField(entity.isAlarmField());
        dto.setSelectedAlarmField(entity.getSelectedAlarmField());
        dto.setPredictionEnabled(entity.isPredictionEnabled());
        dto.setPredictionRangeSec(entity.getPredictionRangeSec());
        dto.setPredictionPreAggregationDisabled(entity.isPredictionPreAggregationDisabled());
        if (entity.getPredictionMethod() != null) {
            dto.setPredictionMethod(entity.getPredictionMethod().name());
        }
        dto.setIncludeHistoricalData(entity.isIncludeHistoricalData());
        dto.setCustomPredictionMethod(entity.getCustomPredictionMethod());
        dto.setMultivariablePredictionFieldIdListJson(JsonUtils.toJson((Object)entity.getMultivariablePredictionFieldIdList()));
        dto.setVirtualDateField(entity.isVirtualDateField());
        dto.setDateGrouping(entity.getDateGrouping() != null ? entity.getDateGrouping().name() : null);
        dto.setSeparateViewGroup(entity.isSeparateViewGroup());
        dto.setSeparateAxis(entity.isSeparateAxis());
        dto.setSeriaType(entity.getSeriaType());
        if (entity.getColorConfig() != null) {
            dto.setColorConfig(entity.getColorConfig().toString());
        }
        dto.setConditionFieldIds(JsonUtils.toJson((Object)entity.getConditionFieldIds()));
        dto.setLocalTimeRange(JsonUtils.toJson((Object)entity.getLocalTimeRange()));
        dto.setVisuallyHiddenField(entity.isVisuallyHiddenField());
        return dto;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getEntityFieldId() {
        return this.entityFieldId;
    }

    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    public UUID getViewConfigId() {
        return this.viewConfigId;
    }

    public UUID getDatasetConfigId() {
        return this.datasetConfigId;
    }

    public String getAggregationType() {
        return this.aggregationType;
    }

    public boolean isUseDelta() {
        return this.useDelta;
    }

    public int getOrder() {
        return this.order;
    }

    public String getFieldDefinition() {
        return this.fieldDefinition;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean isScaleValue() {
        return this.scaleValue;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isSkipRender() {
        return this.skipRender;
    }

    public boolean isMissedRelationField() {
        return this.missedRelationField;
    }

    public boolean isEnableRuntimeFilter() {
        return this.enableRuntimeFilter;
    }

    public boolean isLocalCalculation() {
        return this.localCalculation;
    }

    public boolean isFromTemplateEntityField() {
        return this.fromTemplateEntityField;
    }

    public boolean isCalculatedField() {
        return this.calculatedField;
    }

    public boolean isBatchCalculation() {
        return this.batchCalculation;
    }

    public boolean isNativeCalculation() {
        return this.nativeCalculation;
    }

    public String getCalcFunction() {
        return this.calcFunction;
    }

    public String getParsedFunction() {
        return this.parsedFunction;
    }

    public boolean isStateField() {
        return this.stateField;
    }

    public String getStateCondition() {
        return this.stateCondition;
    }

    public long getStateMaxDuration() {
        return this.stateMaxDuration;
    }

    public StateProperty getStateProperty() {
        return this.stateProperty;
    }

    public boolean isAlarmField() {
        return this.alarmField;
    }

    public AlarmField getSelectedAlarmField() {
        return this.selectedAlarmField;
    }

    public boolean isForStateCondition() {
        return this.forStateCondition;
    }

    public String getParsedCondition() {
        return this.parsedCondition;
    }

    public String getConditionFieldIds() {
        return this.conditionFieldIds;
    }

    public ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage;
    }

    public boolean isFillGapEnable() {
        return this.fillGapEnable;
    }

    public DateAggregationUnit getFillGapTimeUnit() {
        return this.fillGapTimeUnit;
    }

    public FillGapStrategy getFillGapStrategy() {
        return this.fillGapStrategy;
    }

    public boolean isAnomalyField() {
        return this.isAnomalyField;
    }

    public UUID getAnomalyModelId() {
        return this.anomalyModelId;
    }

    public AnomalyField getSelectedAnomalyField() {
        return this.selectedAnomalyField;
    }

    public boolean isPredictionModelField() {
        return this.isPredictionModelField;
    }

    public UUID getPredictionModelId() {
        return this.predictionModelId;
    }

    public UUID getPredictionModelOrigEntityFieldId() {
        return this.predictionModelOrigEntityFieldId;
    }

    public boolean isUsingPredictionPeriod() {
        return this.usingPredictionPeriod;
    }

    public String getPredictionPeriodUnit() {
        return this.predictionPeriodUnit;
    }

    public int getPredictionPeriodUnitCount() {
        return this.predictionPeriodUnitCount;
    }

    public boolean isPredictionEnabled() {
        return this.predictionEnabled;
    }

    public int getPredictionRangeSec() {
        return this.predictionRangeSec;
    }

    public String getPredictionMethod() {
        return this.predictionMethod;
    }

    public boolean isIncludeHistoricalData() {
        return this.includeHistoricalData;
    }

    public String getCustomPredictionMethod() {
        return this.customPredictionMethod;
    }

    public boolean isPredictionPreAggregationDisabled() {
        return this.predictionPreAggregationDisabled;
    }

    public String getMultivariablePredictionFieldIdListJson() {
        return this.multivariablePredictionFieldIdListJson;
    }

    public String getLocalTimeRange() {
        return this.localTimeRange;
    }

    public boolean isVirtualDateField() {
        return this.virtualDateField;
    }

    public String getDateGrouping() {
        return this.dateGrouping;
    }

    public boolean isSeparateViewGroup() {
        return this.separateViewGroup;
    }

    public boolean isSeparateAxis() {
        return this.separateAxis;
    }

    public String getSeriaType() {
        return this.seriaType;
    }

    public String getColorConfig() {
        return this.colorConfig;
    }

    public boolean isVisuallyHiddenField() {
        return this.visuallyHiddenField;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setEntityFieldId(UUID entityFieldId) {
        this.entityFieldId = entityFieldId;
    }

    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    public void setViewConfigId(UUID viewConfigId) {
        this.viewConfigId = viewConfigId;
    }

    public void setDatasetConfigId(UUID datasetConfigId) {
        this.datasetConfigId = datasetConfigId;
    }

    public void setAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
    }

    public void setUseDelta(boolean useDelta) {
        this.useDelta = useDelta;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setFieldDefinition(String fieldDefinition) {
        this.fieldDefinition = fieldDefinition;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setScaleValue(boolean scaleValue) {
        this.scaleValue = scaleValue;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setSkipRender(boolean skipRender) {
        this.skipRender = skipRender;
    }

    public void setMissedRelationField(boolean missedRelationField) {
        this.missedRelationField = missedRelationField;
    }

    public void setEnableRuntimeFilter(boolean enableRuntimeFilter) {
        this.enableRuntimeFilter = enableRuntimeFilter;
    }

    public void setLocalCalculation(boolean localCalculation) {
        this.localCalculation = localCalculation;
    }

    public void setFromTemplateEntityField(boolean fromTemplateEntityField) {
        this.fromTemplateEntityField = fromTemplateEntityField;
    }

    public void setCalculatedField(boolean calculatedField) {
        this.calculatedField = calculatedField;
    }

    public void setBatchCalculation(boolean batchCalculation) {
        this.batchCalculation = batchCalculation;
    }

    public void setNativeCalculation(boolean nativeCalculation) {
        this.nativeCalculation = nativeCalculation;
    }

    public void setCalcFunction(String calcFunction) {
        this.calcFunction = calcFunction;
    }

    public void setParsedFunction(String parsedFunction) {
        this.parsedFunction = parsedFunction;
    }

    public void setStateField(boolean stateField) {
        this.stateField = stateField;
    }

    public void setStateCondition(String stateCondition) {
        this.stateCondition = stateCondition;
    }

    public void setStateMaxDuration(long stateMaxDuration) {
        this.stateMaxDuration = stateMaxDuration;
    }

    public void setStateProperty(StateProperty stateProperty) {
        this.stateProperty = stateProperty;
    }

    public void setAlarmField(boolean alarmField) {
        this.alarmField = alarmField;
    }

    public void setSelectedAlarmField(AlarmField selectedAlarmField) {
        this.selectedAlarmField = selectedAlarmField;
    }

    public void setForStateCondition(boolean forStateCondition) {
        this.forStateCondition = forStateCondition;
    }

    public void setParsedCondition(String parsedCondition) {
        this.parsedCondition = parsedCondition;
    }

    public void setConditionFieldIds(String conditionFieldIds) {
        this.conditionFieldIds = conditionFieldIds;
    }

    public void setScriptLanguage(ScriptLanguage scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public void setFillGapEnable(boolean fillGapEnable) {
        this.fillGapEnable = fillGapEnable;
    }

    public void setFillGapTimeUnit(DateAggregationUnit fillGapTimeUnit) {
        this.fillGapTimeUnit = fillGapTimeUnit;
    }

    public void setFillGapStrategy(FillGapStrategy fillGapStrategy) {
        this.fillGapStrategy = fillGapStrategy;
    }

    public void setAnomalyField(boolean isAnomalyField) {
        this.isAnomalyField = isAnomalyField;
    }

    public void setAnomalyModelId(UUID anomalyModelId) {
        this.anomalyModelId = anomalyModelId;
    }

    public void setSelectedAnomalyField(AnomalyField selectedAnomalyField) {
        this.selectedAnomalyField = selectedAnomalyField;
    }

    public void setPredictionModelField(boolean isPredictionModelField) {
        this.isPredictionModelField = isPredictionModelField;
    }

    public void setPredictionModelId(UUID predictionModelId) {
        this.predictionModelId = predictionModelId;
    }

    public void setPredictionModelOrigEntityFieldId(UUID predictionModelOrigEntityFieldId) {
        this.predictionModelOrigEntityFieldId = predictionModelOrigEntityFieldId;
    }

    public void setUsingPredictionPeriod(boolean usingPredictionPeriod) {
        this.usingPredictionPeriod = usingPredictionPeriod;
    }

    public void setPredictionPeriodUnit(String predictionPeriodUnit) {
        this.predictionPeriodUnit = predictionPeriodUnit;
    }

    public void setPredictionPeriodUnitCount(int predictionPeriodUnitCount) {
        this.predictionPeriodUnitCount = predictionPeriodUnitCount;
    }

    public void setPredictionEnabled(boolean predictionEnabled) {
        this.predictionEnabled = predictionEnabled;
    }

    public void setPredictionRangeSec(int predictionRangeSec) {
        this.predictionRangeSec = predictionRangeSec;
    }

    public void setPredictionMethod(String predictionMethod) {
        this.predictionMethod = predictionMethod;
    }

    public void setIncludeHistoricalData(boolean includeHistoricalData) {
        this.includeHistoricalData = includeHistoricalData;
    }

    public void setCustomPredictionMethod(String customPredictionMethod) {
        this.customPredictionMethod = customPredictionMethod;
    }

    public void setPredictionPreAggregationDisabled(boolean predictionPreAggregationDisabled) {
        this.predictionPreAggregationDisabled = predictionPreAggregationDisabled;
    }

    public void setMultivariablePredictionFieldIdListJson(String multivariablePredictionFieldIdListJson) {
        this.multivariablePredictionFieldIdListJson = multivariablePredictionFieldIdListJson;
    }

    public void setLocalTimeRange(String localTimeRange) {
        this.localTimeRange = localTimeRange;
    }

    public void setVirtualDateField(boolean virtualDateField) {
        this.virtualDateField = virtualDateField;
    }

    public void setDateGrouping(String dateGrouping) {
        this.dateGrouping = dateGrouping;
    }

    public void setSeparateViewGroup(boolean separateViewGroup) {
        this.separateViewGroup = separateViewGroup;
    }

    public void setSeparateAxis(boolean separateAxis) {
        this.separateAxis = separateAxis;
    }

    public void setSeriaType(String seriaType) {
        this.seriaType = seriaType;
    }

    public void setColorConfig(String colorConfig) {
        this.colorConfig = colorConfig;
    }

    public void setVisuallyHiddenField(boolean visuallyHiddenField) {
        this.visuallyHiddenField = visuallyHiddenField;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewFieldDto)) {
            return false;
        }
        ViewFieldDto other = (ViewFieldDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isUseDelta() != other.isUseDelta()) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.isScaleValue() != other.isScaleValue()) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        if (this.isSkipRender() != other.isSkipRender()) {
            return false;
        }
        if (this.isMissedRelationField() != other.isMissedRelationField()) {
            return false;
        }
        if (this.isEnableRuntimeFilter() != other.isEnableRuntimeFilter()) {
            return false;
        }
        if (this.isLocalCalculation() != other.isLocalCalculation()) {
            return false;
        }
        if (this.isFromTemplateEntityField() != other.isFromTemplateEntityField()) {
            return false;
        }
        if (this.isCalculatedField() != other.isCalculatedField()) {
            return false;
        }
        if (this.isBatchCalculation() != other.isBatchCalculation()) {
            return false;
        }
        if (this.isNativeCalculation() != other.isNativeCalculation()) {
            return false;
        }
        if (this.isStateField() != other.isStateField()) {
            return false;
        }
        if (this.getStateMaxDuration() != other.getStateMaxDuration()) {
            return false;
        }
        if (this.isAlarmField() != other.isAlarmField()) {
            return false;
        }
        if (this.isForStateCondition() != other.isForStateCondition()) {
            return false;
        }
        if (this.isFillGapEnable() != other.isFillGapEnable()) {
            return false;
        }
        if (this.isAnomalyField() != other.isAnomalyField()) {
            return false;
        }
        if (this.isPredictionModelField() != other.isPredictionModelField()) {
            return false;
        }
        if (this.isUsingPredictionPeriod() != other.isUsingPredictionPeriod()) {
            return false;
        }
        if (this.getPredictionPeriodUnitCount() != other.getPredictionPeriodUnitCount()) {
            return false;
        }
        if (this.isPredictionEnabled() != other.isPredictionEnabled()) {
            return false;
        }
        if (this.getPredictionRangeSec() != other.getPredictionRangeSec()) {
            return false;
        }
        if (this.isIncludeHistoricalData() != other.isIncludeHistoricalData()) {
            return false;
        }
        if (this.isPredictionPreAggregationDisabled() != other.isPredictionPreAggregationDisabled()) {
            return false;
        }
        if (this.isVirtualDateField() != other.isVirtualDateField()) {
            return false;
        }
        if (this.isSeparateViewGroup() != other.isSeparateViewGroup()) {
            return false;
        }
        if (this.isSeparateAxis() != other.isSeparateAxis()) {
            return false;
        }
        if (this.isVisuallyHiddenField() != other.isVisuallyHiddenField()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$entityFieldId = this.getEntityFieldId();
        UUID other$entityFieldId = other.getEntityFieldId();
        if (this$entityFieldId == null ? other$entityFieldId != null : !((Object)this$entityFieldId).equals(other$entityFieldId)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        UUID this$viewConfigId = this.getViewConfigId();
        UUID other$viewConfigId = other.getViewConfigId();
        if (this$viewConfigId == null ? other$viewConfigId != null : !((Object)this$viewConfigId).equals(other$viewConfigId)) {
            return false;
        }
        UUID this$datasetConfigId = this.getDatasetConfigId();
        UUID other$datasetConfigId = other.getDatasetConfigId();
        if (this$datasetConfigId == null ? other$datasetConfigId != null : !((Object)this$datasetConfigId).equals(other$datasetConfigId)) {
            return false;
        }
        String this$aggregationType = this.getAggregationType();
        String other$aggregationType = other.getAggregationType();
        if (this$aggregationType == null ? other$aggregationType != null : !this$aggregationType.equals(other$aggregationType)) {
            return false;
        }
        String this$fieldDefinition = this.getFieldDefinition();
        String other$fieldDefinition = other.getFieldDefinition();
        if (this$fieldDefinition == null ? other$fieldDefinition != null : !this$fieldDefinition.equals(other$fieldDefinition)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$calcFunction = this.getCalcFunction();
        String other$calcFunction = other.getCalcFunction();
        if (this$calcFunction == null ? other$calcFunction != null : !this$calcFunction.equals(other$calcFunction)) {
            return false;
        }
        String this$parsedFunction = this.getParsedFunction();
        String other$parsedFunction = other.getParsedFunction();
        if (this$parsedFunction == null ? other$parsedFunction != null : !this$parsedFunction.equals(other$parsedFunction)) {
            return false;
        }
        String this$stateCondition = this.getStateCondition();
        String other$stateCondition = other.getStateCondition();
        if (this$stateCondition == null ? other$stateCondition != null : !this$stateCondition.equals(other$stateCondition)) {
            return false;
        }
        StateProperty this$stateProperty = this.getStateProperty();
        StateProperty other$stateProperty = other.getStateProperty();
        if (this$stateProperty == null ? other$stateProperty != null : !this$stateProperty.equals(other$stateProperty)) {
            return false;
        }
        AlarmField this$selectedAlarmField = this.getSelectedAlarmField();
        AlarmField other$selectedAlarmField = other.getSelectedAlarmField();
        if (this$selectedAlarmField == null ? other$selectedAlarmField != null : !this$selectedAlarmField.equals(other$selectedAlarmField)) {
            return false;
        }
        String this$parsedCondition = this.getParsedCondition();
        String other$parsedCondition = other.getParsedCondition();
        if (this$parsedCondition == null ? other$parsedCondition != null : !this$parsedCondition.equals(other$parsedCondition)) {
            return false;
        }
        String this$conditionFieldIds = this.getConditionFieldIds();
        String other$conditionFieldIds = other.getConditionFieldIds();
        if (this$conditionFieldIds == null ? other$conditionFieldIds != null : !this$conditionFieldIds.equals(other$conditionFieldIds)) {
            return false;
        }
        ScriptLanguage this$scriptLanguage = this.getScriptLanguage();
        ScriptLanguage other$scriptLanguage = other.getScriptLanguage();
        if (this$scriptLanguage == null ? other$scriptLanguage != null : !this$scriptLanguage.equals(other$scriptLanguage)) {
            return false;
        }
        DateAggregationUnit this$fillGapTimeUnit = this.getFillGapTimeUnit();
        DateAggregationUnit other$fillGapTimeUnit = other.getFillGapTimeUnit();
        if (this$fillGapTimeUnit == null ? other$fillGapTimeUnit != null : !this$fillGapTimeUnit.equals(other$fillGapTimeUnit)) {
            return false;
        }
        FillGapStrategy this$fillGapStrategy = this.getFillGapStrategy();
        FillGapStrategy other$fillGapStrategy = other.getFillGapStrategy();
        if (this$fillGapStrategy == null ? other$fillGapStrategy != null : !this$fillGapStrategy.equals(other$fillGapStrategy)) {
            return false;
        }
        UUID this$anomalyModelId = this.getAnomalyModelId();
        UUID other$anomalyModelId = other.getAnomalyModelId();
        if (this$anomalyModelId == null ? other$anomalyModelId != null : !((Object)this$anomalyModelId).equals(other$anomalyModelId)) {
            return false;
        }
        AnomalyField this$selectedAnomalyField = this.getSelectedAnomalyField();
        AnomalyField other$selectedAnomalyField = other.getSelectedAnomalyField();
        if (this$selectedAnomalyField == null ? other$selectedAnomalyField != null : !this$selectedAnomalyField.equals(other$selectedAnomalyField)) {
            return false;
        }
        UUID this$predictionModelId = this.getPredictionModelId();
        UUID other$predictionModelId = other.getPredictionModelId();
        if (this$predictionModelId == null ? other$predictionModelId != null : !((Object)this$predictionModelId).equals(other$predictionModelId)) {
            return false;
        }
        UUID this$predictionModelOrigEntityFieldId = this.getPredictionModelOrigEntityFieldId();
        UUID other$predictionModelOrigEntityFieldId = other.getPredictionModelOrigEntityFieldId();
        if (this$predictionModelOrigEntityFieldId == null ? other$predictionModelOrigEntityFieldId != null : !((Object)this$predictionModelOrigEntityFieldId).equals(other$predictionModelOrigEntityFieldId)) {
            return false;
        }
        String this$predictionPeriodUnit = this.getPredictionPeriodUnit();
        String other$predictionPeriodUnit = other.getPredictionPeriodUnit();
        if (this$predictionPeriodUnit == null ? other$predictionPeriodUnit != null : !this$predictionPeriodUnit.equals(other$predictionPeriodUnit)) {
            return false;
        }
        String this$predictionMethod = this.getPredictionMethod();
        String other$predictionMethod = other.getPredictionMethod();
        if (this$predictionMethod == null ? other$predictionMethod != null : !this$predictionMethod.equals(other$predictionMethod)) {
            return false;
        }
        String this$customPredictionMethod = this.getCustomPredictionMethod();
        String other$customPredictionMethod = other.getCustomPredictionMethod();
        if (this$customPredictionMethod == null ? other$customPredictionMethod != null : !this$customPredictionMethod.equals(other$customPredictionMethod)) {
            return false;
        }
        String this$multivariablePredictionFieldIdListJson = this.getMultivariablePredictionFieldIdListJson();
        String other$multivariablePredictionFieldIdListJson = other.getMultivariablePredictionFieldIdListJson();
        if (this$multivariablePredictionFieldIdListJson == null ? other$multivariablePredictionFieldIdListJson != null : !this$multivariablePredictionFieldIdListJson.equals(other$multivariablePredictionFieldIdListJson)) {
            return false;
        }
        String this$localTimeRange = this.getLocalTimeRange();
        String other$localTimeRange = other.getLocalTimeRange();
        if (this$localTimeRange == null ? other$localTimeRange != null : !this$localTimeRange.equals(other$localTimeRange)) {
            return false;
        }
        String this$dateGrouping = this.getDateGrouping();
        String other$dateGrouping = other.getDateGrouping();
        if (this$dateGrouping == null ? other$dateGrouping != null : !this$dateGrouping.equals(other$dateGrouping)) {
            return false;
        }
        String this$seriaType = this.getSeriaType();
        String other$seriaType = other.getSeriaType();
        if (this$seriaType == null ? other$seriaType != null : !this$seriaType.equals(other$seriaType)) {
            return false;
        }
        String this$colorConfig = this.getColorConfig();
        String other$colorConfig = other.getColorConfig();
        return !(this$colorConfig == null ? other$colorConfig != null : !this$colorConfig.equals(other$colorConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViewFieldDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseDelta() ? 79 : 97);
        result = result * 59 + this.getOrder();
        result = result * 59 + (this.isScaleValue() ? 79 : 97);
        result = result * 59 + (this.isHidden() ? 79 : 97);
        result = result * 59 + (this.isSkipRender() ? 79 : 97);
        result = result * 59 + (this.isMissedRelationField() ? 79 : 97);
        result = result * 59 + (this.isEnableRuntimeFilter() ? 79 : 97);
        result = result * 59 + (this.isLocalCalculation() ? 79 : 97);
        result = result * 59 + (this.isFromTemplateEntityField() ? 79 : 97);
        result = result * 59 + (this.isCalculatedField() ? 79 : 97);
        result = result * 59 + (this.isBatchCalculation() ? 79 : 97);
        result = result * 59 + (this.isNativeCalculation() ? 79 : 97);
        result = result * 59 + (this.isStateField() ? 79 : 97);
        long $stateMaxDuration = this.getStateMaxDuration();
        result = result * 59 + (int)($stateMaxDuration >>> 32 ^ $stateMaxDuration);
        result = result * 59 + (this.isAlarmField() ? 79 : 97);
        result = result * 59 + (this.isForStateCondition() ? 79 : 97);
        result = result * 59 + (this.isFillGapEnable() ? 79 : 97);
        result = result * 59 + (this.isAnomalyField() ? 79 : 97);
        result = result * 59 + (this.isPredictionModelField() ? 79 : 97);
        result = result * 59 + (this.isUsingPredictionPeriod() ? 79 : 97);
        result = result * 59 + this.getPredictionPeriodUnitCount();
        result = result * 59 + (this.isPredictionEnabled() ? 79 : 97);
        result = result * 59 + this.getPredictionRangeSec();
        result = result * 59 + (this.isIncludeHistoricalData() ? 79 : 97);
        result = result * 59 + (this.isPredictionPreAggregationDisabled() ? 79 : 97);
        result = result * 59 + (this.isVirtualDateField() ? 79 : 97);
        result = result * 59 + (this.isSeparateViewGroup() ? 79 : 97);
        result = result * 59 + (this.isSeparateAxis() ? 79 : 97);
        result = result * 59 + (this.isVisuallyHiddenField() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $entityFieldId = this.getEntityFieldId();
        result = result * 59 + ($entityFieldId == null ? 43 : ((Object)$entityFieldId).hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        UUID $viewConfigId = this.getViewConfigId();
        result = result * 59 + ($viewConfigId == null ? 43 : ((Object)$viewConfigId).hashCode());
        UUID $datasetConfigId = this.getDatasetConfigId();
        result = result * 59 + ($datasetConfigId == null ? 43 : ((Object)$datasetConfigId).hashCode());
        String $aggregationType = this.getAggregationType();
        result = result * 59 + ($aggregationType == null ? 43 : $aggregationType.hashCode());
        String $fieldDefinition = this.getFieldDefinition();
        result = result * 59 + ($fieldDefinition == null ? 43 : $fieldDefinition.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $calcFunction = this.getCalcFunction();
        result = result * 59 + ($calcFunction == null ? 43 : $calcFunction.hashCode());
        String $parsedFunction = this.getParsedFunction();
        result = result * 59 + ($parsedFunction == null ? 43 : $parsedFunction.hashCode());
        String $stateCondition = this.getStateCondition();
        result = result * 59 + ($stateCondition == null ? 43 : $stateCondition.hashCode());
        StateProperty $stateProperty = this.getStateProperty();
        result = result * 59 + ($stateProperty == null ? 43 : $stateProperty.hashCode());
        AlarmField $selectedAlarmField = this.getSelectedAlarmField();
        result = result * 59 + ($selectedAlarmField == null ? 43 : $selectedAlarmField.hashCode());
        String $parsedCondition = this.getParsedCondition();
        result = result * 59 + ($parsedCondition == null ? 43 : $parsedCondition.hashCode());
        String $conditionFieldIds = this.getConditionFieldIds();
        result = result * 59 + ($conditionFieldIds == null ? 43 : $conditionFieldIds.hashCode());
        ScriptLanguage $scriptLanguage = this.getScriptLanguage();
        result = result * 59 + ($scriptLanguage == null ? 43 : $scriptLanguage.hashCode());
        DateAggregationUnit $fillGapTimeUnit = this.getFillGapTimeUnit();
        result = result * 59 + ($fillGapTimeUnit == null ? 43 : $fillGapTimeUnit.hashCode());
        FillGapStrategy $fillGapStrategy = this.getFillGapStrategy();
        result = result * 59 + ($fillGapStrategy == null ? 43 : $fillGapStrategy.hashCode());
        UUID $anomalyModelId = this.getAnomalyModelId();
        result = result * 59 + ($anomalyModelId == null ? 43 : ((Object)$anomalyModelId).hashCode());
        AnomalyField $selectedAnomalyField = this.getSelectedAnomalyField();
        result = result * 59 + ($selectedAnomalyField == null ? 43 : $selectedAnomalyField.hashCode());
        UUID $predictionModelId = this.getPredictionModelId();
        result = result * 59 + ($predictionModelId == null ? 43 : ((Object)$predictionModelId).hashCode());
        UUID $predictionModelOrigEntityFieldId = this.getPredictionModelOrigEntityFieldId();
        result = result * 59 + ($predictionModelOrigEntityFieldId == null ? 43 : ((Object)$predictionModelOrigEntityFieldId).hashCode());
        String $predictionPeriodUnit = this.getPredictionPeriodUnit();
        result = result * 59 + ($predictionPeriodUnit == null ? 43 : $predictionPeriodUnit.hashCode());
        String $predictionMethod = this.getPredictionMethod();
        result = result * 59 + ($predictionMethod == null ? 43 : $predictionMethod.hashCode());
        String $customPredictionMethod = this.getCustomPredictionMethod();
        result = result * 59 + ($customPredictionMethod == null ? 43 : $customPredictionMethod.hashCode());
        String $multivariablePredictionFieldIdListJson = this.getMultivariablePredictionFieldIdListJson();
        result = result * 59 + ($multivariablePredictionFieldIdListJson == null ? 43 : $multivariablePredictionFieldIdListJson.hashCode());
        String $localTimeRange = this.getLocalTimeRange();
        result = result * 59 + ($localTimeRange == null ? 43 : $localTimeRange.hashCode());
        String $dateGrouping = this.getDateGrouping();
        result = result * 59 + ($dateGrouping == null ? 43 : $dateGrouping.hashCode());
        String $seriaType = this.getSeriaType();
        result = result * 59 + ($seriaType == null ? 43 : $seriaType.hashCode());
        String $colorConfig = this.getColorConfig();
        result = result * 59 + ($colorConfig == null ? 43 : $colorConfig.hashCode());
        return result;
    }

    public String toString() {
        return "ViewFieldDto(id=" + String.valueOf(this.getId()) + ", entityFieldId=" + String.valueOf(this.getEntityFieldId()) + ", businessEntityId=" + String.valueOf(this.getBusinessEntityId()) + ", viewConfigId=" + String.valueOf(this.getViewConfigId()) + ", datasetConfigId=" + String.valueOf(this.getDatasetConfigId()) + ", aggregationType=" + this.getAggregationType() + ", useDelta=" + this.isUseDelta() + ", order=" + this.getOrder() + ", fieldDefinition=" + this.getFieldDefinition() + ", label=" + this.getLabel() + ", unit=" + this.getUnit() + ", scaleValue=" + this.isScaleValue() + ", hidden=" + this.isHidden() + ", skipRender=" + this.isSkipRender() + ", missedRelationField=" + this.isMissedRelationField() + ", enableRuntimeFilter=" + this.isEnableRuntimeFilter() + ", localCalculation=" + this.isLocalCalculation() + ", fromTemplateEntityField=" + this.isFromTemplateEntityField() + ", calculatedField=" + this.isCalculatedField() + ", batchCalculation=" + this.isBatchCalculation() + ", nativeCalculation=" + this.isNativeCalculation() + ", calcFunction=" + this.getCalcFunction() + ", parsedFunction=" + this.getParsedFunction() + ", stateField=" + this.isStateField() + ", stateCondition=" + this.getStateCondition() + ", stateMaxDuration=" + this.getStateMaxDuration() + ", stateProperty=" + String.valueOf(this.getStateProperty()) + ", alarmField=" + this.isAlarmField() + ", selectedAlarmField=" + String.valueOf(this.getSelectedAlarmField()) + ", forStateCondition=" + this.isForStateCondition() + ", parsedCondition=" + this.getParsedCondition() + ", conditionFieldIds=" + this.getConditionFieldIds() + ", scriptLanguage=" + String.valueOf(this.getScriptLanguage()) + ", fillGapEnable=" + this.isFillGapEnable() + ", fillGapTimeUnit=" + String.valueOf(this.getFillGapTimeUnit()) + ", fillGapStrategy=" + String.valueOf(this.getFillGapStrategy()) + ", isAnomalyField=" + this.isAnomalyField() + ", anomalyModelId=" + String.valueOf(this.getAnomalyModelId()) + ", selectedAnomalyField=" + String.valueOf(this.getSelectedAnomalyField()) + ", isPredictionModelField=" + this.isPredictionModelField() + ", predictionModelId=" + String.valueOf(this.getPredictionModelId()) + ", predictionModelOrigEntityFieldId=" + String.valueOf(this.getPredictionModelOrigEntityFieldId()) + ", usingPredictionPeriod=" + this.isUsingPredictionPeriod() + ", predictionPeriodUnit=" + this.getPredictionPeriodUnit() + ", predictionPeriodUnitCount=" + this.getPredictionPeriodUnitCount() + ", predictionEnabled=" + this.isPredictionEnabled() + ", predictionRangeSec=" + this.getPredictionRangeSec() + ", predictionMethod=" + this.getPredictionMethod() + ", includeHistoricalData=" + this.isIncludeHistoricalData() + ", customPredictionMethod=" + this.getCustomPredictionMethod() + ", predictionPreAggregationDisabled=" + this.isPredictionPreAggregationDisabled() + ", multivariablePredictionFieldIdListJson=" + this.getMultivariablePredictionFieldIdListJson() + ", localTimeRange=" + this.getLocalTimeRange() + ", virtualDateField=" + this.isVirtualDateField() + ", dateGrouping=" + this.getDateGrouping() + ", separateViewGroup=" + this.isSeparateViewGroup() + ", separateAxis=" + this.isSeparateAxis() + ", seriaType=" + this.getSeriaType() + ", colorConfig=" + this.getColorConfig() + ", visuallyHiddenField=" + this.isVisuallyHiddenField() + ")";
    }
}

