/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.view;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.collect.Lists;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.thingsboard.trendz.dao.view.ViewFieldDto;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.SavingCalculatedTelemetrySettings;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigDefinition;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Entity
@Table(name="view_config")
public class ViewConfigDto {
    @Id
    @Column(name="id")
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="customer_id")
    private UUID customerId;
    @Column(name="collection_id")
    private UUID collectionId;
    @Column(name="parent_path")
    private String parentPath;
    @Column(name="is_favorite")
    private boolean favorite;
    private String name;
    private String viewType;
    private String configDefinition;
    private UUID rootEntityId;
    private UUID rowClickEntityId;
    private long createdAt;
    private long updatedAt;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="view_config_id")
    private List<ViewFieldDto> allFields;
    private String runtimeFilters;
    @Column(length=100000)
    private String settings;
    @Column(name="enable_report_cache")
    private Boolean useReportCache;
    @Column(name="enable_persisted_cache")
    private Boolean usePersistedCacheTelemetry;
    @Enumerated(value=EnumType.STRING)
    @Column(name="cache_time_unit")
    private DateAggregationType cachingDateAggregation;
    @Column(name="auto_refresh_cache")
    private Boolean autoRefreshCache;
    @Enumerated(value=EnumType.STRING)
    @Column(name="refresh_frequency_time_unit")
    private DateAggregationUnit refreshFrequencyTimeUnit;
    @Column(name="refresh_frequency_time_unit_count")
    private Integer refreshFrequencyTimeUnitCount;
    @Column(name="enable_calculated_telemetry_saving")
    private boolean enableCalculatedTelemetrySaving;
    @Enumerated(value=EnumType.STRING)
    @Column(name="calculated_telemetry_saving_execution_time_unit")
    private DateAggregationUnit calculatedTelemetrySavingExecutionTimeUnit;
    @Column(name="calculated_telemetry_saving_execution_time_unit_count")
    private int calculatedTelemetrySavingExecutionTimeUnitCount;
    @Column(length=100000)
    private String datePickerConfig;
    private String tzName;

    public ViewConfig toData() {
        this.allFields.sort(Comparator.comparingInt(ViewFieldDto::getOrder));
        ViewConfig viewConfig = new ViewConfig();
        viewConfig.setId(this.id);
        viewConfig.setTenantId(this.tenantId);
        viewConfig.setCustomerId(this.customerId);
        viewConfig.setCollectionId(this.collectionId);
        viewConfig.setParentPath(this.parentPath);
        viewConfig.setFavorite(this.favorite);
        viewConfig.setName(this.name);
        viewConfig.setViewType(ViewType.valueOf((String)this.viewType));
        viewConfig.setRootEntityId(this.rootEntityId);
        viewConfig.setRowClickEntityId(this.rowClickEntityId);
        viewConfig.setCreatedAt(this.createdAt);
        viewConfig.setUpdatedAt(this.updatedAt);
        viewConfig.setXAxis(this.allFields.stream().filter(viewFieldDto -> viewFieldDto.getFieldDefinition().equalsIgnoreCase("xAxis")).map(ViewFieldDto::toData).collect(Collectors.toList()));
        viewConfig.setYAxis(this.allFields.stream().filter(viewFieldDto -> viewFieldDto.getFieldDefinition().equalsIgnoreCase("yAxis")).map(ViewFieldDto::toData).collect(Collectors.toList()));
        viewConfig.setSeries(this.allFields.stream().filter(viewFieldDto -> viewFieldDto.getFieldDefinition().equalsIgnoreCase("series")).map(ViewFieldDto::toData).collect(Collectors.toList()));
        viewConfig.setHiddenFields(this.allFields.stream().filter(viewFieldDto -> viewFieldDto.getFieldDefinition().equalsIgnoreCase("hidden")).map(ViewFieldDto::toData).collect(Collectors.toList()));
        viewConfig.setTzName(this.tzName);
        viewConfig.setCacheSettings(CacheSettings.builder().useReportCache(Boolean.valueOf(BooleanUtils.toBoolean((Boolean)this.useReportCache))).usePersistedCacheTelemetry(BooleanUtils.toBoolean((Boolean)this.usePersistedCacheTelemetry)).cachingDateAggregation(this.cachingDateAggregation).autoRefreshCache(BooleanUtils.toBoolean((Boolean)this.autoRefreshCache)).refreshFrequencyTimeUnit(this.refreshFrequencyTimeUnit).refreshFrequencyTimeUnitCount(((Integer)ObjectUtils.defaultIfNull((Object)this.refreshFrequencyTimeUnitCount, (Object)1)).intValue()).build());
        viewConfig.setSavingCalculatedTelemetrySettings(SavingCalculatedTelemetrySettings.builder().enable(BooleanUtils.toBoolean((Boolean)this.enableCalculatedTelemetrySaving)).executionTimeUnit(this.calculatedTelemetrySavingExecutionTimeUnit).executionTimeUnitCount(((Integer)ObjectUtils.defaultIfNull((Object)this.calculatedTelemetrySavingExecutionTimeUnitCount, (Object)0)).intValue()).build());
        viewConfig.setConfigDefinition(this.configDefinition != null ? (ViewConfigDefinition)JsonUtils.fromJson((String)this.configDefinition, ViewConfigDefinition.class) : null);
        CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, RuntimeFilterField.class);
        viewConfig.setRuntimeFilters(this.runtimeFilters != null ? (List)JsonUtils.fromJson((String)this.runtimeFilters, (JavaType)type) : null);
        viewConfig.setSettings(JsonUtils.toNodeFromRaw((String)this.settings));
        viewConfig.setDatePickerConfig((DatePickerConfig)JsonUtils.fromJson((String)this.datePickerConfig, DatePickerConfig.class));
        return viewConfig;
    }

    public static ViewConfigDto from(ViewConfig entity) {
        SavingCalculatedTelemetrySettings savingCalculatedTelemetrySettings;
        ViewFieldDto fieldDto;
        int i;
        ViewConfigDto dto = new ViewConfigDto();
        dto.setId(entity.getId());
        dto.setTenantId(entity.getTenantId());
        dto.setCustomerId(entity.getCustomerId());
        dto.setCollectionId(entity.getCollectionId());
        dto.setParentPath(entity.getParentPath());
        dto.setFavorite(entity.isFavorite());
        dto.setName(entity.getName());
        dto.setViewType(entity.getViewType() != null ? entity.getViewType().name() : null);
        dto.setRootEntityId(entity.getRootEntityId());
        dto.setRowClickEntityId(entity.getRowClickEntityId());
        dto.setCreatedAt(entity.getCreatedAt());
        dto.setUpdatedAt(entity.getUpdatedAt());
        ArrayList allFieldDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)entity.getXAxis())) {
            for (i = 0; i < entity.getXAxis().size(); ++i) {
                fieldDto = ViewFieldDto.from((String)"xAxis", (ViewField)((ViewField)entity.getXAxis().get(i)), (UUID)entity.getId());
                fieldDto.setOrder(i);
                allFieldDtos.add(fieldDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getYAxis())) {
            for (i = 0; i < entity.getYAxis().size(); ++i) {
                fieldDto = ViewFieldDto.from((String)"yAxis", (ViewField)((ViewField)entity.getYAxis().get(i)), (UUID)entity.getId());
                fieldDto.setOrder(i);
                allFieldDtos.add(fieldDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getSeries())) {
            for (i = 0; i < entity.getSeries().size(); ++i) {
                fieldDto = ViewFieldDto.from((String)"series", (ViewField)((ViewField)entity.getSeries().get(i)), (UUID)entity.getId());
                fieldDto.setOrder(i);
                allFieldDtos.add(fieldDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getHiddenFields())) {
            for (i = 0; i < entity.getHiddenFields().size(); ++i) {
                fieldDto = ViewFieldDto.from((String)"hidden", (ViewField)((ViewField)entity.getHiddenFields().get(i)), (UUID)entity.getId());
                fieldDto.setOrder(i);
                allFieldDtos.add(fieldDto);
            }
        }
        dto.setAllFields((List)allFieldDtos);
        dto.setTzName(entity.getTzName());
        CacheSettings cacheSettings = entity.getCacheSettings();
        if (cacheSettings != null) {
            dto.setUseReportCache(cacheSettings.getUseReportCache());
            dto.setUsePersistedCacheTelemetry(Boolean.valueOf(cacheSettings.isUsePersistedCacheTelemetry()));
            dto.setCachingDateAggregation(cacheSettings.getCachingDateAggregation());
            dto.setAutoRefreshCache(Boolean.valueOf(cacheSettings.isAutoRefreshCache()));
            dto.setRefreshFrequencyTimeUnit(cacheSettings.getRefreshFrequencyTimeUnit());
            dto.setRefreshFrequencyTimeUnitCount(Integer.valueOf(cacheSettings.getRefreshFrequencyTimeUnitCount()));
        }
        if ((savingCalculatedTelemetrySettings = entity.getSavingCalculatedTelemetrySettings()) != null) {
            dto.setEnableCalculatedTelemetrySaving(savingCalculatedTelemetrySettings.isEnable());
            dto.setCalculatedTelemetrySavingExecutionTimeUnit(savingCalculatedTelemetrySettings.getExecutionTimeUnit());
            dto.setCalculatedTelemetrySavingExecutionTimeUnitCount(savingCalculatedTelemetrySettings.getExecutionTimeUnitCount());
        }
        dto.setConfigDefinition(entity.getConfigDefinition() != null ? JsonUtils.toJson((Object)entity.getConfigDefinition()) : null);
        dto.setRuntimeFilters(entity.getRuntimeFilters() != null ? JsonUtils.toJson((Object)entity.getRuntimeFilters()) : null);
        dto.setSettings(entity.getSettings() != null ? entity.getSettings().toString() : null);
        dto.setDatePickerConfig(entity.getDatePickerConfig() != null ? JsonUtils.toJson((Object)entity.getDatePickerConfig()) : null);
        return dto;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public UUID getCustomerId() {
        return this.customerId;
    }

    public UUID getCollectionId() {
        return this.collectionId;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public String getName() {
        return this.name;
    }

    public String getViewType() {
        return this.viewType;
    }

    public String getConfigDefinition() {
        return this.configDefinition;
    }

    public UUID getRootEntityId() {
        return this.rootEntityId;
    }

    public UUID getRowClickEntityId() {
        return this.rowClickEntityId;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public List<ViewFieldDto> getAllFields() {
        return this.allFields;
    }

    public String getRuntimeFilters() {
        return this.runtimeFilters;
    }

    public String getSettings() {
        return this.settings;
    }

    public Boolean getUseReportCache() {
        return this.useReportCache;
    }

    public Boolean getUsePersistedCacheTelemetry() {
        return this.usePersistedCacheTelemetry;
    }

    public DateAggregationType getCachingDateAggregation() {
        return this.cachingDateAggregation;
    }

    public Boolean getAutoRefreshCache() {
        return this.autoRefreshCache;
    }

    public DateAggregationUnit getRefreshFrequencyTimeUnit() {
        return this.refreshFrequencyTimeUnit;
    }

    public Integer getRefreshFrequencyTimeUnitCount() {
        return this.refreshFrequencyTimeUnitCount;
    }

    public boolean isEnableCalculatedTelemetrySaving() {
        return this.enableCalculatedTelemetrySaving;
    }

    public DateAggregationUnit getCalculatedTelemetrySavingExecutionTimeUnit() {
        return this.calculatedTelemetrySavingExecutionTimeUnit;
    }

    public int getCalculatedTelemetrySavingExecutionTimeUnitCount() {
        return this.calculatedTelemetrySavingExecutionTimeUnitCount;
    }

    public String getDatePickerConfig() {
        return this.datePickerConfig;
    }

    public String getTzName() {
        return this.tzName;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    public void setCollectionId(UUID collectionId) {
        this.collectionId = collectionId;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    public void setConfigDefinition(String configDefinition) {
        this.configDefinition = configDefinition;
    }

    public void setRootEntityId(UUID rootEntityId) {
        this.rootEntityId = rootEntityId;
    }

    public void setRowClickEntityId(UUID rowClickEntityId) {
        this.rowClickEntityId = rowClickEntityId;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setAllFields(List<ViewFieldDto> allFields) {
        this.allFields = allFields;
    }

    public void setRuntimeFilters(String runtimeFilters) {
        this.runtimeFilters = runtimeFilters;
    }

    public void setSettings(String settings) {
        this.settings = settings;
    }

    public void setUseReportCache(Boolean useReportCache) {
        this.useReportCache = useReportCache;
    }

    public void setUsePersistedCacheTelemetry(Boolean usePersistedCacheTelemetry) {
        this.usePersistedCacheTelemetry = usePersistedCacheTelemetry;
    }

    public void setCachingDateAggregation(DateAggregationType cachingDateAggregation) {
        this.cachingDateAggregation = cachingDateAggregation;
    }

    public void setAutoRefreshCache(Boolean autoRefreshCache) {
        this.autoRefreshCache = autoRefreshCache;
    }

    public void setRefreshFrequencyTimeUnit(DateAggregationUnit refreshFrequencyTimeUnit) {
        this.refreshFrequencyTimeUnit = refreshFrequencyTimeUnit;
    }

    public void setRefreshFrequencyTimeUnitCount(Integer refreshFrequencyTimeUnitCount) {
        this.refreshFrequencyTimeUnitCount = refreshFrequencyTimeUnitCount;
    }

    public void setEnableCalculatedTelemetrySaving(boolean enableCalculatedTelemetrySaving) {
        this.enableCalculatedTelemetrySaving = enableCalculatedTelemetrySaving;
    }

    public void setCalculatedTelemetrySavingExecutionTimeUnit(DateAggregationUnit calculatedTelemetrySavingExecutionTimeUnit) {
        this.calculatedTelemetrySavingExecutionTimeUnit = calculatedTelemetrySavingExecutionTimeUnit;
    }

    public void setCalculatedTelemetrySavingExecutionTimeUnitCount(int calculatedTelemetrySavingExecutionTimeUnitCount) {
        this.calculatedTelemetrySavingExecutionTimeUnitCount = calculatedTelemetrySavingExecutionTimeUnitCount;
    }

    public void setDatePickerConfig(String datePickerConfig) {
        this.datePickerConfig = datePickerConfig;
    }

    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewConfigDto)) {
            return false;
        }
        ViewConfigDto other = (ViewConfigDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isFavorite() != other.isFavorite()) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        if (this.getUpdatedAt() != other.getUpdatedAt()) {
            return false;
        }
        if (this.isEnableCalculatedTelemetrySaving() != other.isEnableCalculatedTelemetrySaving()) {
            return false;
        }
        if (this.getCalculatedTelemetrySavingExecutionTimeUnitCount() != other.getCalculatedTelemetrySavingExecutionTimeUnitCount()) {
            return false;
        }
        Boolean this$useReportCache = this.getUseReportCache();
        Boolean other$useReportCache = other.getUseReportCache();
        if (this$useReportCache == null ? other$useReportCache != null : !((Object)this$useReportCache).equals(other$useReportCache)) {
            return false;
        }
        Boolean this$usePersistedCacheTelemetry = this.getUsePersistedCacheTelemetry();
        Boolean other$usePersistedCacheTelemetry = other.getUsePersistedCacheTelemetry();
        if (this$usePersistedCacheTelemetry == null ? other$usePersistedCacheTelemetry != null : !((Object)this$usePersistedCacheTelemetry).equals(other$usePersistedCacheTelemetry)) {
            return false;
        }
        Boolean this$autoRefreshCache = this.getAutoRefreshCache();
        Boolean other$autoRefreshCache = other.getAutoRefreshCache();
        if (this$autoRefreshCache == null ? other$autoRefreshCache != null : !((Object)this$autoRefreshCache).equals(other$autoRefreshCache)) {
            return false;
        }
        Integer this$refreshFrequencyTimeUnitCount = this.getRefreshFrequencyTimeUnitCount();
        Integer other$refreshFrequencyTimeUnitCount = other.getRefreshFrequencyTimeUnitCount();
        if (this$refreshFrequencyTimeUnitCount == null ? other$refreshFrequencyTimeUnitCount != null : !((Object)this$refreshFrequencyTimeUnitCount).equals(other$refreshFrequencyTimeUnitCount)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$collectionId = this.getCollectionId();
        UUID other$collectionId = other.getCollectionId();
        if (this$collectionId == null ? other$collectionId != null : !((Object)this$collectionId).equals(other$collectionId)) {
            return false;
        }
        String this$parentPath = this.getParentPath();
        String other$parentPath = other.getParentPath();
        if (this$parentPath == null ? other$parentPath != null : !this$parentPath.equals(other$parentPath)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$viewType = this.getViewType();
        String other$viewType = other.getViewType();
        if (this$viewType == null ? other$viewType != null : !this$viewType.equals(other$viewType)) {
            return false;
        }
        String this$configDefinition = this.getConfigDefinition();
        String other$configDefinition = other.getConfigDefinition();
        if (this$configDefinition == null ? other$configDefinition != null : !this$configDefinition.equals(other$configDefinition)) {
            return false;
        }
        UUID this$rootEntityId = this.getRootEntityId();
        UUID other$rootEntityId = other.getRootEntityId();
        if (this$rootEntityId == null ? other$rootEntityId != null : !((Object)this$rootEntityId).equals(other$rootEntityId)) {
            return false;
        }
        UUID this$rowClickEntityId = this.getRowClickEntityId();
        UUID other$rowClickEntityId = other.getRowClickEntityId();
        if (this$rowClickEntityId == null ? other$rowClickEntityId != null : !((Object)this$rowClickEntityId).equals(other$rowClickEntityId)) {
            return false;
        }
        List this$allFields = this.getAllFields();
        List other$allFields = other.getAllFields();
        if (this$allFields == null ? other$allFields != null : !((Object)this$allFields).equals(other$allFields)) {
            return false;
        }
        String this$runtimeFilters = this.getRuntimeFilters();
        String other$runtimeFilters = other.getRuntimeFilters();
        if (this$runtimeFilters == null ? other$runtimeFilters != null : !this$runtimeFilters.equals(other$runtimeFilters)) {
            return false;
        }
        String this$settings = this.getSettings();
        String other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        DateAggregationType this$cachingDateAggregation = this.getCachingDateAggregation();
        DateAggregationType other$cachingDateAggregation = other.getCachingDateAggregation();
        if (this$cachingDateAggregation == null ? other$cachingDateAggregation != null : !this$cachingDateAggregation.equals(other$cachingDateAggregation)) {
            return false;
        }
        DateAggregationUnit this$refreshFrequencyTimeUnit = this.getRefreshFrequencyTimeUnit();
        DateAggregationUnit other$refreshFrequencyTimeUnit = other.getRefreshFrequencyTimeUnit();
        if (this$refreshFrequencyTimeUnit == null ? other$refreshFrequencyTimeUnit != null : !this$refreshFrequencyTimeUnit.equals(other$refreshFrequencyTimeUnit)) {
            return false;
        }
        DateAggregationUnit this$calculatedTelemetrySavingExecutionTimeUnit = this.getCalculatedTelemetrySavingExecutionTimeUnit();
        DateAggregationUnit other$calculatedTelemetrySavingExecutionTimeUnit = other.getCalculatedTelemetrySavingExecutionTimeUnit();
        if (this$calculatedTelemetrySavingExecutionTimeUnit == null ? other$calculatedTelemetrySavingExecutionTimeUnit != null : !this$calculatedTelemetrySavingExecutionTimeUnit.equals(other$calculatedTelemetrySavingExecutionTimeUnit)) {
            return false;
        }
        String this$datePickerConfig = this.getDatePickerConfig();
        String other$datePickerConfig = other.getDatePickerConfig();
        if (this$datePickerConfig == null ? other$datePickerConfig != null : !this$datePickerConfig.equals(other$datePickerConfig)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        return !(this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViewConfigDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFavorite() ? 79 : 97);
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        long $updatedAt = this.getUpdatedAt();
        result = result * 59 + (int)($updatedAt >>> 32 ^ $updatedAt);
        result = result * 59 + (this.isEnableCalculatedTelemetrySaving() ? 79 : 97);
        result = result * 59 + this.getCalculatedTelemetrySavingExecutionTimeUnitCount();
        Boolean $useReportCache = this.getUseReportCache();
        result = result * 59 + ($useReportCache == null ? 43 : ((Object)$useReportCache).hashCode());
        Boolean $usePersistedCacheTelemetry = this.getUsePersistedCacheTelemetry();
        result = result * 59 + ($usePersistedCacheTelemetry == null ? 43 : ((Object)$usePersistedCacheTelemetry).hashCode());
        Boolean $autoRefreshCache = this.getAutoRefreshCache();
        result = result * 59 + ($autoRefreshCache == null ? 43 : ((Object)$autoRefreshCache).hashCode());
        Integer $refreshFrequencyTimeUnitCount = this.getRefreshFrequencyTimeUnitCount();
        result = result * 59 + ($refreshFrequencyTimeUnitCount == null ? 43 : ((Object)$refreshFrequencyTimeUnitCount).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $collectionId = this.getCollectionId();
        result = result * 59 + ($collectionId == null ? 43 : ((Object)$collectionId).hashCode());
        String $parentPath = this.getParentPath();
        result = result * 59 + ($parentPath == null ? 43 : $parentPath.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $viewType = this.getViewType();
        result = result * 59 + ($viewType == null ? 43 : $viewType.hashCode());
        String $configDefinition = this.getConfigDefinition();
        result = result * 59 + ($configDefinition == null ? 43 : $configDefinition.hashCode());
        UUID $rootEntityId = this.getRootEntityId();
        result = result * 59 + ($rootEntityId == null ? 43 : ((Object)$rootEntityId).hashCode());
        UUID $rowClickEntityId = this.getRowClickEntityId();
        result = result * 59 + ($rowClickEntityId == null ? 43 : ((Object)$rowClickEntityId).hashCode());
        List $allFields = this.getAllFields();
        result = result * 59 + ($allFields == null ? 43 : ((Object)$allFields).hashCode());
        String $runtimeFilters = this.getRuntimeFilters();
        result = result * 59 + ($runtimeFilters == null ? 43 : $runtimeFilters.hashCode());
        String $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        DateAggregationType $cachingDateAggregation = this.getCachingDateAggregation();
        result = result * 59 + ($cachingDateAggregation == null ? 43 : $cachingDateAggregation.hashCode());
        DateAggregationUnit $refreshFrequencyTimeUnit = this.getRefreshFrequencyTimeUnit();
        result = result * 59 + ($refreshFrequencyTimeUnit == null ? 43 : $refreshFrequencyTimeUnit.hashCode());
        DateAggregationUnit $calculatedTelemetrySavingExecutionTimeUnit = this.getCalculatedTelemetrySavingExecutionTimeUnit();
        result = result * 59 + ($calculatedTelemetrySavingExecutionTimeUnit == null ? 43 : $calculatedTelemetrySavingExecutionTimeUnit.hashCode());
        String $datePickerConfig = this.getDatePickerConfig();
        result = result * 59 + ($datePickerConfig == null ? 43 : $datePickerConfig.hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        return result;
    }

    public String toString() {
        return "ViewConfigDto(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", collectionId=" + String.valueOf(this.getCollectionId()) + ", parentPath=" + this.getParentPath() + ", favorite=" + this.isFavorite() + ", name=" + this.getName() + ", viewType=" + this.getViewType() + ", configDefinition=" + this.getConfigDefinition() + ", rootEntityId=" + String.valueOf(this.getRootEntityId()) + ", rowClickEntityId=" + String.valueOf(this.getRowClickEntityId()) + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", allFields=" + String.valueOf(this.getAllFields()) + ", runtimeFilters=" + this.getRuntimeFilters() + ", settings=" + this.getSettings() + ", useReportCache=" + this.getUseReportCache() + ", usePersistedCacheTelemetry=" + this.getUsePersistedCacheTelemetry() + ", cachingDateAggregation=" + String.valueOf(this.getCachingDateAggregation()) + ", autoRefreshCache=" + this.getAutoRefreshCache() + ", refreshFrequencyTimeUnit=" + String.valueOf(this.getRefreshFrequencyTimeUnit()) + ", refreshFrequencyTimeUnitCount=" + this.getRefreshFrequencyTimeUnitCount() + ", enableCalculatedTelemetrySaving=" + this.isEnableCalculatedTelemetrySaving() + ", calculatedTelemetrySavingExecutionTimeUnit=" + String.valueOf(this.getCalculatedTelemetrySavingExecutionTimeUnit()) + ", calculatedTelemetrySavingExecutionTimeUnitCount=" + this.getCalculatedTelemetrySavingExecutionTimeUnitCount() + ", datePickerConfig=" + this.getDatePickerConfig() + ", tzName=" + this.getTzName() + ")";
    }
}

