/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.view;

import jakarta.persistence.EntityManager;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.view.ViewConfigDto;
import org.thingsboard.trendz.dao.view.ViewConfigRepository;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigLite;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigSortingField;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;

@Service
@Transactional
public class ViewConfigDao {
    private static final Logger log = LoggerFactory.getLogger(ViewConfigDao.class);
    private final ViewConfigRepository viewConfigRepository;
    private final EntityManager entityManager;

    @Autowired
    public ViewConfigDao(ViewConfigRepository viewConfigRepository, EntityManager entityManager) {
        this.viewConfigRepository = viewConfigRepository;
        this.entityManager = entityManager;
    }

    public Set<ViewConfig> getAll(JwtSecurityUser user, Set<UUID> customerIdSet) {
        return this.viewConfigRepository.findAllByUserSet(user.getTenantId(), customerIdSet).stream().map(ViewConfigDto::toData).collect(Collectors.toSet());
    }

    public Page<ViewConfigLite> getAllLite(JwtSecurityUser user, Set<UUID> customerIdSet, int page, int pageSize, List<ViewConfigSortingField> sortingFields) {
        List<Sort.Order> orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).toList();
        return this.viewConfigRepository.findAllLiteByUserSet(user.getTenantId(), customerIdSet, PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
    }

    public Set<ViewConfigLite> getAllLiteByIdSet(JwtSecurityUser user, Set<UUID> customerIdSet, Set<UUID> configIdSet) {
        if (configIdSet.isEmpty() || customerIdSet.isEmpty()) {
            return Set.of();
        }
        return this.viewConfigRepository.findAllLiteByUserSetAndConfigIdSet(user.getTenantId(), customerIdSet, configIdSet).stream().map(arg_0 -> this.mapArrayToObject(arg_0)).collect(Collectors.toSet());
    }

    public Page<ViewConfigLite> getAllLiteByCollection(JwtSecurityUser user, Set<UUID> customerIdSet, UUID collectionId, int page, int pageSize, List<ViewConfigSortingField> sortingFields) {
        List<Sort.Order> orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).toList();
        return this.viewConfigRepository.findAllLiteByUserSetAndCollectionId(user.getTenantId(), customerIdSet, collectionId, PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
    }

    public Set<ViewConfigLite> getAllLiteByCollectionSet(JwtSecurityUser user, Set<UUID> customerIdSet, Set<UUID> collectionIdSet) {
        return this.viewConfigRepository.findAllLiteByUserSetAndCollectionIdSet(user.getTenantId(), customerIdSet, collectionIdSet).stream().map(arg_0 -> this.mapArrayToObject(arg_0)).collect(Collectors.toSet());
    }

    public Page<ViewConfigLite> getAllLiteByWord(JwtSecurityUser user, Set<UUID> customerIdSet, String prefix, int page, int pageSize, List<ViewConfigSortingField> sortingFields) {
        List<Sort.Order> orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).toList();
        return this.viewConfigRepository.findAllLiteByUserSetAndWord(user.getTenantId(), customerIdSet, prefix, PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
    }

    public Optional<ViewConfig> findByUserAndId(JwtSecurityUser user, Set<UUID> customerIdSet, UUID id, boolean insecure) {
        return this.viewConfigRepository.findByIdAndUserSet(id, user.getTenantId(), customerIdSet, insecure).map(vc -> {
            this.entityManager.detach(vc);
            return vc;
        }).map(ViewConfigDto::toData);
    }

    public void rename(String newName, JwtSecurityUser user, Set<UUID> customerIdSet, UUID id) {
        this.viewConfigRepository.renameByIdAndUserSet(newName, id, user.getTenantId(), customerIdSet);
    }

    public ViewConfig save(JwtSecurityUser user, ViewConfig viewConfig) {
        viewConfig.setTenantId(user.getTenantId());
        viewConfig.setCustomerId(user.getCustomerId());
        if (viewConfig.getCollectionId() == null) {
            viewConfig.setCollectionId(EntityId.NULL_UUID);
        }
        ViewConfigDto viewConfigDto = ViewConfigDto.from((ViewConfig)viewConfig);
        return ((ViewConfigDto)this.viewConfigRepository.save((Object)viewConfigDto)).toData();
    }

    public void deleteById(JwtSecurityUser user, Set<UUID> customerIdSet, UUID id) {
        this.viewConfigRepository.deleteByIdAndUserSet(id, user.getTenantId(), customerIdSet);
    }

    public void deleteByIdSet(JwtSecurityUser user, Set<UUID> customerIdSet, Set<UUID> idSet) {
        this.viewConfigRepository.deleteByIdSetAndUserSet(idSet, user.getTenantId(), customerIdSet);
    }

    public void moveByIdSetAndParent(JwtSecurityUser user, Set<UUID> customerIdSet, Set<UUID> idSet, UUID parent) {
        this.viewConfigRepository.moveByIdSetAndParent(idSet, user.getTenantId(), customerIdSet, parent);
    }

    public Page<ViewConfigLite> getAllFavorite(JwtSecurityUser user, Set<UUID> customerIdSet, int page, int pageSize, List<ViewConfigSortingField> sortingFields) {
        List<Sort.Order> orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).toList();
        return this.viewConfigRepository.findAllFavoriteByUserSet(user.getTenantId(), customerIdSet, PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
    }

    public void addToFavorite(JwtSecurityUser user, Set<UUID> customerIdSet, UUID id) {
        this.viewConfigRepository.setFavoriteByIdAndUserSet(true, id, user.getTenantId(), customerIdSet);
    }

    public void removeFromFavorite(JwtSecurityUser user, Set<UUID> customerIdSet, UUID id) {
        this.viewConfigRepository.setFavoriteByIdAndUserSet(false, id, user.getTenantId(), customerIdSet);
    }

    public void setParentPathByParentId(JwtSecurityUser user, Set<UUID> customerIdSet, UUID parentId, String path) {
        this.viewConfigRepository.setParentPathByIdSetAndUserSet(user.getTenantId(), customerIdSet, parentId, path);
    }

    private ViewConfigLite mapArrayToObject(Object[] dataArray) {
        int i = 0;
        return ViewConfigLite.builder().id((UUID)dataArray[i++]).tenantId((UUID)dataArray[i++]).customerId((UUID)dataArray[i++]).collectionId((UUID)dataArray[i++]).parentPath((String)dataArray[i++]).name((String)dataArray[i++]).viewType(ViewType.valueOf((String)((String)dataArray[i++]))).createdAt(((Long)dataArray[i++]).longValue()).updatedAt(((Long)dataArray[i++]).longValue()).favorite(((Boolean)dataArray[i++]).booleanValue()).taskStatus(null).build();
    }
}

