/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.view;

import jakarta.persistence.EntityManager;
import jakarta.transaction.Transactional;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.view.ViewCollectionDto;
import org.thingsboard.trendz.dao.view.ViewCollectionRepository;
import org.thingsboard.trendz.domain.definition.view.config.ViewCollection;
import org.thingsboard.trendz.exception.view.TrendzViewException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;

@Service
@Transactional
public class ViewCollectionDao {
    private static final Logger log = LoggerFactory.getLogger(ViewCollectionDao.class);
    private final ViewCollectionRepository viewCollectionRepository;
    private final EntityManager entityManager;

    public ViewCollectionDao(ViewCollectionRepository viewCollectionRepository, EntityManager entityManager) {
        this.viewCollectionRepository = viewCollectionRepository;
        this.entityManager = entityManager;
    }

    public Set<ViewCollection> findAll(JwtSecurityUser user, Set<UUID> customerIdSet) {
        return this.viewCollectionRepository.findAllByUserSet(user.getTenantId(), customerIdSet).stream().map(ViewCollectionDto::toData).collect(Collectors.toSet());
    }

    public Set<ViewCollection> findAllByIdSet(JwtSecurityUser user, Set<UUID> customerIdSet, Set<UUID> idSet) {
        return this.viewCollectionRepository.findAllByIdSetAndUserSet(user.getTenantId(), customerIdSet, idSet).stream().map(ViewCollectionDto::toData).collect(Collectors.toSet());
    }

    public Set<ViewCollection> findAllByParentCollectionSet(JwtSecurityUser user, Set<UUID> customerIdSet, Set<UUID> parentCollectionIdSet) {
        return this.viewCollectionRepository.findAllByParentCollectionSetAndUserSet(parentCollectionIdSet, user.getTenantId(), customerIdSet).stream().map(ViewCollectionDto::toData).collect(Collectors.toSet());
    }

    public Set<ViewCollection> findAllByPrefix(JwtSecurityUser user, Set<UUID> customerIdSet, String prefix) {
        return this.viewCollectionRepository.findAllByUserSetAndPrefix(user.getTenantId(), customerIdSet, prefix).stream().map(ViewCollectionDto::toData).collect(Collectors.toSet());
    }

    public Optional<ViewCollection> findByIdAndUserSet(JwtSecurityUser user, Set<UUID> customerIdSet, UUID id) {
        return this.viewCollectionRepository.findByIdAndUserSet(id, user.getTenantId(), customerIdSet).map(vc -> {
            this.entityManager.detach(vc);
            return vc;
        }).map(ViewCollectionDto::toData);
    }

    public void renameById(String newName, JwtSecurityUser user, Set<UUID> customerIdSet, UUID id) {
        this.viewCollectionRepository.renameByUserSetAndId(newName, id, user.getTenantId(), customerIdSet);
    }

    public ViewCollection save(JwtSecurityUser user, ViewCollection collection) {
        long now = System.currentTimeMillis();
        if (collection.getId() == null) {
            collection.setCreationTs(now);
        }
        collection.setUpdateTs(now);
        collection.setTenantId(user.getTenantId());
        collection.setCustomerId(user.getCustomerId());
        if (collection.getParentId() == null) {
            collection.setParentId(EntityId.NULL_UUID);
        }
        if (StringUtils.isEmpty((CharSequence)collection.getName())) {
            throw new TrendzViewException("Collection name must not be empty");
        }
        ViewCollectionDto dto = (ViewCollectionDto)this.viewCollectionRepository.save((Object)ViewCollectionDto.from((ViewCollection)collection));
        return dto.toData();
    }

    public void deleteById(JwtSecurityUser user, Set<UUID> customerIdSet, UUID id) {
        this.viewCollectionRepository.deleteByUserSetAndId(id, user.getTenantId(), customerIdSet);
    }

    public void deleteByIdSet(JwtSecurityUser user, Set<UUID> customerIdSet, Set<UUID> idSet) {
        this.viewCollectionRepository.deleteByUserSetAndIdSet(idSet, user.getTenantId(), customerIdSet);
    }

    public void moveByIdSetAndParent(JwtSecurityUser user, Set<UUID> customerIdSet, Set<UUID> idSet, UUID parentId) {
        this.viewCollectionRepository.moveByUserSetAndIdSetAndParentId(idSet, user.getTenantId(), customerIdSet, parentId);
    }

    public List<String> getParentPathById(JwtSecurityUser user, Set<UUID> customerIdSet, UUID id) {
        List<String> path = this.viewCollectionRepository.getParentPathById(id, user.getTenantId(), customerIdSet).stream().map(objects -> (String)objects[0]).collect(Collectors.toList());
        Collections.reverse(path);
        return path;
    }
}

