/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.UUID;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.trendz.dao.task.TaskSequenceItemDto;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskSequenceItem;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="trendz_task_sequence_item")
public class TaskSequenceItemDto {
    @Id
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    @Column(name="id")
    private UUID id;
    @Column(name="sequence_id")
    private UUID sequenceId;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="type", column=@Column(name="reference_type")), @AttributeOverride(name="key", column=@Column(name="reference_key"))})
    private TaskReference reference;
    @Column(name="order_number")
    private int orderNumber;
    @Column(name="execution_delay_ms")
    private long executionDelayMs;

    public TaskSequenceItem toData() {
        return TaskSequenceItem.builder().id(this.id).reference(this.reference).orderNumber(this.orderNumber).executionDelayMs(this.executionDelayMs).build();
    }

    public static TaskSequenceItemDto from(TaskSequenceItem entity, UUID sequenceId) {
        return TaskSequenceItemDto.builder().id(entity.getId()).sequenceId(sequenceId).reference(entity.getReference()).orderNumber(entity.getOrderNumber()).executionDelayMs(entity.getExecutionDelayMs()).build();
    }

    public static TaskSequenceItemDtoBuilder builder() {
        return new TaskSequenceItemDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getSequenceId() {
        return this.sequenceId;
    }

    public TaskReference getReference() {
        return this.reference;
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public long getExecutionDelayMs() {
        return this.executionDelayMs;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setSequenceId(UUID sequenceId) {
        this.sequenceId = sequenceId;
    }

    public void setReference(TaskReference reference) {
        this.reference = reference;
    }

    public void setOrderNumber(int orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setExecutionDelayMs(long executionDelayMs) {
        this.executionDelayMs = executionDelayMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskSequenceItemDto)) {
            return false;
        }
        TaskSequenceItemDto other = (TaskSequenceItemDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getOrderNumber() != other.getOrderNumber()) {
            return false;
        }
        if (this.getExecutionDelayMs() != other.getExecutionDelayMs()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$sequenceId = this.getSequenceId();
        UUID other$sequenceId = other.getSequenceId();
        if (this$sequenceId == null ? other$sequenceId != null : !((Object)this$sequenceId).equals(other$sequenceId)) {
            return false;
        }
        TaskReference this$reference = this.getReference();
        TaskReference other$reference = other.getReference();
        return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskSequenceItemDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOrderNumber();
        long $executionDelayMs = this.getExecutionDelayMs();
        result = result * 59 + (int)($executionDelayMs >>> 32 ^ $executionDelayMs);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $sequenceId = this.getSequenceId();
        result = result * 59 + ($sequenceId == null ? 43 : ((Object)$sequenceId).hashCode());
        TaskReference $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        return result;
    }

    public String toString() {
        return "TaskSequenceItemDto(id=" + String.valueOf(this.getId()) + ", sequenceId=" + String.valueOf(this.getSequenceId()) + ", reference=" + String.valueOf(this.getReference()) + ", orderNumber=" + this.getOrderNumber() + ", executionDelayMs=" + this.getExecutionDelayMs() + ")";
    }

    public TaskSequenceItemDto() {
    }

    public TaskSequenceItemDto(UUID id, UUID sequenceId, TaskReference reference, int orderNumber, long executionDelayMs) {
        this.id = id;
        this.sequenceId = sequenceId;
        this.reference = reference;
        this.orderNumber = orderNumber;
        this.executionDelayMs = executionDelayMs;
    }
}

