/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.trendz.dao.task.TaskSequenceDto;
import org.thingsboard.trendz.dao.task.TaskSequenceItemDto;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.service.task.model.TaskSequence;
import org.thingsboard.trendz.service.task.model.TaskSequenceItem;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="trendz_task_sequence")
public class TaskSequenceDto {
    @Id
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    @Column(name="id")
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="customer_id")
    private UUID customerId;
    @Column(name="user_id")
    private UUID userId;
    @Column(name="created_ts")
    private long createdTs;
    @Column(name="updated_ts")
    private long updatedTs;
    @Column(name="name")
    private String name;
    @Column(name="enabled")
    private Boolean enabled;
    @Column(name="json_configs")
    private String jsonConfigs;
    @OneToMany(mappedBy="sequenceId", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @Fetch(value=FetchMode.JOIN)
    private Set<TaskSequenceItemDto> taskSequenceItems;

    public TaskSequence toData() {
        JsonNode jsonConfigsNode = JsonUtils.toNodeFromRaw((String)this.jsonConfigs);
        TaskSchedule schedule = (TaskSchedule)JsonUtils.fromNodeToObject((JsonNode)jsonConfigsNode.get("schedule"), TaskSchedule.class);
        return TaskSequence.builder().id(this.id).user(new JwtSecurityUser(this.tenantId, this.customerId, this.userId)).createdTs(this.createdTs).updatedTs(this.updatedTs).name(this.name).enabled(this.enabled.booleanValue()).schedule(schedule).sequenceItems(this.taskSequenceItems.stream().map(TaskSequenceItemDto::toData).sorted().toList()).build();
    }

    public static TaskSequenceDto from(TaskSequence entity) {
        ObjectNode node = JsonUtils.getObjectMapper().createObjectNode();
        node.set("schedule", JsonUtils.toNodeFromObject((Object)entity.getSchedule()));
        String jsonConfigs = JsonUtils.fromNodeToRaw((JsonNode)node);
        return TaskSequenceDto.builder().id(entity.getId()).tenantId(entity.getUser().getTenantId()).customerId(entity.getUser().getCustomerId()).userId(entity.getUser().getUserId()).createdTs(entity.getCreatedTs()).updatedTs(entity.getUpdatedTs()).name(entity.getName()).enabled(Boolean.valueOf(entity.isEnabled())).jsonConfigs(jsonConfigs).taskSequenceItems(entity.getSequenceItems().stream().map(item -> TaskSequenceItemDto.from((TaskSequenceItem)item, (UUID)entity.getId())).collect(Collectors.toSet())).build();
    }

    public static TaskSequenceDtoBuilder builder() {
        return new TaskSequenceDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public UUID getCustomerId() {
        return this.customerId;
    }

    public UUID getUserId() {
        return this.userId;
    }

    public long getCreatedTs() {
        return this.createdTs;
    }

    public long getUpdatedTs() {
        return this.updatedTs;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getJsonConfigs() {
        return this.jsonConfigs;
    }

    public Set<TaskSequenceItemDto> getTaskSequenceItems() {
        return this.taskSequenceItems;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    public void setUpdatedTs(long updatedTs) {
        this.updatedTs = updatedTs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setJsonConfigs(String jsonConfigs) {
        this.jsonConfigs = jsonConfigs;
    }

    public void setTaskSequenceItems(Set<TaskSequenceItemDto> taskSequenceItems) {
        this.taskSequenceItems = taskSequenceItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskSequenceDto)) {
            return false;
        }
        TaskSequenceDto other = (TaskSequenceDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getUpdatedTs() != other.getUpdatedTs()) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$jsonConfigs = this.getJsonConfigs();
        String other$jsonConfigs = other.getJsonConfigs();
        if (this$jsonConfigs == null ? other$jsonConfigs != null : !this$jsonConfigs.equals(other$jsonConfigs)) {
            return false;
        }
        Set this$taskSequenceItems = this.getTaskSequenceItems();
        Set other$taskSequenceItems = other.getTaskSequenceItems();
        return !(this$taskSequenceItems == null ? other$taskSequenceItems != null : !((Object)this$taskSequenceItems).equals(other$taskSequenceItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskSequenceDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $updatedTs = this.getUpdatedTs();
        result = result * 59 + (int)($updatedTs >>> 32 ^ $updatedTs);
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $jsonConfigs = this.getJsonConfigs();
        result = result * 59 + ($jsonConfigs == null ? 43 : $jsonConfigs.hashCode());
        Set $taskSequenceItems = this.getTaskSequenceItems();
        result = result * 59 + ($taskSequenceItems == null ? 43 : ((Object)$taskSequenceItems).hashCode());
        return result;
    }

    public String toString() {
        return "TaskSequenceDto(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", userId=" + String.valueOf(this.getUserId()) + ", createdTs=" + this.getCreatedTs() + ", updatedTs=" + this.getUpdatedTs() + ", name=" + this.getName() + ", enabled=" + this.getEnabled() + ", jsonConfigs=" + this.getJsonConfigs() + ", taskSequenceItems=" + String.valueOf(this.getTaskSequenceItems()) + ")";
    }

    public TaskSequenceDto() {
    }

    public TaskSequenceDto(UUID id, UUID tenantId, UUID customerId, UUID userId, long createdTs, long updatedTs, String name, Boolean enabled, String jsonConfigs, Set<TaskSequenceItemDto> taskSequenceItems) {
        this.id = id;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.userId = userId;
        this.createdTs = createdTs;
        this.updatedTs = updatedTs;
        this.name = name;
        this.enabled = enabled;
        this.jsonConfigs = jsonConfigs;
        this.taskSequenceItems = taskSequenceItems;
    }
}

