/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.task.TaskExecutionRequestDto;
import org.thingsboard.trendz.dao.task.TaskExecutionRequestDtoId;

@Repository
public interface TaskExecutionRequestRepository
extends CrudRepository<TaskExecutionRequestDto, TaskExecutionRequestDtoId> {
    @Query(value="SELECT ter\nFROM TaskExecutionRequestDto ter\nWHERE\n    ter.executionId = :executionId AND\n    ter.tenantId = :tenantId AND\n    (coalesce(:customerId, null) IS NULL OR ter.customerId = :customerId)\n")
    public Optional<TaskExecutionRequestDto> findByExecutionIdAndTenantIdAndCustomerId(@Param(value="executionId") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3);

    @Query(value="DELETE FROM TaskExecutionRequestDto ter\nWHERE\n    ter.tenantId = :tenantId AND\n    (coalesce(:customerId, null) IS NULL OR ter.customerId = :customerId)\n")
    @Modifying
    public void removeAllByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2);

    @Query(value="DELETE FROM TaskExecutionRequestDto ter\nWHERE\n    ter.taskId = :taskId AND\n    ter.tenantId = :tenantId AND\n    (coalesce(:customerId, null) IS NULL OR ter.customerId = :customerId)\n")
    @Modifying
    public void removeAllByTaskIdAndTenantIdAndCustomerId(@Param(value="taskId") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3);
}

