/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.trendz.dao.task.TaskDto;
import org.thingsboard.trendz.dao.task.TaskExecutionDto;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskExecutionProgressContent;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskRetryPolicy;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.service.task.model.TaskScheduleType;
import org.thingsboard.trendz.service.task.model.TaskStoreExecutionConfig;
import org.thingsboard.trendz.service.task.model.TaskTimeoutConfig;
import org.thingsboard.trendz.service.task.model.TaskTtlConfig;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="trendz_task")
public class TaskDto {
    @Id
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    @Column(name="id")
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="customer_id")
    private UUID customerId;
    @Column(name="user_id")
    private UUID userId;
    @Column(name="created_ts")
    private long createdTs;
    @Column(name="updated_ts")
    private long updatedTs;
    @Column(name="name")
    private String name;
    @Column(name="enabled")
    private boolean enabled;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="type", column=@Column(name="reference_type")), @AttributeOverride(name="key", column=@Column(name="reference_key"))})
    private TaskReference reference;
    @Column(name="job_type")
    @Enumerated(value=EnumType.STRING)
    private TaskJobType jobType;
    @Column(name="json_job")
    private String jsonJob;
    @Column(name="schedule_type")
    @Enumerated(value=EnumType.STRING)
    private TaskScheduleType scheduleType;
    @Column(name="schedule_period_ts")
    private long schedulePeriodTs;
    @Column(name="schedule_planned_ts")
    private long schedulePlannedTs;
    @Enumerated(value=EnumType.STRING)
    @Column(name="schedule_scheduling_unit")
    private ChronoUnit scheduleSchedulingUnit;
    @Column(name="schedule_scheduling_unit_count")
    private int scheduleSchedulingUnitCount;
    @Column(name="schedule_scheduling_time_zone")
    private String scheduleSchedulingTimeZone;
    @Column(name="ttl_enabled")
    private boolean ttlEnabled;
    @Column(name="ttl_duration")
    private long ttlDuration;
    @Column(name="store_execution_enabled")
    private boolean storeExecutionEnabled;
    @Column(name="store_execution_count")
    private int storeExecutionCount;
    @Column(name="json_configs")
    private String jsonConfigs;
    @OneToMany(mappedBy="taskId", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private List<TaskExecutionDto> taskExecutions;

    public Task toData(Class<? extends TaskJob> jobClass, Class<? extends TaskExecutionProgressContent> progressContentClass) {
        List executions = this.taskExecutions.stream().map(dto -> dto.toData(jobClass, progressContentClass)).sorted().collect(Collectors.toList());
        Task taskLite = this.toDataLite(jobClass);
        taskLite.setExecutions(executions);
        return taskLite;
    }

    public Task toDataLite(Class<? extends TaskJob> jobClass) {
        JsonNode jsonConfigsNode = JsonUtils.toNodeFromRaw((String)this.jsonConfigs);
        TaskTimeoutConfig timeoutConfig = (TaskTimeoutConfig)JsonUtils.fromNodeToObject((JsonNode)jsonConfigsNode.get("timeoutConfig"), TaskTimeoutConfig.class);
        TaskRetryPolicy retryPolicy = (TaskRetryPolicy)JsonUtils.fromNodeToObject((JsonNode)jsonConfigsNode.get("retryPolicy"), TaskRetryPolicy.class);
        TaskJob job = (TaskJob)JsonUtils.fromJson((String)this.jsonJob, jobClass);
        return Task.builder().id(this.id).user(new JwtSecurityUser(this.tenantId, this.customerId, this.userId)).createdTs(this.createdTs).updatedTs(this.updatedTs).name(this.name).enabled(this.enabled).schedule(TaskSchedule.builder().type(this.scheduleType).periodMs(this.schedulePeriodTs).plannedTs(this.schedulePlannedTs).schedulingUnit(this.scheduleSchedulingUnit).schedulingUnitCount(this.scheduleSchedulingUnitCount).schedulingTimeZone(this.scheduleSchedulingTimeZone).build()).ttlConfig(new TaskTtlConfig(this.ttlEnabled, this.ttlDuration)).storeExecutionConfig(new TaskStoreExecutionConfig(this.storeExecutionEnabled, this.storeExecutionCount)).timeoutConfig(timeoutConfig).retryPolicy(retryPolicy).jobType(this.jobType).job(job).reference(this.reference).executions(null).build();
    }

    public static TaskDto from(Task entity) {
        ObjectNode node = JsonUtils.getObjectMapper().createObjectNode();
        node.set("timeoutConfig", JsonUtils.toNodeFromObject((Object)entity.getTimeoutConfig()));
        node.set("retryPolicy", JsonUtils.toNodeFromObject((Object)entity.getRetryPolicy()));
        String jsonConfigs = JsonUtils.fromNodeToRaw((JsonNode)node);
        return TaskDto.builder().id(entity.getId()).tenantId(entity.getUser().getTenantId()).customerId(entity.getUser().getCustomerId()).userId(entity.getUser().getUserId()).createdTs(entity.getCreatedTs()).updatedTs(entity.getUpdatedTs()).name(entity.getName()).enabled(entity.isEnabled()).reference(entity.getReference()).jobType(entity.getJobType()).jsonJob(JsonUtils.toJson((Object)entity.getJob())).scheduleType(entity.getSchedule().getType()).schedulePeriodTs(entity.getSchedule().getPeriodMs()).schedulePlannedTs(entity.getSchedule().getPlannedTs()).scheduleSchedulingUnit(entity.getSchedule().getSchedulingUnit()).scheduleSchedulingUnitCount(entity.getSchedule().getSchedulingUnitCount()).scheduleSchedulingTimeZone("Europe/Kiev".equals(entity.getSchedule().getSchedulingTimeZone()) ? "Europe/Kyiv" : entity.getSchedule().getSchedulingTimeZone()).ttlEnabled(entity.getTtlConfig().isEnabled()).ttlDuration(entity.getTtlConfig().getDuration()).storeExecutionEnabled(entity.getStoreExecutionConfig().isEnabled()).storeExecutionCount(entity.getStoreExecutionConfig().getCount()).jsonConfigs(jsonConfigs).taskExecutions(entity.getExecutions().stream().map(TaskExecutionDto::from).collect(Collectors.toList())).build();
    }

    public static TaskDtoBuilder builder() {
        return new TaskDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public UUID getCustomerId() {
        return this.customerId;
    }

    public UUID getUserId() {
        return this.userId;
    }

    public long getCreatedTs() {
        return this.createdTs;
    }

    public long getUpdatedTs() {
        return this.updatedTs;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TaskReference getReference() {
        return this.reference;
    }

    public TaskJobType getJobType() {
        return this.jobType;
    }

    public String getJsonJob() {
        return this.jsonJob;
    }

    public TaskScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public long getSchedulePeriodTs() {
        return this.schedulePeriodTs;
    }

    public long getSchedulePlannedTs() {
        return this.schedulePlannedTs;
    }

    public ChronoUnit getScheduleSchedulingUnit() {
        return this.scheduleSchedulingUnit;
    }

    public int getScheduleSchedulingUnitCount() {
        return this.scheduleSchedulingUnitCount;
    }

    public String getScheduleSchedulingTimeZone() {
        return this.scheduleSchedulingTimeZone;
    }

    public boolean isTtlEnabled() {
        return this.ttlEnabled;
    }

    public long getTtlDuration() {
        return this.ttlDuration;
    }

    public boolean isStoreExecutionEnabled() {
        return this.storeExecutionEnabled;
    }

    public int getStoreExecutionCount() {
        return this.storeExecutionCount;
    }

    public String getJsonConfigs() {
        return this.jsonConfigs;
    }

    public List<TaskExecutionDto> getTaskExecutions() {
        return this.taskExecutions;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    public void setUpdatedTs(long updatedTs) {
        this.updatedTs = updatedTs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setReference(TaskReference reference) {
        this.reference = reference;
    }

    public void setJobType(TaskJobType jobType) {
        this.jobType = jobType;
    }

    public void setJsonJob(String jsonJob) {
        this.jsonJob = jsonJob;
    }

    public void setScheduleType(TaskScheduleType scheduleType) {
        this.scheduleType = scheduleType;
    }

    public void setSchedulePeriodTs(long schedulePeriodTs) {
        this.schedulePeriodTs = schedulePeriodTs;
    }

    public void setSchedulePlannedTs(long schedulePlannedTs) {
        this.schedulePlannedTs = schedulePlannedTs;
    }

    public void setScheduleSchedulingUnit(ChronoUnit scheduleSchedulingUnit) {
        this.scheduleSchedulingUnit = scheduleSchedulingUnit;
    }

    public void setScheduleSchedulingUnitCount(int scheduleSchedulingUnitCount) {
        this.scheduleSchedulingUnitCount = scheduleSchedulingUnitCount;
    }

    public void setScheduleSchedulingTimeZone(String scheduleSchedulingTimeZone) {
        this.scheduleSchedulingTimeZone = scheduleSchedulingTimeZone;
    }

    public void setTtlEnabled(boolean ttlEnabled) {
        this.ttlEnabled = ttlEnabled;
    }

    public void setTtlDuration(long ttlDuration) {
        this.ttlDuration = ttlDuration;
    }

    public void setStoreExecutionEnabled(boolean storeExecutionEnabled) {
        this.storeExecutionEnabled = storeExecutionEnabled;
    }

    public void setStoreExecutionCount(int storeExecutionCount) {
        this.storeExecutionCount = storeExecutionCount;
    }

    public void setJsonConfigs(String jsonConfigs) {
        this.jsonConfigs = jsonConfigs;
    }

    public void setTaskExecutions(List<TaskExecutionDto> taskExecutions) {
        this.taskExecutions = taskExecutions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskDto)) {
            return false;
        }
        TaskDto other = (TaskDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getUpdatedTs() != other.getUpdatedTs()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getSchedulePeriodTs() != other.getSchedulePeriodTs()) {
            return false;
        }
        if (this.getSchedulePlannedTs() != other.getSchedulePlannedTs()) {
            return false;
        }
        if (this.getScheduleSchedulingUnitCount() != other.getScheduleSchedulingUnitCount()) {
            return false;
        }
        if (this.isTtlEnabled() != other.isTtlEnabled()) {
            return false;
        }
        if (this.getTtlDuration() != other.getTtlDuration()) {
            return false;
        }
        if (this.isStoreExecutionEnabled() != other.isStoreExecutionEnabled()) {
            return false;
        }
        if (this.getStoreExecutionCount() != other.getStoreExecutionCount()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TaskReference this$reference = this.getReference();
        TaskReference other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        TaskJobType this$jobType = this.getJobType();
        TaskJobType other$jobType = other.getJobType();
        if (this$jobType == null ? other$jobType != null : !this$jobType.equals(other$jobType)) {
            return false;
        }
        String this$jsonJob = this.getJsonJob();
        String other$jsonJob = other.getJsonJob();
        if (this$jsonJob == null ? other$jsonJob != null : !this$jsonJob.equals(other$jsonJob)) {
            return false;
        }
        TaskScheduleType this$scheduleType = this.getScheduleType();
        TaskScheduleType other$scheduleType = other.getScheduleType();
        if (this$scheduleType == null ? other$scheduleType != null : !this$scheduleType.equals(other$scheduleType)) {
            return false;
        }
        ChronoUnit this$scheduleSchedulingUnit = this.getScheduleSchedulingUnit();
        ChronoUnit other$scheduleSchedulingUnit = other.getScheduleSchedulingUnit();
        if (this$scheduleSchedulingUnit == null ? other$scheduleSchedulingUnit != null : !this$scheduleSchedulingUnit.equals(other$scheduleSchedulingUnit)) {
            return false;
        }
        String this$scheduleSchedulingTimeZone = this.getScheduleSchedulingTimeZone();
        String other$scheduleSchedulingTimeZone = other.getScheduleSchedulingTimeZone();
        if (this$scheduleSchedulingTimeZone == null ? other$scheduleSchedulingTimeZone != null : !this$scheduleSchedulingTimeZone.equals(other$scheduleSchedulingTimeZone)) {
            return false;
        }
        String this$jsonConfigs = this.getJsonConfigs();
        String other$jsonConfigs = other.getJsonConfigs();
        if (this$jsonConfigs == null ? other$jsonConfigs != null : !this$jsonConfigs.equals(other$jsonConfigs)) {
            return false;
        }
        List this$taskExecutions = this.getTaskExecutions();
        List other$taskExecutions = other.getTaskExecutions();
        return !(this$taskExecutions == null ? other$taskExecutions != null : !((Object)this$taskExecutions).equals(other$taskExecutions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $updatedTs = this.getUpdatedTs();
        result = result * 59 + (int)($updatedTs >>> 32 ^ $updatedTs);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $schedulePeriodTs = this.getSchedulePeriodTs();
        result = result * 59 + (int)($schedulePeriodTs >>> 32 ^ $schedulePeriodTs);
        long $schedulePlannedTs = this.getSchedulePlannedTs();
        result = result * 59 + (int)($schedulePlannedTs >>> 32 ^ $schedulePlannedTs);
        result = result * 59 + this.getScheduleSchedulingUnitCount();
        result = result * 59 + (this.isTtlEnabled() ? 79 : 97);
        long $ttlDuration = this.getTtlDuration();
        result = result * 59 + (int)($ttlDuration >>> 32 ^ $ttlDuration);
        result = result * 59 + (this.isStoreExecutionEnabled() ? 79 : 97);
        result = result * 59 + this.getStoreExecutionCount();
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TaskReference $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        TaskJobType $jobType = this.getJobType();
        result = result * 59 + ($jobType == null ? 43 : $jobType.hashCode());
        String $jsonJob = this.getJsonJob();
        result = result * 59 + ($jsonJob == null ? 43 : $jsonJob.hashCode());
        TaskScheduleType $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : $scheduleType.hashCode());
        ChronoUnit $scheduleSchedulingUnit = this.getScheduleSchedulingUnit();
        result = result * 59 + ($scheduleSchedulingUnit == null ? 43 : $scheduleSchedulingUnit.hashCode());
        String $scheduleSchedulingTimeZone = this.getScheduleSchedulingTimeZone();
        result = result * 59 + ($scheduleSchedulingTimeZone == null ? 43 : $scheduleSchedulingTimeZone.hashCode());
        String $jsonConfigs = this.getJsonConfigs();
        result = result * 59 + ($jsonConfigs == null ? 43 : $jsonConfigs.hashCode());
        List $taskExecutions = this.getTaskExecutions();
        result = result * 59 + ($taskExecutions == null ? 43 : ((Object)$taskExecutions).hashCode());
        return result;
    }

    public String toString() {
        return "TaskDto(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", userId=" + String.valueOf(this.getUserId()) + ", createdTs=" + this.getCreatedTs() + ", updatedTs=" + this.getUpdatedTs() + ", name=" + this.getName() + ", enabled=" + this.isEnabled() + ", reference=" + String.valueOf(this.getReference()) + ", jobType=" + String.valueOf(this.getJobType()) + ", jsonJob=" + this.getJsonJob() + ", scheduleType=" + String.valueOf(this.getScheduleType()) + ", schedulePeriodTs=" + this.getSchedulePeriodTs() + ", schedulePlannedTs=" + this.getSchedulePlannedTs() + ", scheduleSchedulingUnit=" + String.valueOf(this.getScheduleSchedulingUnit()) + ", scheduleSchedulingUnitCount=" + this.getScheduleSchedulingUnitCount() + ", scheduleSchedulingTimeZone=" + this.getScheduleSchedulingTimeZone() + ", ttlEnabled=" + this.isTtlEnabled() + ", ttlDuration=" + this.getTtlDuration() + ", storeExecutionEnabled=" + this.isStoreExecutionEnabled() + ", storeExecutionCount=" + this.getStoreExecutionCount() + ", jsonConfigs=" + this.getJsonConfigs() + ", taskExecutions=" + String.valueOf(this.getTaskExecutions()) + ")";
    }

    public TaskDto() {
    }

    public TaskDto(UUID id, UUID tenantId, UUID customerId, UUID userId, long createdTs, long updatedTs, String name, boolean enabled, TaskReference reference, TaskJobType jobType, String jsonJob, TaskScheduleType scheduleType, long schedulePeriodTs, long schedulePlannedTs, ChronoUnit scheduleSchedulingUnit, int scheduleSchedulingUnitCount, String scheduleSchedulingTimeZone, boolean ttlEnabled, long ttlDuration, boolean storeExecutionEnabled, int storeExecutionCount, String jsonConfigs, List<TaskExecutionDto> taskExecutions) {
        this.id = id;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.userId = userId;
        this.createdTs = createdTs;
        this.updatedTs = updatedTs;
        this.name = name;
        this.enabled = enabled;
        this.reference = reference;
        this.jobType = jobType;
        this.jsonJob = jsonJob;
        this.scheduleType = scheduleType;
        this.schedulePeriodTs = schedulePeriodTs;
        this.schedulePlannedTs = schedulePlannedTs;
        this.scheduleSchedulingUnit = scheduleSchedulingUnit;
        this.scheduleSchedulingUnitCount = scheduleSchedulingUnitCount;
        this.scheduleSchedulingTimeZone = scheduleSchedulingTimeZone;
        this.ttlEnabled = ttlEnabled;
        this.ttlDuration = ttlDuration;
        this.storeExecutionEnabled = storeExecutionEnabled;
        this.storeExecutionCount = storeExecutionCount;
        this.jsonConfigs = jsonConfigs;
        this.taskExecutions = taskExecutions;
    }
}

