/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.system;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.system.ApplicationPropertyDto;
import org.thingsboard.trendz.dao.system.ApplicationPropertyRepository;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;

@Service
public class ApplicationPropertyDao {
    private static final Logger log = LoggerFactory.getLogger(ApplicationPropertyDao.class);
    @Autowired
    private ApplicationPropertyRepository applicationPropertyRepository;

    public List<ApplicationProperty> getAllProperties() {
        return StreamSupport.stream(this.applicationPropertyRepository.findAll().spliterator(), false).map(ApplicationPropertyDto::toData).collect(Collectors.toList());
    }

    public Optional<ApplicationProperty> getPropertyByKey(String key) {
        return this.applicationPropertyRepository.findById((Object)key).map(ApplicationPropertyDto::toData);
    }

    public ApplicationProperty saveProperty(ApplicationProperty applicationProperty) {
        return ((ApplicationPropertyDto)this.applicationPropertyRepository.save((Object)ApplicationPropertyDto.from((ApplicationProperty)applicationProperty))).toData();
    }

    public void deleteProperty(String key) {
        if (this.applicationPropertyRepository.existsById((Object)key)) {
            this.applicationPropertyRepository.deleteById((Object)key);
        }
    }
}

