/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.prediction.segment;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.JavaType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Map;
import java.util.UUID;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.trendz.dao.model.prediction.segment.SegmentDataDto;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentData;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="segment_data")
public class SegmentDataDto {
    @Id
    @Column(name="id")
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    private UUID id;
    @Column(name="model_id")
    private UUID modelId;
    @Column(name="item_id")
    private UUID itemId;
    @Column(name="item_name")
    private String itemName;
    @Column(name="range_start_ts")
    private long rangeStartTs;
    @Column(name="range_end_ts")
    private long rangeEndTs;
    @JsonRawValue
    @Column(name="prehistorical_telemetry")
    private String prehistoricalTelemetry;
    @JsonRawValue
    @Column(name="historical_telemetry")
    private String historicalTelemetry;
    @JsonRawValue
    @Column(name="additional_telemetries")
    private String additionalTelemetries;
    @JsonRawValue
    @Column(name="prediction_telemetry")
    private String predictionTelemetry;

    public SegmentData toData() {
        return SegmentData.builder().id(this.id).modelId(this.modelId).item(new ItemLite(this.itemId, this.itemName)).range(new TimeRange(this.rangeStartTs, this.rangeEndTs)).prehistoricalTelemetry((TimeSeries)JsonUtils.fromJson((String)this.prehistoricalTelemetry, TimeSeries.class)).historicalTelemetry((TimeSeries)JsonUtils.fromJson((String)this.historicalTelemetry, TimeSeries.class)).additionalTelemetries((Map)JsonUtils.fromJson((String)this.additionalTelemetries, (JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructMapType(Map.class, UUID.class, TimeSeries.class))).predictionTelemetry((TimeSeries)JsonUtils.fromJson((String)this.predictionTelemetry, TimeSeries.class)).build();
    }

    public static SegmentDataDto from(SegmentData entity) {
        return SegmentDataDto.builder().id(entity.getId()).modelId(entity.getModelId()).itemId(entity.getItem().getId()).itemName(entity.getItem().getName()).rangeStartTs(entity.getRange().getStartTs()).rangeEndTs(entity.getRange().getEndTs()).prehistoricalTelemetry(JsonUtils.toJson((Object)entity.getPrehistoricalTelemetry())).historicalTelemetry(JsonUtils.toJson((Object)entity.getHistoricalTelemetry())).additionalTelemetries(JsonUtils.toJson((Object)entity.getAdditionalTelemetries())).predictionTelemetry(JsonUtils.toJson((Object)entity.getPredictionTelemetry())).build();
    }

    public static SegmentDataDtoBuilder builder() {
        return new SegmentDataDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getModelId() {
        return this.modelId;
    }

    public UUID getItemId() {
        return this.itemId;
    }

    public String getItemName() {
        return this.itemName;
    }

    public long getRangeStartTs() {
        return this.rangeStartTs;
    }

    public long getRangeEndTs() {
        return this.rangeEndTs;
    }

    public String getPrehistoricalTelemetry() {
        return this.prehistoricalTelemetry;
    }

    public String getHistoricalTelemetry() {
        return this.historicalTelemetry;
    }

    public String getAdditionalTelemetries() {
        return this.additionalTelemetries;
    }

    public String getPredictionTelemetry() {
        return this.predictionTelemetry;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setModelId(UUID modelId) {
        this.modelId = modelId;
    }

    public void setItemId(UUID itemId) {
        this.itemId = itemId;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setRangeStartTs(long rangeStartTs) {
        this.rangeStartTs = rangeStartTs;
    }

    public void setRangeEndTs(long rangeEndTs) {
        this.rangeEndTs = rangeEndTs;
    }

    public void setPrehistoricalTelemetry(String prehistoricalTelemetry) {
        this.prehistoricalTelemetry = prehistoricalTelemetry;
    }

    public void setHistoricalTelemetry(String historicalTelemetry) {
        this.historicalTelemetry = historicalTelemetry;
    }

    public void setAdditionalTelemetries(String additionalTelemetries) {
        this.additionalTelemetries = additionalTelemetries;
    }

    public void setPredictionTelemetry(String predictionTelemetry) {
        this.predictionTelemetry = predictionTelemetry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentDataDto)) {
            return false;
        }
        SegmentDataDto other = (SegmentDataDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getRangeStartTs() != other.getRangeStartTs()) {
            return false;
        }
        if (this.getRangeEndTs() != other.getRangeEndTs()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$modelId = this.getModelId();
        UUID other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !((Object)this$modelId).equals(other$modelId)) {
            return false;
        }
        UUID this$itemId = this.getItemId();
        UUID other$itemId = other.getItemId();
        if (this$itemId == null ? other$itemId != null : !((Object)this$itemId).equals(other$itemId)) {
            return false;
        }
        String this$itemName = this.getItemName();
        String other$itemName = other.getItemName();
        if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
            return false;
        }
        String this$prehistoricalTelemetry = this.getPrehistoricalTelemetry();
        String other$prehistoricalTelemetry = other.getPrehistoricalTelemetry();
        if (this$prehistoricalTelemetry == null ? other$prehistoricalTelemetry != null : !this$prehistoricalTelemetry.equals(other$prehistoricalTelemetry)) {
            return false;
        }
        String this$historicalTelemetry = this.getHistoricalTelemetry();
        String other$historicalTelemetry = other.getHistoricalTelemetry();
        if (this$historicalTelemetry == null ? other$historicalTelemetry != null : !this$historicalTelemetry.equals(other$historicalTelemetry)) {
            return false;
        }
        String this$additionalTelemetries = this.getAdditionalTelemetries();
        String other$additionalTelemetries = other.getAdditionalTelemetries();
        if (this$additionalTelemetries == null ? other$additionalTelemetries != null : !this$additionalTelemetries.equals(other$additionalTelemetries)) {
            return false;
        }
        String this$predictionTelemetry = this.getPredictionTelemetry();
        String other$predictionTelemetry = other.getPredictionTelemetry();
        return !(this$predictionTelemetry == null ? other$predictionTelemetry != null : !this$predictionTelemetry.equals(other$predictionTelemetry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SegmentDataDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $rangeStartTs = this.getRangeStartTs();
        result = result * 59 + (int)($rangeStartTs >>> 32 ^ $rangeStartTs);
        long $rangeEndTs = this.getRangeEndTs();
        result = result * 59 + (int)($rangeEndTs >>> 32 ^ $rangeEndTs);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : ((Object)$modelId).hashCode());
        UUID $itemId = this.getItemId();
        result = result * 59 + ($itemId == null ? 43 : ((Object)$itemId).hashCode());
        String $itemName = this.getItemName();
        result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
        String $prehistoricalTelemetry = this.getPrehistoricalTelemetry();
        result = result * 59 + ($prehistoricalTelemetry == null ? 43 : $prehistoricalTelemetry.hashCode());
        String $historicalTelemetry = this.getHistoricalTelemetry();
        result = result * 59 + ($historicalTelemetry == null ? 43 : $historicalTelemetry.hashCode());
        String $additionalTelemetries = this.getAdditionalTelemetries();
        result = result * 59 + ($additionalTelemetries == null ? 43 : $additionalTelemetries.hashCode());
        String $predictionTelemetry = this.getPredictionTelemetry();
        result = result * 59 + ($predictionTelemetry == null ? 43 : $predictionTelemetry.hashCode());
        return result;
    }

    public String toString() {
        return "SegmentDataDto(id=" + String.valueOf(this.getId()) + ", modelId=" + String.valueOf(this.getModelId()) + ", itemId=" + String.valueOf(this.getItemId()) + ", itemName=" + this.getItemName() + ", rangeStartTs=" + this.getRangeStartTs() + ", rangeEndTs=" + this.getRangeEndTs() + ", prehistoricalTelemetry=" + this.getPrehistoricalTelemetry() + ", historicalTelemetry=" + this.getHistoricalTelemetry() + ", additionalTelemetries=" + this.getAdditionalTelemetries() + ", predictionTelemetry=" + this.getPredictionTelemetry() + ")";
    }

    public SegmentDataDto() {
    }

    public SegmentDataDto(UUID id, UUID modelId, UUID itemId, String itemName, long rangeStartTs, long rangeEndTs, String prehistoricalTelemetry, String historicalTelemetry, String additionalTelemetries, String predictionTelemetry) {
        this.id = id;
        this.modelId = modelId;
        this.itemId = itemId;
        this.itemName = itemName;
        this.rangeStartTs = rangeStartTs;
        this.rangeEndTs = rangeEndTs;
        this.prehistoricalTelemetry = prehistoricalTelemetry;
        this.historicalTelemetry = historicalTelemetry;
        this.additionalTelemetries = additionalTelemetries;
        this.predictionTelemetry = predictionTelemetry;
    }
}

