/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.prediction.segment;

import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.model.prediction.segment.SegmentDataDto;
import org.thingsboard.trendz.dao.model.prediction.segment.SegmentDataRepository;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentData;

@Service
@Transactional
public class SegmentDataDao {
    private static final Logger log = LoggerFactory.getLogger(SegmentDataDao.class);
    private final SegmentDataRepository segmentDataRepository;

    @Autowired
    public SegmentDataDao(SegmentDataRepository segmentDataRepository) {
        this.segmentDataRepository = segmentDataRepository;
    }

    public List<SegmentData> getAll(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.segmentDataRepository.findAllByTenantIdAndCustomerId(tenantId, customerId).stream().map(SegmentDataDto::toData).toList();
    }

    public List<SegmentData> saveAll(List<SegmentData> segmentDataList) {
        Set dtoSet = segmentDataList.stream().map(SegmentDataDto::from).collect(Collectors.toSet());
        return StreamSupport.stream(this.segmentDataRepository.saveAll(dtoSet).spliterator(), false).map(SegmentDataDto::toData).toList();
    }

    public Set<SegmentData> findByModelIdAndItemSet(UUID modelId, Set<UUID> itemIdSet) {
        Set<UUID> searchSet = itemIdSet.isEmpty() ? null : itemIdSet;
        return this.segmentDataRepository.findAllByModelIdAndItemIdSet(modelId, searchSet).stream().map(SegmentDataDto::toData).collect(Collectors.toSet());
    }

    public void deleteByModelId(UUID modelId) {
        this.segmentDataRepository.deleteAllByModelId(modelId);
    }

    public int saveLastSubset(UUID modelId, List<SegmentData> segmentDataSet, int subsetSize) {
        if (subsetSize <= 0) {
            throw new IllegalArgumentException("Subset size must be greater that 0");
        }
        List<SegmentDataDto> dtoList = segmentDataSet.stream().map(SegmentDataDto::from).toList();
        List<SegmentDataDto> lastDtoList = dtoList.subList(Math.max(dtoList.size() - subsetSize, 0), dtoList.size());
        this.segmentDataRepository.saveAll(lastDtoList);
        this.segmentDataRepository.deleteAllExceptLastNByModelId(modelId, subsetSize);
        return lastDtoList.size();
    }
}

