/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.prediction;

import com.fasterxml.jackson.databind.JavaType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Set;
import java.util.UUID;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelTaskDataDto;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.model.prediction.PredictionModelTaskData;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="prediction_model_task_data")
public class PredictionModelTaskDataDto {
    @Id
    @Column(name="prediction_model_id")
    private UUID predictionModelId;
    @Column(name="item_set_json")
    private String itemSetJson;
    @Column(name="enabled")
    private boolean enabled;
    @Column(name="enabled_partial_fit")
    private boolean enabledPartialFit;
    @Column(name="refresh_time_unit")
    @Enumerated(value=EnumType.STRING)
    private DateAggregationUnit refreshTimeUnit;
    @Column(name="refresh_time_unit_count")
    private int refreshTimeUnitCount;
    @Column(name="refresh_time_unit_truncated")
    private boolean refreshTimeUnitTruncated;

    public PredictionModelTaskData toData() {
        return PredictionModelTaskData.builder().predictionModelId(this.predictionModelId).itemSet((Set)JsonUtils.fromJson((String)this.itemSetJson, (JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(Set.class, ItemLite.class))).enabled(this.enabled).enabledPartialFit(this.enabledPartialFit).refreshTimeUnit(this.refreshTimeUnit).refreshTimeUnitCount(this.refreshTimeUnitCount).refreshTimeUnitTruncated(this.refreshTimeUnitTruncated).build();
    }

    public static PredictionModelTaskDataDto from(PredictionModelTaskData entity) {
        return PredictionModelTaskDataDto.builder().predictionModelId(entity.getPredictionModelId()).itemSetJson(JsonUtils.toJson((Object)entity.getItemSet())).enabled(entity.isEnabled()).enabledPartialFit(entity.isEnabledPartialFit()).refreshTimeUnit(entity.getRefreshTimeUnit()).refreshTimeUnitCount(entity.getRefreshTimeUnitCount()).refreshTimeUnitTruncated(entity.isRefreshTimeUnitTruncated()).build();
    }

    public static PredictionModelTaskDataDtoBuilder builder() {
        return new PredictionModelTaskDataDtoBuilder();
    }

    public UUID getPredictionModelId() {
        return this.predictionModelId;
    }

    public String getItemSetJson() {
        return this.itemSetJson;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnabledPartialFit() {
        return this.enabledPartialFit;
    }

    public DateAggregationUnit getRefreshTimeUnit() {
        return this.refreshTimeUnit;
    }

    public int getRefreshTimeUnitCount() {
        return this.refreshTimeUnitCount;
    }

    public boolean isRefreshTimeUnitTruncated() {
        return this.refreshTimeUnitTruncated;
    }

    public void setPredictionModelId(UUID predictionModelId) {
        this.predictionModelId = predictionModelId;
    }

    public void setItemSetJson(String itemSetJson) {
        this.itemSetJson = itemSetJson;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabledPartialFit(boolean enabledPartialFit) {
        this.enabledPartialFit = enabledPartialFit;
    }

    public void setRefreshTimeUnit(DateAggregationUnit refreshTimeUnit) {
        this.refreshTimeUnit = refreshTimeUnit;
    }

    public void setRefreshTimeUnitCount(int refreshTimeUnitCount) {
        this.refreshTimeUnitCount = refreshTimeUnitCount;
    }

    public void setRefreshTimeUnitTruncated(boolean refreshTimeUnitTruncated) {
        this.refreshTimeUnitTruncated = refreshTimeUnitTruncated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredictionModelTaskDataDto)) {
            return false;
        }
        PredictionModelTaskDataDto other = (PredictionModelTaskDataDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isEnabledPartialFit() != other.isEnabledPartialFit()) {
            return false;
        }
        if (this.getRefreshTimeUnitCount() != other.getRefreshTimeUnitCount()) {
            return false;
        }
        if (this.isRefreshTimeUnitTruncated() != other.isRefreshTimeUnitTruncated()) {
            return false;
        }
        UUID this$predictionModelId = this.getPredictionModelId();
        UUID other$predictionModelId = other.getPredictionModelId();
        if (this$predictionModelId == null ? other$predictionModelId != null : !((Object)this$predictionModelId).equals(other$predictionModelId)) {
            return false;
        }
        String this$itemSetJson = this.getItemSetJson();
        String other$itemSetJson = other.getItemSetJson();
        if (this$itemSetJson == null ? other$itemSetJson != null : !this$itemSetJson.equals(other$itemSetJson)) {
            return false;
        }
        DateAggregationUnit this$refreshTimeUnit = this.getRefreshTimeUnit();
        DateAggregationUnit other$refreshTimeUnit = other.getRefreshTimeUnit();
        return !(this$refreshTimeUnit == null ? other$refreshTimeUnit != null : !this$refreshTimeUnit.equals(other$refreshTimeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PredictionModelTaskDataDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isEnabledPartialFit() ? 79 : 97);
        result = result * 59 + this.getRefreshTimeUnitCount();
        result = result * 59 + (this.isRefreshTimeUnitTruncated() ? 79 : 97);
        UUID $predictionModelId = this.getPredictionModelId();
        result = result * 59 + ($predictionModelId == null ? 43 : ((Object)$predictionModelId).hashCode());
        String $itemSetJson = this.getItemSetJson();
        result = result * 59 + ($itemSetJson == null ? 43 : $itemSetJson.hashCode());
        DateAggregationUnit $refreshTimeUnit = this.getRefreshTimeUnit();
        result = result * 59 + ($refreshTimeUnit == null ? 43 : $refreshTimeUnit.hashCode());
        return result;
    }

    public String toString() {
        return "PredictionModelTaskDataDto(predictionModelId=" + String.valueOf(this.getPredictionModelId()) + ", itemSetJson=" + this.getItemSetJson() + ", enabled=" + this.isEnabled() + ", enabledPartialFit=" + this.isEnabledPartialFit() + ", refreshTimeUnit=" + String.valueOf(this.getRefreshTimeUnit()) + ", refreshTimeUnitCount=" + this.getRefreshTimeUnitCount() + ", refreshTimeUnitTruncated=" + this.isRefreshTimeUnitTruncated() + ")";
    }

    public PredictionModelTaskDataDto() {
    }

    public PredictionModelTaskDataDto(UUID predictionModelId, String itemSetJson, boolean enabled, boolean enabledPartialFit, DateAggregationUnit refreshTimeUnit, int refreshTimeUnitCount, boolean refreshTimeUnitTruncated) {
        this.predictionModelId = predictionModelId;
        this.itemSetJson = itemSetJson;
        this.enabled = enabled;
        this.enabledPartialFit = enabledPartialFit;
        this.refreshTimeUnit = refreshTimeUnit;
        this.refreshTimeUnitCount = refreshTimeUnitCount;
        this.refreshTimeUnitTruncated = refreshTimeUnitTruncated;
    }
}

