/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.prediction;

import jakarta.transaction.Transactional;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelTaskDataDto;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelTaskDataRepository;
import org.thingsboard.trendz.service.model.prediction.PredictionModelTaskData;

@Service
@Transactional
public class PredictionModelTaskDataDao {
    private static final Logger log = LoggerFactory.getLogger(PredictionModelTaskDataDao.class);
    private final PredictionModelTaskDataRepository predictionModelTaskDataRepository;

    @Autowired
    public PredictionModelTaskDataDao(PredictionModelTaskDataRepository predictionModelTaskDataRepository) {
        this.predictionModelTaskDataRepository = predictionModelTaskDataRepository;
    }

    public Optional<PredictionModelTaskData> findById(UUID predictionModelId) {
        return this.predictionModelTaskDataRepository.findById((Object)predictionModelId).map(PredictionModelTaskDataDto::toData);
    }

    public PredictionModelTaskData save(PredictionModelTaskData taskData) {
        PredictionModelTaskDataDto dto = PredictionModelTaskDataDto.from((PredictionModelTaskData)taskData);
        PredictionModelTaskDataDto saved = (PredictionModelTaskDataDto)this.predictionModelTaskDataRepository.save((Object)dto);
        return saved.toData();
    }

    public void delete(UUID predictionModelId) {
        this.predictionModelTaskDataRepository.deleteById((Object)predictionModelId);
    }
}

