/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.prediction;

import jakarta.transaction.Transactional;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelDto;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelRepository;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationItem;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.PredictionModelFilteringField;
import org.thingsboard.trendz.service.model.prediction.PredictionModelLite;
import org.thingsboard.trendz.service.model.prediction.PredictionModelSortingField;
import org.thingsboard.trendz.service.model.prediction.PredictionModelStatus;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodType;
import org.thingsboard.trendz.tools.UUIDUtils;

@Service
@Transactional
public class PredictionModelDao {
    private static final Logger log = LoggerFactory.getLogger(PredictionModelDao.class);
    private final PredictionModelRepository predictionModelRepository;

    @Autowired
    public PredictionModelDao(PredictionModelRepository predictionModelRepository) {
        this.predictionModelRepository = predictionModelRepository;
    }

    public Page<PredictionModelLite> getAllLite(JwtSecurityUser user, int page, int pageSize, List<PredictionModelFilteringField> filteringFields, List<PredictionModelSortingField> sortingFields) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        Map<PredictionModelFilteringField.Type, String> filterMap = filteringFields.stream().filter(filteringField -> filteringField.getType() != PredictionModelFilteringField.Type.BUSINESS_ENTITY_ID).collect(Collectors.toMap(PredictionModelFilteringField::getType, PredictionModelFilteringField::getValue));
        String name = Optional.ofNullable(filterMap.get(PredictionModelFilteringField.Type.NAME)).map(urlEncodedNameParam -> URLDecoder.decode(urlEncodedNameParam, StandardCharsets.UTF_8)).map(String::toLowerCase).orElse(null);
        Boolean enabled = Optional.ofNullable(filterMap.get(PredictionModelFilteringField.Type.ENABLED)).map(Boolean::parseBoolean).orElse(null);
        PredictionModelStatus predictionModelStatus = Optional.ofNullable(filterMap.get(PredictionModelFilteringField.Type.STATUS)).map(PredictionModelStatus::valueOf).orElse(null);
        PredictionMethodType predictionMethodType = Optional.ofNullable(filterMap.get(PredictionModelFilteringField.Type.TYPE)).map(PredictionMethodType::valueOf).orElse(null);
        Set businessEntityIdSet = filteringFields.stream().filter(filteringField -> filteringField.getType() == PredictionModelFilteringField.Type.BUSINESS_ENTITY_ID).map(PredictionModelFilteringField::getValue).map(UUIDUtils::fromStringOrUUID).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> set.isEmpty() ? null : set));
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).collect(Collectors.toList());
        Page modelPage = this.predictionModelRepository.findAllLiteByTenantIdAndCustomerId(tenantId, customerId, name, enabled, predictionModelStatus, predictionMethodType, businessEntityIdSet, (Pageable)PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
        return modelPage;
    }

    public List<PredictionModel> getAll(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.predictionModelRepository.findByTenantIdAndCustomerId(tenantId, customerId).stream().map(PredictionModelDto::toData).toList();
    }

    public Optional<PredictionModel> findById(JwtSecurityUser user, UUID id, boolean insecure) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.predictionModelRepository.findByIdAndTenantIdAndCustomerId(id, tenantId, customerId, insecure).map(PredictionModelDto::toData);
    }

    public PredictionModel save(PredictionModel predictionModel) {
        PredictionModelDto predictionModelDto = PredictionModelDto.from((PredictionModel)predictionModel);
        PredictionModelDto savedDto = (PredictionModelDto)this.predictionModelRepository.save((Object)predictionModelDto);
        return savedDto.toData();
    }

    public void deleteById(JwtSecurityUser user, UUID id) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        this.predictionModelRepository.deleteByIdAndTenantIdAndCustomerId(id, tenantId, customerId);
    }

    public void updateStatus(JwtSecurityUser user, UUID id, PredictionModelStatus status) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        this.predictionModelRepository.updateStatusByIdAndTenantIdAndCustomerId(id, tenantId, customerId, status);
    }

    public void updateEnabling(JwtSecurityUser user, UUID id, boolean enabled) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        this.predictionModelRepository.updateEnablingByIdAndTenantIdAndCustomerId(id, tenantId, customerId, enabled);
    }

    public Optional<PredictionModel> getByEntityFieldId(UUID entityFieldId, JwtSecurityUser user, boolean insecure) {
        return this.predictionModelRepository.findByAssociatedEntityFieldIdAndTenantIdAndCustomerId(entityFieldId, user.getTenantId(), user.getCustomerId(), insecure).map(PredictionModelDto::toData);
    }

    public UUID findByTbKey(JwtSecurityUser user, String queryKey) {
        Set ids = this.predictionModelRepository.findAllIdsByTenantIdAndTbKey(queryKey, user.getTenantId());
        if (ids.size() > 1) {
            throw new TrendzInternalException("Given telemetry key already exists: " + queryKey);
        }
        if (ids.isEmpty()) {
            return null;
        }
        return (UUID)ids.iterator().next();
    }

    public Map<UUID, UUID> findWiredPredictionAndHistoricalFields(JwtSecurityUser user, Set<UUID> predictionModelFieldSet) {
        if (predictionModelFieldSet.isEmpty()) {
            return Collections.emptyMap();
        }
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.predictionModelRepository.findWiredPredictionAndHistoricalFields(tenantId, customerId, predictionModelFieldSet).stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, UUID fieldId, Set<UUID> subCustomers) {
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        Set dependencyItemSet = this.predictionModelRepository.findDependedEntities(fieldId, tenantId, customerId, subCustomers, EntityId.NULL_UUID).stream().map(array -> new ChangeEntityValidationItem((String)array[0], (String)array[1])).collect(Collectors.toSet());
        return new ChangeEntityValidationInfo(dependencyItemSet);
    }
}

