/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.anomaly;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.UUID;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.trendz.dao.model.anomaly.MlPropertiesDto;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Entity
@Table(name="ml_properties")
public class MlPropertiesDto {
    @Id
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    @Column(name="id")
    private UUID id;
    @Column(name="json_value")
    private String jsonValue;

    public MlProperties toData() {
        MlProperties data = (MlProperties)JsonUtils.fromJson((String)this.jsonValue, MlProperties.class);
        data.setId(this.id);
        return data;
    }

    public static MlPropertiesDto from(MlProperties entity) {
        String jsonValue = JsonUtils.toJson((Object)entity);
        return new MlPropertiesDto(entity.getId(), jsonValue);
    }

    public static MlPropertiesDtoBuilder builder() {
        return new MlPropertiesDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public String getJsonValue() {
        return this.jsonValue;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setJsonValue(String jsonValue) {
        this.jsonValue = jsonValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MlPropertiesDto)) {
            return false;
        }
        MlPropertiesDto other = (MlPropertiesDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$jsonValue = this.getJsonValue();
        String other$jsonValue = other.getJsonValue();
        return !(this$jsonValue == null ? other$jsonValue != null : !this$jsonValue.equals(other$jsonValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MlPropertiesDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $jsonValue = this.getJsonValue();
        result = result * 59 + ($jsonValue == null ? 43 : $jsonValue.hashCode());
        return result;
    }

    public String toString() {
        return "MlPropertiesDto(id=" + String.valueOf(this.getId()) + ", jsonValue=" + this.getJsonValue() + ")";
    }

    public MlPropertiesDto() {
    }

    public MlPropertiesDto(UUID id, String jsonValue) {
        this.id = id;
        this.jsonValue = jsonValue;
    }
}

