/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.anomaly;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.UUID;
import org.thingsboard.trendz.dao.model.anomaly.LiteClusterModelDto;
import org.thingsboard.trendz.dao.model.anomaly.MlPropertiesDto;
import org.thingsboard.trendz.domain.anomaly.AnomalyAlarmConfig;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelStatus;
import org.thingsboard.trendz.domain.anomaly.MlProperties;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="cluster_model")
public class LiteClusterModelDto {
    @Id
    @Column(name="id")
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="customer_id")
    private UUID customerId;
    @Column(name="name")
    private String name;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private AnomalyModelStatus status;
    @Column(name="tb_telemetry_key")
    private String tbTelemetryKey;
    @Column(name="score_associated_field_id")
    private UUID anomalyScoreAssociatedFieldId;
    @Column(name="score_index_associated_field_id")
    private UUID anomalyScoreIndexAssociatedFieldId;
    @Column(name="telemetry_save_period_unit")
    private String telemetrySavePeriodUnit;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="properties_id", referencedColumnName="id")
    private MlPropertiesDto properties;
    @Column(name="alarm_type")
    private String alarmType;
    @Column(name="enabled_alarm_deletion")
    private boolean enabledAlarmDeletion;
    @Column(name="alarm_warning_threshold")
    private Integer alarmWarningThreshold;
    @Column(name="alarm_minor_threshold")
    private Integer alarmMinorThreshold;
    @Column(name="alarm_major_threshold")
    private Integer alarmMajorThreshold;
    @Column(name="alarm_critical_threshold")
    private Integer alarmCriticalThreshold;

    public static LiteClusterModelDto from(AnomalyModel entity) {
        AnomalyAlarmConfig anomalyAlarmConfig = entity.getAnomalyAlarmConfig();
        return LiteClusterModelDto.builder().id(entity.getId()).tenantId(entity.getUser().getTenantId()).customerId(entity.getUser().getCustomerId()).status(entity.getStatus()).name(entity.getName()).tbTelemetryKey(entity.getTbTelemetryKey()).anomalyScoreAssociatedFieldId(entity.getAnomalyScoreAssociatedFieldId()).anomalyScoreIndexAssociatedFieldId(entity.getAnomalyScoreIndexAssociatedFieldId()).telemetrySavePeriodUnit(entity.getTelemetrySavePeriodUnit()).properties(MlPropertiesDto.from((MlProperties)entity.getProperties())).alarmType(entity.getAlarmType()).enabledAlarmDeletion(entity.isEnabledAlarmDeletion()).alarmWarningThreshold(anomalyAlarmConfig == null ? null : Integer.valueOf(anomalyAlarmConfig.getWarningScoreThreshold())).alarmMinorThreshold(anomalyAlarmConfig == null ? null : Integer.valueOf(anomalyAlarmConfig.getMinorScoreThreshold())).alarmMajorThreshold(anomalyAlarmConfig == null ? null : Integer.valueOf(anomalyAlarmConfig.getMajorScoreThreshold())).alarmCriticalThreshold(anomalyAlarmConfig == null ? null : Integer.valueOf(anomalyAlarmConfig.getCriticalScoreThreshold())).build();
    }

    public static LiteClusterModelDtoBuilder builder() {
        return new LiteClusterModelDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public UUID getCustomerId() {
        return this.customerId;
    }

    public String getName() {
        return this.name;
    }

    public AnomalyModelStatus getStatus() {
        return this.status;
    }

    public String getTbTelemetryKey() {
        return this.tbTelemetryKey;
    }

    public UUID getAnomalyScoreAssociatedFieldId() {
        return this.anomalyScoreAssociatedFieldId;
    }

    public UUID getAnomalyScoreIndexAssociatedFieldId() {
        return this.anomalyScoreIndexAssociatedFieldId;
    }

    public String getTelemetrySavePeriodUnit() {
        return this.telemetrySavePeriodUnit;
    }

    public MlPropertiesDto getProperties() {
        return this.properties;
    }

    public String getAlarmType() {
        return this.alarmType;
    }

    public boolean isEnabledAlarmDeletion() {
        return this.enabledAlarmDeletion;
    }

    public Integer getAlarmWarningThreshold() {
        return this.alarmWarningThreshold;
    }

    public Integer getAlarmMinorThreshold() {
        return this.alarmMinorThreshold;
    }

    public Integer getAlarmMajorThreshold() {
        return this.alarmMajorThreshold;
    }

    public Integer getAlarmCriticalThreshold() {
        return this.alarmCriticalThreshold;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(AnomalyModelStatus status) {
        this.status = status;
    }

    public void setTbTelemetryKey(String tbTelemetryKey) {
        this.tbTelemetryKey = tbTelemetryKey;
    }

    public void setAnomalyScoreAssociatedFieldId(UUID anomalyScoreAssociatedFieldId) {
        this.anomalyScoreAssociatedFieldId = anomalyScoreAssociatedFieldId;
    }

    public void setAnomalyScoreIndexAssociatedFieldId(UUID anomalyScoreIndexAssociatedFieldId) {
        this.anomalyScoreIndexAssociatedFieldId = anomalyScoreIndexAssociatedFieldId;
    }

    public void setTelemetrySavePeriodUnit(String telemetrySavePeriodUnit) {
        this.telemetrySavePeriodUnit = telemetrySavePeriodUnit;
    }

    public void setProperties(MlPropertiesDto properties) {
        this.properties = properties;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    public void setEnabledAlarmDeletion(boolean enabledAlarmDeletion) {
        this.enabledAlarmDeletion = enabledAlarmDeletion;
    }

    public void setAlarmWarningThreshold(Integer alarmWarningThreshold) {
        this.alarmWarningThreshold = alarmWarningThreshold;
    }

    public void setAlarmMinorThreshold(Integer alarmMinorThreshold) {
        this.alarmMinorThreshold = alarmMinorThreshold;
    }

    public void setAlarmMajorThreshold(Integer alarmMajorThreshold) {
        this.alarmMajorThreshold = alarmMajorThreshold;
    }

    public void setAlarmCriticalThreshold(Integer alarmCriticalThreshold) {
        this.alarmCriticalThreshold = alarmCriticalThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiteClusterModelDto)) {
            return false;
        }
        LiteClusterModelDto other = (LiteClusterModelDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabledAlarmDeletion() != other.isEnabledAlarmDeletion()) {
            return false;
        }
        Integer this$alarmWarningThreshold = this.getAlarmWarningThreshold();
        Integer other$alarmWarningThreshold = other.getAlarmWarningThreshold();
        if (this$alarmWarningThreshold == null ? other$alarmWarningThreshold != null : !((Object)this$alarmWarningThreshold).equals(other$alarmWarningThreshold)) {
            return false;
        }
        Integer this$alarmMinorThreshold = this.getAlarmMinorThreshold();
        Integer other$alarmMinorThreshold = other.getAlarmMinorThreshold();
        if (this$alarmMinorThreshold == null ? other$alarmMinorThreshold != null : !((Object)this$alarmMinorThreshold).equals(other$alarmMinorThreshold)) {
            return false;
        }
        Integer this$alarmMajorThreshold = this.getAlarmMajorThreshold();
        Integer other$alarmMajorThreshold = other.getAlarmMajorThreshold();
        if (this$alarmMajorThreshold == null ? other$alarmMajorThreshold != null : !((Object)this$alarmMajorThreshold).equals(other$alarmMajorThreshold)) {
            return false;
        }
        Integer this$alarmCriticalThreshold = this.getAlarmCriticalThreshold();
        Integer other$alarmCriticalThreshold = other.getAlarmCriticalThreshold();
        if (this$alarmCriticalThreshold == null ? other$alarmCriticalThreshold != null : !((Object)this$alarmCriticalThreshold).equals(other$alarmCriticalThreshold)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        AnomalyModelStatus this$status = this.getStatus();
        AnomalyModelStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$tbTelemetryKey = this.getTbTelemetryKey();
        String other$tbTelemetryKey = other.getTbTelemetryKey();
        if (this$tbTelemetryKey == null ? other$tbTelemetryKey != null : !this$tbTelemetryKey.equals(other$tbTelemetryKey)) {
            return false;
        }
        UUID this$anomalyScoreAssociatedFieldId = this.getAnomalyScoreAssociatedFieldId();
        UUID other$anomalyScoreAssociatedFieldId = other.getAnomalyScoreAssociatedFieldId();
        if (this$anomalyScoreAssociatedFieldId == null ? other$anomalyScoreAssociatedFieldId != null : !((Object)this$anomalyScoreAssociatedFieldId).equals(other$anomalyScoreAssociatedFieldId)) {
            return false;
        }
        UUID this$anomalyScoreIndexAssociatedFieldId = this.getAnomalyScoreIndexAssociatedFieldId();
        UUID other$anomalyScoreIndexAssociatedFieldId = other.getAnomalyScoreIndexAssociatedFieldId();
        if (this$anomalyScoreIndexAssociatedFieldId == null ? other$anomalyScoreIndexAssociatedFieldId != null : !((Object)this$anomalyScoreIndexAssociatedFieldId).equals(other$anomalyScoreIndexAssociatedFieldId)) {
            return false;
        }
        String this$telemetrySavePeriodUnit = this.getTelemetrySavePeriodUnit();
        String other$telemetrySavePeriodUnit = other.getTelemetrySavePeriodUnit();
        if (this$telemetrySavePeriodUnit == null ? other$telemetrySavePeriodUnit != null : !this$telemetrySavePeriodUnit.equals(other$telemetrySavePeriodUnit)) {
            return false;
        }
        MlPropertiesDto this$properties = this.getProperties();
        MlPropertiesDto other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        String this$alarmType = this.getAlarmType();
        String other$alarmType = other.getAlarmType();
        return !(this$alarmType == null ? other$alarmType != null : !this$alarmType.equals(other$alarmType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LiteClusterModelDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabledAlarmDeletion() ? 79 : 97);
        Integer $alarmWarningThreshold = this.getAlarmWarningThreshold();
        result = result * 59 + ($alarmWarningThreshold == null ? 43 : ((Object)$alarmWarningThreshold).hashCode());
        Integer $alarmMinorThreshold = this.getAlarmMinorThreshold();
        result = result * 59 + ($alarmMinorThreshold == null ? 43 : ((Object)$alarmMinorThreshold).hashCode());
        Integer $alarmMajorThreshold = this.getAlarmMajorThreshold();
        result = result * 59 + ($alarmMajorThreshold == null ? 43 : ((Object)$alarmMajorThreshold).hashCode());
        Integer $alarmCriticalThreshold = this.getAlarmCriticalThreshold();
        result = result * 59 + ($alarmCriticalThreshold == null ? 43 : ((Object)$alarmCriticalThreshold).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        AnomalyModelStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $tbTelemetryKey = this.getTbTelemetryKey();
        result = result * 59 + ($tbTelemetryKey == null ? 43 : $tbTelemetryKey.hashCode());
        UUID $anomalyScoreAssociatedFieldId = this.getAnomalyScoreAssociatedFieldId();
        result = result * 59 + ($anomalyScoreAssociatedFieldId == null ? 43 : ((Object)$anomalyScoreAssociatedFieldId).hashCode());
        UUID $anomalyScoreIndexAssociatedFieldId = this.getAnomalyScoreIndexAssociatedFieldId();
        result = result * 59 + ($anomalyScoreIndexAssociatedFieldId == null ? 43 : ((Object)$anomalyScoreIndexAssociatedFieldId).hashCode());
        String $telemetrySavePeriodUnit = this.getTelemetrySavePeriodUnit();
        result = result * 59 + ($telemetrySavePeriodUnit == null ? 43 : $telemetrySavePeriodUnit.hashCode());
        MlPropertiesDto $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        String $alarmType = this.getAlarmType();
        result = result * 59 + ($alarmType == null ? 43 : $alarmType.hashCode());
        return result;
    }

    public String toString() {
        return "LiteClusterModelDto(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", name=" + this.getName() + ", status=" + String.valueOf(this.getStatus()) + ", tbTelemetryKey=" + this.getTbTelemetryKey() + ", anomalyScoreAssociatedFieldId=" + String.valueOf(this.getAnomalyScoreAssociatedFieldId()) + ", anomalyScoreIndexAssociatedFieldId=" + String.valueOf(this.getAnomalyScoreIndexAssociatedFieldId()) + ", telemetrySavePeriodUnit=" + this.getTelemetrySavePeriodUnit() + ", properties=" + String.valueOf(this.getProperties()) + ", alarmType=" + this.getAlarmType() + ", enabledAlarmDeletion=" + this.isEnabledAlarmDeletion() + ", alarmWarningThreshold=" + this.getAlarmWarningThreshold() + ", alarmMinorThreshold=" + this.getAlarmMinorThreshold() + ", alarmMajorThreshold=" + this.getAlarmMajorThreshold() + ", alarmCriticalThreshold=" + this.getAlarmCriticalThreshold() + ")";
    }

    public LiteClusterModelDto() {
    }

    public LiteClusterModelDto(UUID id, UUID tenantId, UUID customerId, String name, AnomalyModelStatus status, String tbTelemetryKey, UUID anomalyScoreAssociatedFieldId, UUID anomalyScoreIndexAssociatedFieldId, String telemetrySavePeriodUnit, MlPropertiesDto properties, String alarmType, boolean enabledAlarmDeletion, Integer alarmWarningThreshold, Integer alarmMinorThreshold, Integer alarmMajorThreshold, Integer alarmCriticalThreshold) {
        this.id = id;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.name = name;
        this.status = status;
        this.tbTelemetryKey = tbTelemetryKey;
        this.anomalyScoreAssociatedFieldId = anomalyScoreAssociatedFieldId;
        this.anomalyScoreIndexAssociatedFieldId = anomalyScoreIndexAssociatedFieldId;
        this.telemetrySavePeriodUnit = telemetrySavePeriodUnit;
        this.properties = properties;
        this.alarmType = alarmType;
        this.enabledAlarmDeletion = enabledAlarmDeletion;
        this.alarmWarningThreshold = alarmWarningThreshold;
        this.alarmMinorThreshold = alarmMinorThreshold;
        this.alarmMajorThreshold = alarmMajorThreshold;
        this.alarmCriticalThreshold = alarmCriticalThreshold;
    }
}

