/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.anomaly;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.dao.model.anomaly.AnomalyModelTaskDataDto;
import org.thingsboard.trendz.dao.model.anomaly.ClusterInfoDto;
import org.thingsboard.trendz.dao.model.anomaly.ClusterModelDto;
import org.thingsboard.trendz.dao.model.anomaly.DatasetConfigDto;
import org.thingsboard.trendz.dao.model.anomaly.MlPropertiesDto;
import org.thingsboard.trendz.domain.anomaly.AnomalyAlarmConfig;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelStatus;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelTaskData;
import org.thingsboard.trendz.domain.anomaly.ClusterInfo;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.ModelType;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="cluster_model")
public class ClusterModelDto {
    @Id
    @Column(name="id")
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="customer_id")
    private UUID customerId;
    @Column(name="create_ts")
    private long createTs;
    @Column(name="name")
    private String name;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private AnomalyModelStatus status;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type")
    private ModelType type;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="properties_id", referencedColumnName="id")
    private MlPropertiesDto properties;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="dataset_config_id", referencedColumnName="id")
    private DatasetConfigDto datasetConfig;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="cluster_model_id", referencedColumnName="id")
    private List<ClusterInfoDto> clusters;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @PrimaryKeyJoinColumn
    private AnomalyModelTaskDataDto taskData;
    @Column(name="tb_telemetry_key")
    private String tbTelemetryKey;
    @Column(name="score_associated_field_id")
    private UUID anomalyScoreAssociatedFieldId;
    @Column(name="score_index_associated_field_id")
    private UUID anomalyScoreIndexAssociatedFieldId;
    @Column(name="telemetry_save_period_unit")
    private String telemetrySavePeriodUnit;
    @Column(name="alarm_type")
    private String alarmType;
    @Column(name="enabled_alarm_deletion")
    private boolean enabledAlarmDeletion;
    @Column(name="alarm_warning_threshold")
    private Integer alarmWarningThreshold;
    @Column(name="alarm_minor_threshold")
    private Integer alarmMinorThreshold;
    @Column(name="alarm_major_threshold")
    private Integer alarmMajorThreshold;
    @Column(name="alarm_critical_threshold")
    private Integer alarmCriticalThreshold;

    public AnomalyModel toData() {
        List clusters;
        List list = clusters = this.clusters == null ? Collections.emptyList() : this.clusters.stream().map(ClusterInfoDto::toData).collect(Collectors.toList());
        AnomalyAlarmConfig anomalyAlarmConfig = this.alarmWarningThreshold == null && this.alarmMinorThreshold == null && this.alarmMajorThreshold == null && this.alarmCriticalThreshold == null ? null : AnomalyAlarmConfig.builder().warningScoreThreshold(this.alarmWarningThreshold == null ? -1 : this.alarmWarningThreshold).minorScoreThreshold(this.alarmMinorThreshold == null ? -1 : this.alarmMinorThreshold).majorScoreThreshold(this.alarmMajorThreshold == null ? -1 : this.alarmMajorThreshold).criticalScoreThreshold(this.alarmCriticalThreshold == null ? -1 : this.alarmCriticalThreshold).build();
        return AnomalyModel.builder().id(this.id).createTs(this.createTs).name(this.name).status(this.status).type(this.type).properties(this.properties.toData()).datasetConfig(this.datasetConfig.toData()).clusters(clusters).taskData(this.taskData == null ? null : this.taskData.toData()).anomalyAlarmConfig(anomalyAlarmConfig).anomalyScoreAssociatedFieldId(this.anomalyScoreAssociatedFieldId).tbTelemetryKey(this.tbTelemetryKey).anomalyScoreIndexAssociatedFieldId(this.anomalyScoreIndexAssociatedFieldId).telemetrySavePeriodUnit(this.telemetrySavePeriodUnit).alarmType(this.alarmType).enabledAlarmDeletion(this.enabledAlarmDeletion).build();
    }

    public static ClusterModelDto from(AnomalyModel entity) {
        AnomalyAlarmConfig anomalyAlarmConfig = entity.getAnomalyAlarmConfig();
        return ClusterModelDto.builder().id(entity.getId()).tenantId(entity.getUser().getTenantId()).customerId(entity.getUser().getCustomerId()).createTs(entity.getCreateTs()).name(entity.getName()).status(entity.getStatus()).type(entity.getType()).properties(MlPropertiesDto.from((MlProperties)entity.getProperties())).datasetConfig(DatasetConfigDto.from((DatasetConfig)entity.getDatasetConfig())).clusters(entity.getClusters().stream().map(cluster -> ClusterInfoDto.from((ClusterInfo)cluster, (UUID)entity.getId())).collect(Collectors.toList())).taskData(AnomalyModelTaskDataDto.from((AnomalyModelTaskData)entity.getTaskData())).tbTelemetryKey(entity.getTbTelemetryKey()).anomalyScoreAssociatedFieldId(entity.getAnomalyScoreAssociatedFieldId()).anomalyScoreIndexAssociatedFieldId(entity.getAnomalyScoreIndexAssociatedFieldId()).telemetrySavePeriodUnit(entity.getTelemetrySavePeriodUnit()).alarmType(entity.getAlarmType()).enabledAlarmDeletion(entity.isEnabledAlarmDeletion()).alarmWarningThreshold(anomalyAlarmConfig == null ? null : Integer.valueOf(anomalyAlarmConfig.getWarningScoreThreshold())).alarmMinorThreshold(anomalyAlarmConfig == null ? null : Integer.valueOf(anomalyAlarmConfig.getMinorScoreThreshold())).alarmMajorThreshold(anomalyAlarmConfig == null ? null : Integer.valueOf(anomalyAlarmConfig.getMajorScoreThreshold())).alarmCriticalThreshold(anomalyAlarmConfig == null ? null : Integer.valueOf(anomalyAlarmConfig.getCriticalScoreThreshold())).build();
    }

    public static ClusterModelDtoBuilder builder() {
        return new ClusterModelDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public UUID getCustomerId() {
        return this.customerId;
    }

    public long getCreateTs() {
        return this.createTs;
    }

    public String getName() {
        return this.name;
    }

    public AnomalyModelStatus getStatus() {
        return this.status;
    }

    public ModelType getType() {
        return this.type;
    }

    public MlPropertiesDto getProperties() {
        return this.properties;
    }

    public DatasetConfigDto getDatasetConfig() {
        return this.datasetConfig;
    }

    public List<ClusterInfoDto> getClusters() {
        return this.clusters;
    }

    public AnomalyModelTaskDataDto getTaskData() {
        return this.taskData;
    }

    public String getTbTelemetryKey() {
        return this.tbTelemetryKey;
    }

    public UUID getAnomalyScoreAssociatedFieldId() {
        return this.anomalyScoreAssociatedFieldId;
    }

    public UUID getAnomalyScoreIndexAssociatedFieldId() {
        return this.anomalyScoreIndexAssociatedFieldId;
    }

    public String getTelemetrySavePeriodUnit() {
        return this.telemetrySavePeriodUnit;
    }

    public String getAlarmType() {
        return this.alarmType;
    }

    public boolean isEnabledAlarmDeletion() {
        return this.enabledAlarmDeletion;
    }

    public Integer getAlarmWarningThreshold() {
        return this.alarmWarningThreshold;
    }

    public Integer getAlarmMinorThreshold() {
        return this.alarmMinorThreshold;
    }

    public Integer getAlarmMajorThreshold() {
        return this.alarmMajorThreshold;
    }

    public Integer getAlarmCriticalThreshold() {
        return this.alarmCriticalThreshold;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    public void setCreateTs(long createTs) {
        this.createTs = createTs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(AnomalyModelStatus status) {
        this.status = status;
    }

    public void setType(ModelType type) {
        this.type = type;
    }

    public void setProperties(MlPropertiesDto properties) {
        this.properties = properties;
    }

    public void setDatasetConfig(DatasetConfigDto datasetConfig) {
        this.datasetConfig = datasetConfig;
    }

    public void setClusters(List<ClusterInfoDto> clusters) {
        this.clusters = clusters;
    }

    public void setTaskData(AnomalyModelTaskDataDto taskData) {
        this.taskData = taskData;
    }

    public void setTbTelemetryKey(String tbTelemetryKey) {
        this.tbTelemetryKey = tbTelemetryKey;
    }

    public void setAnomalyScoreAssociatedFieldId(UUID anomalyScoreAssociatedFieldId) {
        this.anomalyScoreAssociatedFieldId = anomalyScoreAssociatedFieldId;
    }

    public void setAnomalyScoreIndexAssociatedFieldId(UUID anomalyScoreIndexAssociatedFieldId) {
        this.anomalyScoreIndexAssociatedFieldId = anomalyScoreIndexAssociatedFieldId;
    }

    public void setTelemetrySavePeriodUnit(String telemetrySavePeriodUnit) {
        this.telemetrySavePeriodUnit = telemetrySavePeriodUnit;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    public void setEnabledAlarmDeletion(boolean enabledAlarmDeletion) {
        this.enabledAlarmDeletion = enabledAlarmDeletion;
    }

    public void setAlarmWarningThreshold(Integer alarmWarningThreshold) {
        this.alarmWarningThreshold = alarmWarningThreshold;
    }

    public void setAlarmMinorThreshold(Integer alarmMinorThreshold) {
        this.alarmMinorThreshold = alarmMinorThreshold;
    }

    public void setAlarmMajorThreshold(Integer alarmMajorThreshold) {
        this.alarmMajorThreshold = alarmMajorThreshold;
    }

    public void setAlarmCriticalThreshold(Integer alarmCriticalThreshold) {
        this.alarmCriticalThreshold = alarmCriticalThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterModelDto)) {
            return false;
        }
        ClusterModelDto other = (ClusterModelDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreateTs() != other.getCreateTs()) {
            return false;
        }
        if (this.isEnabledAlarmDeletion() != other.isEnabledAlarmDeletion()) {
            return false;
        }
        Integer this$alarmWarningThreshold = this.getAlarmWarningThreshold();
        Integer other$alarmWarningThreshold = other.getAlarmWarningThreshold();
        if (this$alarmWarningThreshold == null ? other$alarmWarningThreshold != null : !((Object)this$alarmWarningThreshold).equals(other$alarmWarningThreshold)) {
            return false;
        }
        Integer this$alarmMinorThreshold = this.getAlarmMinorThreshold();
        Integer other$alarmMinorThreshold = other.getAlarmMinorThreshold();
        if (this$alarmMinorThreshold == null ? other$alarmMinorThreshold != null : !((Object)this$alarmMinorThreshold).equals(other$alarmMinorThreshold)) {
            return false;
        }
        Integer this$alarmMajorThreshold = this.getAlarmMajorThreshold();
        Integer other$alarmMajorThreshold = other.getAlarmMajorThreshold();
        if (this$alarmMajorThreshold == null ? other$alarmMajorThreshold != null : !((Object)this$alarmMajorThreshold).equals(other$alarmMajorThreshold)) {
            return false;
        }
        Integer this$alarmCriticalThreshold = this.getAlarmCriticalThreshold();
        Integer other$alarmCriticalThreshold = other.getAlarmCriticalThreshold();
        if (this$alarmCriticalThreshold == null ? other$alarmCriticalThreshold != null : !((Object)this$alarmCriticalThreshold).equals(other$alarmCriticalThreshold)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        AnomalyModelStatus this$status = this.getStatus();
        AnomalyModelStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ModelType this$type = this.getType();
        ModelType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        MlPropertiesDto this$properties = this.getProperties();
        MlPropertiesDto other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        DatasetConfigDto this$datasetConfig = this.getDatasetConfig();
        DatasetConfigDto other$datasetConfig = other.getDatasetConfig();
        if (this$datasetConfig == null ? other$datasetConfig != null : !this$datasetConfig.equals(other$datasetConfig)) {
            return false;
        }
        List this$clusters = this.getClusters();
        List other$clusters = other.getClusters();
        if (this$clusters == null ? other$clusters != null : !((Object)this$clusters).equals(other$clusters)) {
            return false;
        }
        AnomalyModelTaskDataDto this$taskData = this.getTaskData();
        AnomalyModelTaskDataDto other$taskData = other.getTaskData();
        if (this$taskData == null ? other$taskData != null : !this$taskData.equals(other$taskData)) {
            return false;
        }
        String this$tbTelemetryKey = this.getTbTelemetryKey();
        String other$tbTelemetryKey = other.getTbTelemetryKey();
        if (this$tbTelemetryKey == null ? other$tbTelemetryKey != null : !this$tbTelemetryKey.equals(other$tbTelemetryKey)) {
            return false;
        }
        UUID this$anomalyScoreAssociatedFieldId = this.getAnomalyScoreAssociatedFieldId();
        UUID other$anomalyScoreAssociatedFieldId = other.getAnomalyScoreAssociatedFieldId();
        if (this$anomalyScoreAssociatedFieldId == null ? other$anomalyScoreAssociatedFieldId != null : !((Object)this$anomalyScoreAssociatedFieldId).equals(other$anomalyScoreAssociatedFieldId)) {
            return false;
        }
        UUID this$anomalyScoreIndexAssociatedFieldId = this.getAnomalyScoreIndexAssociatedFieldId();
        UUID other$anomalyScoreIndexAssociatedFieldId = other.getAnomalyScoreIndexAssociatedFieldId();
        if (this$anomalyScoreIndexAssociatedFieldId == null ? other$anomalyScoreIndexAssociatedFieldId != null : !((Object)this$anomalyScoreIndexAssociatedFieldId).equals(other$anomalyScoreIndexAssociatedFieldId)) {
            return false;
        }
        String this$telemetrySavePeriodUnit = this.getTelemetrySavePeriodUnit();
        String other$telemetrySavePeriodUnit = other.getTelemetrySavePeriodUnit();
        if (this$telemetrySavePeriodUnit == null ? other$telemetrySavePeriodUnit != null : !this$telemetrySavePeriodUnit.equals(other$telemetrySavePeriodUnit)) {
            return false;
        }
        String this$alarmType = this.getAlarmType();
        String other$alarmType = other.getAlarmType();
        return !(this$alarmType == null ? other$alarmType != null : !this$alarmType.equals(other$alarmType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterModelDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createTs = this.getCreateTs();
        result = result * 59 + (int)($createTs >>> 32 ^ $createTs);
        result = result * 59 + (this.isEnabledAlarmDeletion() ? 79 : 97);
        Integer $alarmWarningThreshold = this.getAlarmWarningThreshold();
        result = result * 59 + ($alarmWarningThreshold == null ? 43 : ((Object)$alarmWarningThreshold).hashCode());
        Integer $alarmMinorThreshold = this.getAlarmMinorThreshold();
        result = result * 59 + ($alarmMinorThreshold == null ? 43 : ((Object)$alarmMinorThreshold).hashCode());
        Integer $alarmMajorThreshold = this.getAlarmMajorThreshold();
        result = result * 59 + ($alarmMajorThreshold == null ? 43 : ((Object)$alarmMajorThreshold).hashCode());
        Integer $alarmCriticalThreshold = this.getAlarmCriticalThreshold();
        result = result * 59 + ($alarmCriticalThreshold == null ? 43 : ((Object)$alarmCriticalThreshold).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        AnomalyModelStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ModelType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        MlPropertiesDto $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        DatasetConfigDto $datasetConfig = this.getDatasetConfig();
        result = result * 59 + ($datasetConfig == null ? 43 : $datasetConfig.hashCode());
        List $clusters = this.getClusters();
        result = result * 59 + ($clusters == null ? 43 : ((Object)$clusters).hashCode());
        AnomalyModelTaskDataDto $taskData = this.getTaskData();
        result = result * 59 + ($taskData == null ? 43 : $taskData.hashCode());
        String $tbTelemetryKey = this.getTbTelemetryKey();
        result = result * 59 + ($tbTelemetryKey == null ? 43 : $tbTelemetryKey.hashCode());
        UUID $anomalyScoreAssociatedFieldId = this.getAnomalyScoreAssociatedFieldId();
        result = result * 59 + ($anomalyScoreAssociatedFieldId == null ? 43 : ((Object)$anomalyScoreAssociatedFieldId).hashCode());
        UUID $anomalyScoreIndexAssociatedFieldId = this.getAnomalyScoreIndexAssociatedFieldId();
        result = result * 59 + ($anomalyScoreIndexAssociatedFieldId == null ? 43 : ((Object)$anomalyScoreIndexAssociatedFieldId).hashCode());
        String $telemetrySavePeriodUnit = this.getTelemetrySavePeriodUnit();
        result = result * 59 + ($telemetrySavePeriodUnit == null ? 43 : $telemetrySavePeriodUnit.hashCode());
        String $alarmType = this.getAlarmType();
        result = result * 59 + ($alarmType == null ? 43 : $alarmType.hashCode());
        return result;
    }

    public String toString() {
        return "ClusterModelDto(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", createTs=" + this.getCreateTs() + ", name=" + this.getName() + ", status=" + String.valueOf(this.getStatus()) + ", type=" + String.valueOf(this.getType()) + ", properties=" + String.valueOf(this.getProperties()) + ", datasetConfig=" + String.valueOf(this.getDatasetConfig()) + ", clusters=" + String.valueOf(this.getClusters()) + ", taskData=" + String.valueOf(this.getTaskData()) + ", tbTelemetryKey=" + this.getTbTelemetryKey() + ", anomalyScoreAssociatedFieldId=" + String.valueOf(this.getAnomalyScoreAssociatedFieldId()) + ", anomalyScoreIndexAssociatedFieldId=" + String.valueOf(this.getAnomalyScoreIndexAssociatedFieldId()) + ", telemetrySavePeriodUnit=" + this.getTelemetrySavePeriodUnit() + ", alarmType=" + this.getAlarmType() + ", enabledAlarmDeletion=" + this.isEnabledAlarmDeletion() + ", alarmWarningThreshold=" + this.getAlarmWarningThreshold() + ", alarmMinorThreshold=" + this.getAlarmMinorThreshold() + ", alarmMajorThreshold=" + this.getAlarmMajorThreshold() + ", alarmCriticalThreshold=" + this.getAlarmCriticalThreshold() + ")";
    }

    public ClusterModelDto() {
    }

    public ClusterModelDto(UUID id, UUID tenantId, UUID customerId, long createTs, String name, AnomalyModelStatus status, ModelType type, MlPropertiesDto properties, DatasetConfigDto datasetConfig, List<ClusterInfoDto> clusters, AnomalyModelTaskDataDto taskData, String tbTelemetryKey, UUID anomalyScoreAssociatedFieldId, UUID anomalyScoreIndexAssociatedFieldId, String telemetrySavePeriodUnit, String alarmType, boolean enabledAlarmDeletion, Integer alarmWarningThreshold, Integer alarmMinorThreshold, Integer alarmMajorThreshold, Integer alarmCriticalThreshold) {
        this.id = id;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.createTs = createTs;
        this.name = name;
        this.status = status;
        this.type = type;
        this.properties = properties;
        this.datasetConfig = datasetConfig;
        this.clusters = clusters;
        this.taskData = taskData;
        this.tbTelemetryKey = tbTelemetryKey;
        this.anomalyScoreAssociatedFieldId = anomalyScoreAssociatedFieldId;
        this.anomalyScoreIndexAssociatedFieldId = anomalyScoreIndexAssociatedFieldId;
        this.telemetrySavePeriodUnit = telemetrySavePeriodUnit;
        this.alarmType = alarmType;
        this.enabledAlarmDeletion = enabledAlarmDeletion;
        this.alarmWarningThreshold = alarmWarningThreshold;
        this.alarmMinorThreshold = alarmMinorThreshold;
        this.alarmMajorThreshold = alarmMajorThreshold;
        this.alarmCriticalThreshold = alarmCriticalThreshold;
    }
}

