/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.anomaly;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.thingsboard.trendz.dao.model.anomaly.ClusterExampleDto;
import org.thingsboard.trendz.dao.model.anomaly.ClusterInfoDto;
import org.thingsboard.trendz.domain.anomaly.ClusterInfo;

@Entity
@Table(name="cluster_info")
public class ClusterInfoDto {
    @Id
    @Column(name="id")
    private UUID id;
    @Column(name="cluster_id")
    private long clusterId;
    @Column(name="segments_count")
    private int segmentsCount;
    @Column(name="segments_percent")
    private int segmentsPercent;
    @Column(name="duration_ms")
    private long durationMs;
    @Column(name="min_score")
    private double minScore;
    @Column(name="max_score")
    private double maxScore;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="cluster_info_id", referencedColumnName="id")
    @Fetch(value=FetchMode.SUBSELECT)
    private List<ClusterExampleDto> clusterExamples;
    @Column(name="cluster_model_id")
    private UUID clusterModelId;

    public ClusterInfo toData() {
        HashMap mappedClusterExamples = new HashMap();
        if (this.clusterExamples != null) {
            this.clusterExamples.forEach(clusterExampleDto -> mappedClusterExamples.put(clusterExampleDto.getId(), Collections.emptyList()));
        }
        return ClusterInfo.builder().id(this.id).clusterId(this.clusterId).segmentsCount(this.segmentsCount).segmentsPercent(this.segmentsPercent).durationMs(this.durationMs).minScore(this.minScore).maxScore(this.maxScore).clusterExamples(mappedClusterExamples).build();
    }

    public static ClusterInfoDto from(ClusterInfo entity, UUID clusterModelId) {
        ClusterInfoDto dto = new ClusterInfoDto();
        dto.setId(entity.getId());
        dto.setClusterId(entity.getClusterId());
        dto.setSegmentsCount(entity.getSegmentsCount());
        dto.setSegmentsPercent(entity.getSegmentsPercent());
        dto.setDurationMs(entity.getDurationMs());
        dto.setMinScore(entity.getMinScore());
        dto.setMaxScore(entity.getMaxScore());
        dto.setClusterExamples(entity.getClusterExamples().keySet().stream().map(exampleId -> ClusterExampleDto.from((UUID)exampleId, (UUID)dto.getId())).collect(Collectors.toList()));
        dto.setClusterModelId(clusterModelId);
        return dto;
    }

    public static ClusterInfoDtoBuilder builder() {
        return new ClusterInfoDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public int getSegmentsCount() {
        return this.segmentsCount;
    }

    public int getSegmentsPercent() {
        return this.segmentsPercent;
    }

    public long getDurationMs() {
        return this.durationMs;
    }

    public double getMinScore() {
        return this.minScore;
    }

    public double getMaxScore() {
        return this.maxScore;
    }

    public List<ClusterExampleDto> getClusterExamples() {
        return this.clusterExamples;
    }

    public UUID getClusterModelId() {
        return this.clusterModelId;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setClusterId(long clusterId) {
        this.clusterId = clusterId;
    }

    public void setSegmentsCount(int segmentsCount) {
        this.segmentsCount = segmentsCount;
    }

    public void setSegmentsPercent(int segmentsPercent) {
        this.segmentsPercent = segmentsPercent;
    }

    public void setDurationMs(long durationMs) {
        this.durationMs = durationMs;
    }

    public void setMinScore(double minScore) {
        this.minScore = minScore;
    }

    public void setMaxScore(double maxScore) {
        this.maxScore = maxScore;
    }

    public void setClusterExamples(List<ClusterExampleDto> clusterExamples) {
        this.clusterExamples = clusterExamples;
    }

    public void setClusterModelId(UUID clusterModelId) {
        this.clusterModelId = clusterModelId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterInfoDto)) {
            return false;
        }
        ClusterInfoDto other = (ClusterInfoDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getClusterId() != other.getClusterId()) {
            return false;
        }
        if (this.getSegmentsCount() != other.getSegmentsCount()) {
            return false;
        }
        if (this.getSegmentsPercent() != other.getSegmentsPercent()) {
            return false;
        }
        if (this.getDurationMs() != other.getDurationMs()) {
            return false;
        }
        if (Double.compare(this.getMinScore(), other.getMinScore()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxScore(), other.getMaxScore()) != 0) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List this$clusterExamples = this.getClusterExamples();
        List other$clusterExamples = other.getClusterExamples();
        if (this$clusterExamples == null ? other$clusterExamples != null : !((Object)this$clusterExamples).equals(other$clusterExamples)) {
            return false;
        }
        UUID this$clusterModelId = this.getClusterModelId();
        UUID other$clusterModelId = other.getClusterModelId();
        return !(this$clusterModelId == null ? other$clusterModelId != null : !((Object)this$clusterModelId).equals(other$clusterModelId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterInfoDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $clusterId = this.getClusterId();
        result = result * 59 + (int)($clusterId >>> 32 ^ $clusterId);
        result = result * 59 + this.getSegmentsCount();
        result = result * 59 + this.getSegmentsPercent();
        long $durationMs = this.getDurationMs();
        result = result * 59 + (int)($durationMs >>> 32 ^ $durationMs);
        long $minScore = Double.doubleToLongBits(this.getMinScore());
        result = result * 59 + (int)($minScore >>> 32 ^ $minScore);
        long $maxScore = Double.doubleToLongBits(this.getMaxScore());
        result = result * 59 + (int)($maxScore >>> 32 ^ $maxScore);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List $clusterExamples = this.getClusterExamples();
        result = result * 59 + ($clusterExamples == null ? 43 : ((Object)$clusterExamples).hashCode());
        UUID $clusterModelId = this.getClusterModelId();
        result = result * 59 + ($clusterModelId == null ? 43 : ((Object)$clusterModelId).hashCode());
        return result;
    }

    public String toString() {
        return "ClusterInfoDto(id=" + String.valueOf(this.getId()) + ", clusterId=" + this.getClusterId() + ", segmentsCount=" + this.getSegmentsCount() + ", segmentsPercent=" + this.getSegmentsPercent() + ", durationMs=" + this.getDurationMs() + ", minScore=" + this.getMinScore() + ", maxScore=" + this.getMaxScore() + ", clusterExamples=" + String.valueOf(this.getClusterExamples()) + ", clusterModelId=" + String.valueOf(this.getClusterModelId()) + ")";
    }

    public ClusterInfoDto() {
    }

    public ClusterInfoDto(UUID id, long clusterId, int segmentsCount, int segmentsPercent, long durationMs, double minScore, double maxScore, List<ClusterExampleDto> clusterExamples, UUID clusterModelId) {
        this.id = id;
        this.clusterId = clusterId;
        this.segmentsCount = segmentsCount;
        this.segmentsPercent = segmentsPercent;
        this.durationMs = durationMs;
        this.minScore = minScore;
        this.maxScore = maxScore;
        this.clusterExamples = clusterExamples;
        this.clusterModelId = clusterModelId;
    }
}

