/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.anomaly;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.model.anomaly.AnomalyDto;

@Repository
public interface AnomalyRepository
extends CrudRepository<AnomalyDto, UUID> {
    @Query(value="SELECT a\nFROM AnomalyDto a\nWHERE\n    (coalesce(:itemIds, null) is null or a.itemId in (:itemIds)) and\n    (coalesce(:modelIds, null) is null or a.modelId in (:modelIds)) and\n    (coalesce(:startTs, null) is null or a.endTs >= (:startTs)) and\n    (coalesce(:endTs, null) is null or a.startTs <= (:endTs)) and\n    (coalesce(:minScore, null) is null or a.score >= (:minScore))\n")
    public List<AnomalyDto> find(@Param(value="itemIds") Set<UUID> var1, @Param(value="modelIds") Set<UUID> var2, @Param(value="startTs") Long var3, @Param(value="endTs") Long var4, @Param(value="minScore") Double var5);

    @Query(value="SELECT a.id\nFROM AnomalyDto a\nWHERE a.modelId = :modelId\n")
    public Set<UUID> getAllIdsByModelId(@Param(value="modelId") UUID var1);

    @Modifying
    @Query(value="DELETE FROM AnomalyDto a\nWHERE a.modelId = :modelId\n")
    public void deleteByModelId(@Param(value="modelId") UUID var1);

    @Modifying
    @Query(value="DELETE FROM AnomalyDto a\nWHERE a.id in (:ids)\n")
    public void deleteAllByIds(@Param(value="ids") Set<UUID> var1);

    @Modifying
    @Query(value="UPDATE AnomalyDto a\nSET a.alarmId = :alarmId\nWHERE a.id = :id\n")
    public void populateAlarmId(UUID var1, UUID var2);

    @Query(value="SELECT MIN(a.score)\nFROM AnomalyDto a\nWHERE a.modelId = :modelId\n")
    public Optional<Integer> getMinAnomalyScoreFotModel(UUID var1);
}

