/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.metric;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.metric.MetricDefinitionDto;

@Repository
public interface MetricDefinitionRepository
extends JpaRepository<MetricDefinitionDto, UUID> {
    @Modifying
    @Query(value="DELETE FROM metric_definition md\nWHERE md.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or md.customerId = :customerId)\n    AND md.businessEntityId IN :businessEntityIdSet\n    AND md.autoDeletable\n")
    public void autoDeleteByBusinessEntityIds(UUID var1, UUID var2, Set<UUID> var3);

    @Query(value="SELECT md\nFROM metric_definition md\nWHERE md.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or md.customerId = :customerId)\n    AND (coalesce(:businessEntityId, null) is null or md.businessEntityId = :businessEntityId)\n    AND (coalesce(:itemId, null) is null or md.itemId = :itemId)\n    AND (coalesce(:autoDeletable, null) is null or md.autoDeletable = :autoDeletable)\n    AND (coalesce(:advancedMode, null) is null or md.isAdvancedMode = :advancedMode)\n")
    public Page<MetricDefinitionDto> findAllByTenantIdAndCustomerId(UUID var1, UUID var2, UUID var3, UUID var4, Boolean var5, Boolean var6, Pageable var7);

    @Query(value="SELECT md\nFROM metric_definition md\nWHERE md.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or md.customerId = :customerId)\n")
    public List<MetricDefinitionDto> findAllByTenantIdAndCustomerId(UUID var1, UUID var2);

    @Query(value="SELECT md\nFROM metric_definition md\nWHERE md.businessEntityId = :businessEntityId\n    AND NOT md.autoDeletable\n    AND md.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or md.customerId = :customerId)\n")
    public List<MetricDefinitionDto> findAllSavedByBusinessEntityId(UUID var1, UUID var2, UUID var3);

    @Query(value="SELECT md\nFROM metric_definition md\nWHERE md.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or md.customerId = :customerId)\n    AND md.id = :metricDefinitionId\n")
    public Optional<MetricDefinitionDto> findMetricDefinitionById(UUID var1, UUID var2, UUID var3);

    @Query(value="SELECT md\nFROM metric_definition md\nWHERE md.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or md.customerId = :customerId)\n    AND md.calculationFieldId = :calculationFieldId\n")
    public Optional<MetricDefinitionDto> findMetricDefinitionCalculationFieldId(UUID var1, UUID var2, UUID var3);

    @Modifying
    @Query(value="DELETE FROM metric_definition md\nWHERE md.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or md.customerId = :customerId)\n    AND md.id = :metricDefinitionId\n")
    public void deleteById(UUID var1, UUID var2, UUID var3);

    @Modifying
    @Query(value="UPDATE metric_definition md\nSET md.isOutdated = (CASE WHEN md.code <> :script THEN true ELSE false END)\nWHERE md.calculationFieldId = :calculationFieldId\n    AND md.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or md.customerId = :customerId)\n")
    public void makeOutdated(UUID var1, String var2, UUID var3, UUID var4);
}

