/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.metric;

import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.metric.MetricDefinitionDto;
import org.thingsboard.trendz.dao.metric.MetricDefinitionMetadataDto;
import org.thingsboard.trendz.dao.metric.MetricDefinitionMetadataRepository;
import org.thingsboard.trendz.dao.metric.MetricDefinitionRepository;
import org.thingsboard.trendz.domain.definition.calculation.CalculationField;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.MetricDefinitionFilteringField;
import org.thingsboard.trendz.domain.metric.MetricDefinitionMetadata;
import org.thingsboard.trendz.domain.metric.MetricDefinitionSortingField;
import org.thingsboard.trendz.exception.metric.MetricDefinitionNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.tools.UUIDUtils;

@Service
@Transactional
public class MetricDefinitionDao {
    private static final Logger log = LoggerFactory.getLogger(MetricDefinitionDao.class);
    private final MetricDefinitionRepository metricDefinitionRepository;
    private final MetricDefinitionMetadataRepository metricDefinitionMetadataRepository;

    @Autowired
    public MetricDefinitionDao(MetricDefinitionRepository metricDefinitionRepository, MetricDefinitionMetadataRepository metricDefinitionMetadataRepository) {
        this.metricDefinitionRepository = metricDefinitionRepository;
        this.metricDefinitionMetadataRepository = metricDefinitionMetadataRepository;
    }

    public void rewriteWith(List<MetricDefinition> metricDefinitions, JwtSecurityUser user, boolean deleteUnsaved) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        Set businessEntityIdSet = metricDefinitions.stream().map(MetricDefinition::getBusinessEntityId).collect(Collectors.toSet());
        if (deleteUnsaved) {
            this.metricDefinitionRepository.autoDeleteByBusinessEntityIds(tenantId, customerId, businessEntityIdSet);
        }
        List<MetricDefinitionDto> metricDefinitionDtos = metricDefinitions.stream().map(MetricDefinitionDto::from).toList();
        this.metricDefinitionRepository.saveAll(metricDefinitionDtos);
        List<MetricDefinitionMetadataDto> metricDefinitionMetadataDtos = metricDefinitions.stream().map(MetricDefinitionMetadataDto::from).toList();
        this.metricDefinitionMetadataRepository.saveAll(metricDefinitionMetadataDtos);
    }

    public List<MetricDefinition> saveAll(List<MetricDefinition> metricDefinitions) {
        List<MetricDefinitionDto> dtos = metricDefinitions.stream().map(MetricDefinitionDto::from).toList();
        return this.metricDefinitionRepository.saveAll(dtos).stream().map(MetricDefinitionDto::toData).toList();
    }

    public List<MetricDefinitionMetadata> saveAllMetadata(List<MetricDefinitionMetadata> metadataList) {
        List<MetricDefinitionMetadataDto> dtos = metadataList.stream().map(MetricDefinitionMetadataDto::from).toList();
        return this.metricDefinitionMetadataRepository.saveAll(dtos).stream().map(MetricDefinitionMetadataDto::toData).toList();
    }

    public List<MetricDefinitionMetadata> getAllMetadata(JwtSecurityUser securityUser) {
        UUID tenantId = securityUser.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(securityUser.getCustomerId()) ? null : securityUser.getCustomerId();
        return this.metricDefinitionMetadataRepository.findAllByTenantIdAndCustomerId(tenantId, customerId).stream().map(MetricDefinitionMetadataDto::toData).toList();
    }

    public List<MetricDefinitionMetadata> getRecentMetadata(JwtSecurityUser securityUser, UUID businessEntityId, UUID itemId, boolean advancedMode, int limit) {
        UUID tenantId = securityUser.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(securityUser.getCustomerId()) ? null : securityUser.getCustomerId();
        return this.metricDefinitionMetadataRepository.findRecentMetadata(tenantId, customerId, businessEntityId, itemId, advancedMode, limit).stream().map(MetricDefinitionMetadataDto::toData).toList();
    }

    public Page<MetricDefinition> getAllMetricDefinitions(int page, int pageSize, JwtSecurityUser securityUser, List<MetricDefinitionFilteringField> filteringFields, List<MetricDefinitionSortingField> sortingFields) {
        long startTime = System.currentTimeMillis();
        UUID tenantId = securityUser.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(securityUser.getCustomerId()) ? null : securityUser.getCustomerId();
        Map<MetricDefinitionFilteringField.Type, String> filterMap = filteringFields.stream().collect(Collectors.toMap(MetricDefinitionFilteringField::getType, MetricDefinitionFilteringField::getValue));
        UUID businessEntityId = Optional.ofNullable(filterMap.get(MetricDefinitionFilteringField.Type.BUSINESS_ENTITY_ID)).map(UUIDUtils::parse).orElse(null);
        UUID itemId = Optional.ofNullable(filterMap.get(MetricDefinitionFilteringField.Type.ITEM_ID)).map(UUIDUtils::parse).orElse(null);
        Boolean autoDeletable = Optional.ofNullable(filterMap.get(MetricDefinitionFilteringField.Type.AUTO_DELETABLE)).map(Boolean::parseBoolean).orElse(null);
        Boolean advancedMode = Optional.ofNullable(filterMap.get(MetricDefinitionFilteringField.Type.ADVANCED_MODE)).map(Boolean::parseBoolean).orElse(null);
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).collect(Collectors.toList());
        Page metricDefinitions = this.metricDefinitionRepository.findAllByTenantIdAndCustomerId(tenantId, customerId, businessEntityId, itemId, autoDeletable, advancedMode, (Pageable)PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders))).map(MetricDefinitionDto::toData);
        long endTime = System.currentTimeMillis();
        log.debug("Metric definitions' page has been loaded, count = {}, time = {}", (Object)metricDefinitions.getSize(), (Object)(endTime - startTime));
        return metricDefinitions;
    }

    public List<MetricDefinition> getAllMetricDefinitions(JwtSecurityUser securityUser) {
        UUID tenantId = securityUser.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(securityUser.getCustomerId()) ? null : securityUser.getCustomerId();
        return this.metricDefinitionRepository.findAllByTenantIdAndCustomerId(tenantId, customerId).stream().map(MetricDefinitionDto::toData).toList();
    }

    public MetricDefinition findMetricDefinitionById(UUID metricDefinitionId, JwtSecurityUser securityUser) {
        UUID tenantId = securityUser.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(securityUser.getCustomerId()) ? null : securityUser.getCustomerId();
        return this.metricDefinitionRepository.findMetricDefinitionById(metricDefinitionId, tenantId, customerId).map(MetricDefinitionDto::toData).orElseThrow(() -> new MetricDefinitionNotFoundException(metricDefinitionId));
    }

    public Optional<MetricDefinition> findMetricDefinitionCalculationFieldId(UUID calculationFieldId, JwtSecurityUser securityUser) {
        UUID tenantId = securityUser.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(securityUser.getCustomerId()) ? null : securityUser.getCustomerId();
        return this.metricDefinitionRepository.findMetricDefinitionCalculationFieldId(calculationFieldId, tenantId, customerId).map(MetricDefinitionDto::toData);
    }

    public MetricDefinition save(MetricDefinition metricDefinition) {
        return this.save(metricDefinition, System.currentTimeMillis());
    }

    public MetricDefinition save(MetricDefinition metricDefinition, long now) {
        metricDefinition.setUpdatedTs(now);
        MetricDefinition saved = ((MetricDefinitionDto)this.metricDefinitionRepository.save((Object)MetricDefinitionDto.from((MetricDefinition)metricDefinition))).toData();
        this.metricDefinitionMetadataRepository.save((Object)this.fromMetricDefinition(metricDefinition));
        return saved;
    }

    public void deleteMetricDefinitionById(UUID metricDefinitionId, JwtSecurityUser securityUser) {
        UUID tenantId = securityUser.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(securityUser.getCustomerId()) ? null : securityUser.getCustomerId();
        this.metricDefinitionRepository.findMetricDefinitionById(metricDefinitionId, tenantId, customerId).ifPresent(metricDefinitionDto -> {
            MetricDefinitionMetadataDto metricDefinitionMetadataDto = this.fromMetricDefinition(metricDefinitionDto.toData());
            metricDefinitionMetadataDto.setSaved(false);
            this.metricDefinitionMetadataRepository.save((Object)metricDefinitionMetadataDto);
            this.metricDefinitionRepository.deleteById(metricDefinitionId, tenantId, customerId);
        });
    }

    public void makeMetricDefinitionsOutdated(CalculationField calculationField, JwtSecurityUser securityUser) {
        UUID tenantId = securityUser.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(securityUser.getCustomerId()) ? null : securityUser.getCustomerId();
        this.metricDefinitionRepository.makeOutdated(calculationField.getId(), calculationField.getScript(), tenantId, customerId);
    }

    public List<MetricDefinition> findAllSavedByBusinessEntityId(UUID businessEntityId, JwtSecurityUser securityUser) {
        UUID tenantId = securityUser.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(securityUser.getCustomerId()) ? null : securityUser.getCustomerId();
        return this.metricDefinitionRepository.findAllSavedByBusinessEntityId(businessEntityId, tenantId, customerId).stream().map(MetricDefinitionDto::toData).toList();
    }

    private MetricDefinitionMetadataDto fromMetricDefinition(MetricDefinition metricDefinition) {
        return this.metricDefinitionMetadataRepository.findByMetricId(metricDefinition.getId()).map(metadata -> metadata.populateFrom(metricDefinition)).orElseGet(() -> MetricDefinitionMetadataDto.from((MetricDefinition)metricDefinition));
    }
}

