/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.customize;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.customize.UserRecordDto;
import org.thingsboard.trendz.dao.customize.UserRecordDtoId;
import org.thingsboard.trendz.dao.customize.UserRecordRepository;
import org.thingsboard.trendz.domain.customize.UserRecord;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;

@Service
public class UserRecordDao {
    private static final Logger log = LoggerFactory.getLogger(UserRecordDao.class);
    private final UserRecordRepository recordRepository;

    @Autowired
    public UserRecordDao(UserRecordRepository recordRepository) {
        this.recordRepository = recordRepository;
    }

    public Optional<UserRecord> findById(UserRecordDtoId id) {
        return this.recordRepository.findById((Object)id).map(UserRecordDto::toData);
    }

    public UserRecord save(UserRecord record) {
        UserRecordDto recordDto = UserRecordDto.from((UserRecord)record);
        return ((UserRecordDto)this.recordRepository.save((Object)recordDto)).toData();
    }

    public Page<JwtSecurityUser> getAllUserIds(int page, int pageSize) {
        return this.recordRepository.getAllTenantIds((Pageable)PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.by((String)"visitFirstTs")}))).map(UserRecordDtoId::toUser);
    }

    public Set<UUID> getAllTenantIds() {
        return this.recordRepository.getAllTenantIds();
    }

    public Set<UserRecordDtoId> getAllFirstTenantUserIds() {
        return this.recordRepository.findAllFirstTenantIds().stream().map(UserRecordDtoId::fromArray).collect(Collectors.toSet());
    }

    public Optional<UserRecord> findFirstTenantUserByTenantId(UUID tenantId) {
        return this.recordRepository.findFirstTenantUserByTenantId(tenantId, EntityId.NULL_UUID).map(UserRecordDto::toData);
    }

    public Page<JwtSecurityUser> findAllTenantUserByTenantId(UUID tenantId, int page, int pageSize) {
        return this.recordRepository.findAllTenantUserByTenantId(tenantId, EntityId.NULL_UUID, (Pageable)PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.by((String)"visitFirstTs")}))).map(UserRecordDtoId::toUser);
    }
}

