/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.customize;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.customize.CustomViewSettingsDto;
import org.thingsboard.trendz.dao.customize.CustomViewSettingsRepository;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;

@Service
public class CustomViewSettingsDao {
    private static final Logger log = LoggerFactory.getLogger(CustomViewSettingsDao.class);
    private final CustomViewSettingsRepository customViewSettingsRepository;

    @Autowired
    public CustomViewSettingsDao(CustomViewSettingsRepository customViewSettingsRepository) {
        this.customViewSettingsRepository = customViewSettingsRepository;
    }

    public Optional<CustomViewSettings> findCustomSettings(String domain) {
        return this.customViewSettingsRepository.findById((Object)domain).map(CustomViewSettingsDto::toData);
    }

    public CustomViewSettings saveCustomSettings(CustomViewSettings settings) {
        return ((CustomViewSettingsDto)this.customViewSettingsRepository.save((Object)CustomViewSettingsDto.from((CustomViewSettings)settings))).toData();
    }
}

