/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.calculation;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Set;
import java.util.UUID;
import org.thingsboard.trendz.dao.calculation.CalculationFieldTaskDataDto;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTaskData;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="calculation_field_task_data")
public class CalculationFieldTaskDataDto {
    @Id
    @Column(name="calculation_field_id")
    private UUID calculationFieldId;
    @Column(name="enabled")
    private boolean enabled;
    @Column(name="tz_name")
    private String tzName;
    @Column(name="json_item_name_set")
    private String jsonItemNameSet;
    @Column(name="json_item_set")
    private String jsonItemSet;
    @Column(name="json_reprocess_date_picker_config")
    private String jsonReprocessDatePickerConfig;
    @Column(name="refresh_time_unit")
    @Enumerated(value=EnumType.STRING)
    private DateAggregationUnit refreshTimeUnit;
    @Column(name="refresh_time_unit_count")
    private int refreshTimeUnitCount;
    @Column(name="refresh_time_unit_truncated")
    private boolean refreshTimeUnitTruncated;

    public CalculationFieldTaskData toData() {
        CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(Set.class, ItemLite.class);
        return CalculationFieldTaskData.builder().calculationFieldId(this.calculationFieldId).enabled(this.enabled).tzName(this.tzName).itemSet((Set)JsonUtils.fromJson((String)this.jsonItemSet, (JavaType)type)).reprocessDatePickerConfig((DatePickerConfig)JsonUtils.fromJson((String)this.jsonReprocessDatePickerConfig, DatePickerConfig.class)).refreshTimeUnit(this.refreshTimeUnit).refreshTimeUnitCount(this.refreshTimeUnitCount).refreshTimeUnitTruncated(this.refreshTimeUnitTruncated).schedulingTime(0L).build();
    }

    public static CalculationFieldTaskDataDto from(CalculationFieldTaskData entity) {
        return CalculationFieldTaskDataDto.builder().calculationFieldId(entity.getCalculationFieldId()).enabled(entity.isEnabled()).tzName(entity.getTzName()).jsonItemSet(JsonUtils.toJson((Object)entity.getItemSet())).jsonReprocessDatePickerConfig(JsonUtils.toJson((Object)entity.getReprocessDatePickerConfig())).refreshTimeUnit(entity.getRefreshTimeUnit()).refreshTimeUnitCount(entity.getRefreshTimeUnitCount()).refreshTimeUnitTruncated(entity.isRefreshTimeUnitTruncated()).build();
    }

    public static CalculationFieldTaskDataDtoBuilder builder() {
        return new CalculationFieldTaskDataDtoBuilder();
    }

    public UUID getCalculationFieldId() {
        return this.calculationFieldId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTzName() {
        return this.tzName;
    }

    public String getJsonItemNameSet() {
        return this.jsonItemNameSet;
    }

    public String getJsonItemSet() {
        return this.jsonItemSet;
    }

    public String getJsonReprocessDatePickerConfig() {
        return this.jsonReprocessDatePickerConfig;
    }

    public DateAggregationUnit getRefreshTimeUnit() {
        return this.refreshTimeUnit;
    }

    public int getRefreshTimeUnitCount() {
        return this.refreshTimeUnitCount;
    }

    public boolean isRefreshTimeUnitTruncated() {
        return this.refreshTimeUnitTruncated;
    }

    public void setCalculationFieldId(UUID calculationFieldId) {
        this.calculationFieldId = calculationFieldId;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    public void setJsonItemNameSet(String jsonItemNameSet) {
        this.jsonItemNameSet = jsonItemNameSet;
    }

    public void setJsonItemSet(String jsonItemSet) {
        this.jsonItemSet = jsonItemSet;
    }

    public void setJsonReprocessDatePickerConfig(String jsonReprocessDatePickerConfig) {
        this.jsonReprocessDatePickerConfig = jsonReprocessDatePickerConfig;
    }

    public void setRefreshTimeUnit(DateAggregationUnit refreshTimeUnit) {
        this.refreshTimeUnit = refreshTimeUnit;
    }

    public void setRefreshTimeUnitCount(int refreshTimeUnitCount) {
        this.refreshTimeUnitCount = refreshTimeUnitCount;
    }

    public void setRefreshTimeUnitTruncated(boolean refreshTimeUnitTruncated) {
        this.refreshTimeUnitTruncated = refreshTimeUnitTruncated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculationFieldTaskDataDto)) {
            return false;
        }
        CalculationFieldTaskDataDto other = (CalculationFieldTaskDataDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getRefreshTimeUnitCount() != other.getRefreshTimeUnitCount()) {
            return false;
        }
        if (this.isRefreshTimeUnitTruncated() != other.isRefreshTimeUnitTruncated()) {
            return false;
        }
        UUID this$calculationFieldId = this.getCalculationFieldId();
        UUID other$calculationFieldId = other.getCalculationFieldId();
        if (this$calculationFieldId == null ? other$calculationFieldId != null : !((Object)this$calculationFieldId).equals(other$calculationFieldId)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        if (this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName)) {
            return false;
        }
        String this$jsonItemNameSet = this.getJsonItemNameSet();
        String other$jsonItemNameSet = other.getJsonItemNameSet();
        if (this$jsonItemNameSet == null ? other$jsonItemNameSet != null : !this$jsonItemNameSet.equals(other$jsonItemNameSet)) {
            return false;
        }
        String this$jsonItemSet = this.getJsonItemSet();
        String other$jsonItemSet = other.getJsonItemSet();
        if (this$jsonItemSet == null ? other$jsonItemSet != null : !this$jsonItemSet.equals(other$jsonItemSet)) {
            return false;
        }
        String this$jsonReprocessDatePickerConfig = this.getJsonReprocessDatePickerConfig();
        String other$jsonReprocessDatePickerConfig = other.getJsonReprocessDatePickerConfig();
        if (this$jsonReprocessDatePickerConfig == null ? other$jsonReprocessDatePickerConfig != null : !this$jsonReprocessDatePickerConfig.equals(other$jsonReprocessDatePickerConfig)) {
            return false;
        }
        DateAggregationUnit this$refreshTimeUnit = this.getRefreshTimeUnit();
        DateAggregationUnit other$refreshTimeUnit = other.getRefreshTimeUnit();
        return !(this$refreshTimeUnit == null ? other$refreshTimeUnit != null : !this$refreshTimeUnit.equals(other$refreshTimeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalculationFieldTaskDataDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getRefreshTimeUnitCount();
        result = result * 59 + (this.isRefreshTimeUnitTruncated() ? 79 : 97);
        UUID $calculationFieldId = this.getCalculationFieldId();
        result = result * 59 + ($calculationFieldId == null ? 43 : ((Object)$calculationFieldId).hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        String $jsonItemNameSet = this.getJsonItemNameSet();
        result = result * 59 + ($jsonItemNameSet == null ? 43 : $jsonItemNameSet.hashCode());
        String $jsonItemSet = this.getJsonItemSet();
        result = result * 59 + ($jsonItemSet == null ? 43 : $jsonItemSet.hashCode());
        String $jsonReprocessDatePickerConfig = this.getJsonReprocessDatePickerConfig();
        result = result * 59 + ($jsonReprocessDatePickerConfig == null ? 43 : $jsonReprocessDatePickerConfig.hashCode());
        DateAggregationUnit $refreshTimeUnit = this.getRefreshTimeUnit();
        result = result * 59 + ($refreshTimeUnit == null ? 43 : $refreshTimeUnit.hashCode());
        return result;
    }

    public String toString() {
        return "CalculationFieldTaskDataDto(calculationFieldId=" + String.valueOf(this.getCalculationFieldId()) + ", enabled=" + this.isEnabled() + ", tzName=" + this.getTzName() + ", jsonItemNameSet=" + this.getJsonItemNameSet() + ", jsonItemSet=" + this.getJsonItemSet() + ", jsonReprocessDatePickerConfig=" + this.getJsonReprocessDatePickerConfig() + ", refreshTimeUnit=" + String.valueOf(this.getRefreshTimeUnit()) + ", refreshTimeUnitCount=" + this.getRefreshTimeUnitCount() + ", refreshTimeUnitTruncated=" + this.isRefreshTimeUnitTruncated() + ")";
    }

    public CalculationFieldTaskDataDto() {
    }

    public CalculationFieldTaskDataDto(UUID calculationFieldId, boolean enabled, String tzName, String jsonItemNameSet, String jsonItemSet, String jsonReprocessDatePickerConfig, DateAggregationUnit refreshTimeUnit, int refreshTimeUnitCount, boolean refreshTimeUnitTruncated) {
        this.calculationFieldId = calculationFieldId;
        this.enabled = enabled;
        this.tzName = tzName;
        this.jsonItemNameSet = jsonItemNameSet;
        this.jsonItemSet = jsonItemSet;
        this.jsonReprocessDatePickerConfig = jsonReprocessDatePickerConfig;
        this.refreshTimeUnit = refreshTimeUnit;
        this.refreshTimeUnitCount = refreshTimeUnitCount;
        this.refreshTimeUnitTruncated = refreshTimeUnitTruncated;
    }
}

