/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.calculation;

import jakarta.transaction.Transactional;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.calculation.CalculationFieldTaskDataDto;
import org.thingsboard.trendz.dao.calculation.CalculationFieldTaskDataRepository;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTaskData;

@Service
@Transactional
public class CalculationFieldTaskDataDao {
    private static final Logger log = LoggerFactory.getLogger(CalculationFieldTaskDataDao.class);
    private final CalculationFieldTaskDataRepository calculationFieldTaskDataRepository;

    @Autowired
    public CalculationFieldTaskDataDao(CalculationFieldTaskDataRepository calculationFieldTaskDataRepository) {
        this.calculationFieldTaskDataRepository = calculationFieldTaskDataRepository;
    }

    public Optional<CalculationFieldTaskData> findById(UUID calculationFieldId) {
        return this.calculationFieldTaskDataRepository.findById((Object)calculationFieldId).map(CalculationFieldTaskDataDto::toData);
    }

    public CalculationFieldTaskData save(CalculationFieldTaskData taskData) {
        CalculationFieldTaskDataDto dto = CalculationFieldTaskDataDto.from((CalculationFieldTaskData)taskData);
        CalculationFieldTaskDataDto saved = (CalculationFieldTaskDataDto)this.calculationFieldTaskDataRepository.save((Object)dto);
        return saved.toData();
    }

    public void delete(UUID calculationFieldId) {
        this.calculationFieldTaskDataRepository.deleteById((Object)calculationFieldId);
    }
}

