/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.calculation;

import jakarta.transaction.Transactional;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.calculation.CalculationFieldDto;
import org.thingsboard.trendz.dao.calculation.CalculationFieldRepository;
import org.thingsboard.trendz.dao.manual.ManualDatasetDto;
import org.thingsboard.trendz.dao.manual.ManualDatasetRepository;
import org.thingsboard.trendz.domain.definition.calculation.CalculationField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldFilteringField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldLite;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldSortingField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldType;
import org.thingsboard.trendz.domain.definition.view.config.ScriptLanguage;
import org.thingsboard.trendz.domain.manual.ManualDataset;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationItem;
import org.thingsboard.trendz.tools.UUIDUtils;

@Service
@Transactional
public class CalculationFieldDao {
    private static final Logger log = LoggerFactory.getLogger(CalculationFieldDao.class);
    private final CalculationFieldRepository calculationFieldRepository;
    private final ManualDatasetRepository manualDatasetRepository;

    @Autowired
    public CalculationFieldDao(CalculationFieldRepository calculationFieldRepository, ManualDatasetRepository manualDatasetRepository) {
        this.calculationFieldRepository = calculationFieldRepository;
        this.manualDatasetRepository = manualDatasetRepository;
    }

    public Page<CalculationFieldLite> getAllLite(JwtSecurityUser user, int page, int pageSize, List<CalculationFieldFilteringField> filteringFields, List<CalculationFieldSortingField> sortingFields) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        Map<CalculationFieldFilteringField.Type, String> filterMap = filteringFields.stream().filter(field -> field.getType() != CalculationFieldFilteringField.Type.BUSINESS_ENTITY_ID).collect(Collectors.toMap(CalculationFieldFilteringField::getType, CalculationFieldFilteringField::getValue));
        Boolean enabled = Optional.ofNullable(filterMap.get(CalculationFieldFilteringField.Type.ENABLED)).map(Boolean::parseBoolean).orElse(null);
        String name = Optional.ofNullable(filterMap.get(CalculationFieldFilteringField.Type.NAME)).map(urlEncodedNameParam -> URLDecoder.decode(urlEncodedNameParam, StandardCharsets.UTF_8)).map(String::toLowerCase).orElse(null);
        ScriptLanguage language = Optional.ofNullable(filterMap.get(CalculationFieldFilteringField.Type.LANGUAGE)).map(ScriptLanguage::valueOf).orElse(null);
        CalculationFieldType type = Optional.ofNullable(filterMap.get(CalculationFieldFilteringField.Type.TYPE)).map(CalculationFieldType::valueOf).orElse(null);
        Set businessEntityIdSet = filteringFields.stream().filter(field -> field.getType() == CalculationFieldFilteringField.Type.BUSINESS_ENTITY_ID).map(CalculationFieldFilteringField::getValue).map(UUIDUtils::parse).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> set.isEmpty() ? null : set));
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).collect(Collectors.toList());
        return this.calculationFieldRepository.findAllByTenantIdAndCustomerId(tenantId, customerId, enabled, name, language, type, businessEntityIdSet, PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
    }

    public List<CalculationField> getAll(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.calculationFieldRepository.findByTenantIdAndCustomerId(tenantId, customerId).stream().map(calculationFieldDto -> {
            ManualDataset dataset = ((ManualDatasetDto)this.manualDatasetRepository.findById((Object)calculationFieldDto.getManualDatasetId()).orElseThrow()).toData();
            CalculationField result = calculationFieldDto.toData();
            result.setManualDataset(dataset);
            return result;
        }).toList();
    }

    public Optional<CalculationField> findById(JwtSecurityUser user, UUID id, boolean insecure) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.calculationFieldRepository.findByIdAndTenantIdAndCustomerId(id, tenantId, customerId, insecure).map(calculationFieldDto -> {
            ManualDataset dataset = ((ManualDatasetDto)this.manualDatasetRepository.findById((Object)calculationFieldDto.getManualDatasetId()).orElseThrow()).toData();
            CalculationField result = calculationFieldDto.toData();
            result.setManualDataset(dataset);
            return result;
        });
    }

    public Optional<CalculationField> findByName(JwtSecurityUser user, String name) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.calculationFieldRepository.findByNameAndTenantIdAndCustomerId(name, tenantId, customerId).map(calculationFieldDto -> {
            ManualDataset dataset = ((ManualDatasetDto)this.manualDatasetRepository.findById((Object)calculationFieldDto.getManualDatasetId()).orElseThrow()).toData();
            CalculationField result = calculationFieldDto.toData();
            result.setManualDataset(dataset);
            return result;
        });
    }

    public CalculationField save(CalculationField calculationField) {
        ManualDataset dataset = calculationField.getManualDataset();
        ManualDatasetDto savedDatasetDto = (ManualDatasetDto)this.manualDatasetRepository.save((Object)ManualDatasetDto.from((ManualDataset)dataset));
        ManualDataset savedDataset = savedDatasetDto.toData();
        CalculationFieldDto calculationFieldDto = CalculationFieldDto.from((CalculationField)calculationField, (UUID)savedDataset.getId());
        CalculationFieldDto savedDto = (CalculationFieldDto)this.calculationFieldRepository.save((Object)calculationFieldDto);
        CalculationField saved = savedDto.toData();
        saved.setManualDataset(savedDataset);
        return saved;
    }

    public void delete(JwtSecurityUser user, UUID id) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        this.calculationFieldRepository.deleteByIdAndTenantIdAndCustomerId(id, tenantId, customerId);
    }

    public void rename(String newName, JwtSecurityUser user, UUID id) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        this.calculationFieldRepository.renameByIdAndTenantIdAndCustomerId(newName, id, tenantId, customerId);
    }

    public boolean existsWithName(JwtSecurityUser user, String name) {
        int count = this.calculationFieldRepository.countAllByTenantIdAndName(name, user.getTenantId());
        if (count > 1 || count < 0) {
            throw new TrendzInternalException("Impossible value of the record count: " + count);
        }
        return count == 1;
    }

    public Optional<CalculationField> findByEntityFieldId(UUID entityFieldId, JwtSecurityUser securityUser, boolean insecure) {
        return this.calculationFieldRepository.findByAssociatedEntityFieldIdAndTenantIdAndCustomerId(entityFieldId, securityUser.getTenantId(), securityUser.getCustomerId(), insecure).map(CalculationFieldDto::toData);
    }

    public void updateEnabling(JwtSecurityUser user, UUID id, boolean enabled) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        this.calculationFieldRepository.updateEnablingByIdAndTenantIdAndCustomerId(id, tenantId, customerId, enabled);
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, UUID fieldId, Set<UUID> subCustomers) {
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        Set dependencyItemSet = this.calculationFieldRepository.findDependedEntities(fieldId, tenantId, customerId, subCustomers, EntityId.NULL_UUID).stream().map(array -> new ChangeEntityValidationItem((String)array[0], (String)array[1])).collect(Collectors.toSet());
        return new ChangeEntityValidationInfo(dependencyItemSet);
    }
}

