/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.cache;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import java.util.UUID;
import org.springframework.data.domain.Persistable;
import org.thingsboard.trendz.dao.cache.CachedTelemetryPointDto;
import org.thingsboard.trendz.dao.cache.CachedTelemetryPointDtoId;
import org.thingsboard.trendz.domain.cache.CachedTelemetryPoint;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.exception.TrendzInternalException;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="cached_telemetry_point")
@IdClass(value=CachedTelemetryPointDtoId.class)
public class CachedTelemetryPointDto
implements Persistable<CachedTelemetryPointDtoId> {
    @Id
    @Column(name="ts")
    private long ts;
    @Id
    @Column(name="cached_telemetry_id")
    private UUID cachedTelemetryId;
    @Column(name="numeric_value")
    private Double numericValue;
    @Column(name="string_value")
    private String stringValue;
    @Column(name="boolean_value")
    private Boolean booleanValue;

    public CachedTelemetryPoint toData() {
        Object value = null;
        value = value == null ? this.numericValue : value;
        value = value == null ? this.stringValue : value;
        value = value == null ? this.booleanValue : value;
        return CachedTelemetryPoint.builder().ts(this.ts).value(value).build();
    }

    public static CachedTelemetryPointDto from(CachedTelemetryPoint entity, UUID cachedTelemetryId, FieldType fieldType) {
        CachedTelemetryPointDtoBuilder builder = CachedTelemetryPointDto.builder().ts(entity.getTs()).cachedTelemetryId(cachedTelemetryId);
        try {
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[fieldType.ordinal()]) {
                case 1: 
                case 2: {
                    if (entity.getValue() != null) {
                        builder = builder.numericValue(Double.valueOf(String.valueOf(entity.getValue())));
                    }
                    break;
                }
                case 3: {
                    builder = builder.booleanValue((Boolean)entity.getValue());
                    break;
                }
                case 4: 
                case 5: {
                    builder = builder.stringValue((String)entity.getValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Field Type: " + String.valueOf(fieldType));
                }
            }
        }
        catch (Exception e) {
            throw new TrendzInternalException("Can not create cache point value with: value = " + String.valueOf(entity.getValue()) + ", field type = " + String.valueOf(fieldType), (Throwable)e);
        }
        return builder.build();
    }

    public CachedTelemetryPointDtoId getId() {
        return new CachedTelemetryPointDtoId(this.ts, this.cachedTelemetryId);
    }

    public boolean isNew() {
        return true;
    }

    public static CachedTelemetryPointDtoBuilder builder() {
        return new CachedTelemetryPointDtoBuilder();
    }

    public long getTs() {
        return this.ts;
    }

    public UUID getCachedTelemetryId() {
        return this.cachedTelemetryId;
    }

    public Double getNumericValue() {
        return this.numericValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public void setCachedTelemetryId(UUID cachedTelemetryId) {
        this.cachedTelemetryId = cachedTelemetryId;
    }

    public void setNumericValue(Double numericValue) {
        this.numericValue = numericValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public void setBooleanValue(Boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachedTelemetryPointDto)) {
            return false;
        }
        CachedTelemetryPointDto other = (CachedTelemetryPointDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        Double this$numericValue = this.getNumericValue();
        Double other$numericValue = other.getNumericValue();
        if (this$numericValue == null ? other$numericValue != null : !((Object)this$numericValue).equals(other$numericValue)) {
            return false;
        }
        Boolean this$booleanValue = this.getBooleanValue();
        Boolean other$booleanValue = other.getBooleanValue();
        if (this$booleanValue == null ? other$booleanValue != null : !((Object)this$booleanValue).equals(other$booleanValue)) {
            return false;
        }
        UUID this$cachedTelemetryId = this.getCachedTelemetryId();
        UUID other$cachedTelemetryId = other.getCachedTelemetryId();
        if (this$cachedTelemetryId == null ? other$cachedTelemetryId != null : !((Object)this$cachedTelemetryId).equals(other$cachedTelemetryId)) {
            return false;
        }
        String this$stringValue = this.getStringValue();
        String other$stringValue = other.getStringValue();
        return !(this$stringValue == null ? other$stringValue != null : !this$stringValue.equals(other$stringValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CachedTelemetryPointDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        Double $numericValue = this.getNumericValue();
        result = result * 59 + ($numericValue == null ? 43 : ((Object)$numericValue).hashCode());
        Boolean $booleanValue = this.getBooleanValue();
        result = result * 59 + ($booleanValue == null ? 43 : ((Object)$booleanValue).hashCode());
        UUID $cachedTelemetryId = this.getCachedTelemetryId();
        result = result * 59 + ($cachedTelemetryId == null ? 43 : ((Object)$cachedTelemetryId).hashCode());
        String $stringValue = this.getStringValue();
        result = result * 59 + ($stringValue == null ? 43 : $stringValue.hashCode());
        return result;
    }

    public String toString() {
        return "CachedTelemetryPointDto(ts=" + this.getTs() + ", cachedTelemetryId=" + String.valueOf(this.getCachedTelemetryId()) + ", numericValue=" + this.getNumericValue() + ", stringValue=" + this.getStringValue() + ", booleanValue=" + this.getBooleanValue() + ")";
    }

    public CachedTelemetryPointDto() {
    }

    public CachedTelemetryPointDto(long ts, UUID cachedTelemetryId, Double numericValue, String stringValue, Boolean booleanValue) {
        this.ts = ts;
        this.cachedTelemetryId = cachedTelemetryId;
        this.numericValue = numericValue;
        this.stringValue = stringValue;
        this.booleanValue = booleanValue;
    }
}

