/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.cache;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.UUID;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.trendz.dao.cache.CachedTelemetryDto;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="cached_telemetry")
public class CachedTelemetryDto {
    @Id
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    @Column(name="id")
    private UUID id;
    @Column(name="item_id")
    private UUID itemId;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="upload_time")
    private long uploadTime;
    @Column(name="calculated_field")
    private boolean calculatedField;
    @Column(name="state_field")
    private boolean stateField;
    @Column(name="start_ts")
    private long startTs;
    @Column(name="end_ts")
    private long endTs;
    @Enumerated(value=EnumType.STRING)
    @Column(name="field_type")
    private FieldType fieldType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="field_aggregation")
    private FieldAggregation fieldAggregation;
    @Enumerated(value=EnumType.STRING)
    @Column(name="date_aggregation_type")
    private DateAggregationType dateAggregationType;
    @Column(name="business_entity_id")
    private UUID businessEntityId;
    @Column(name="business_entity_field_id")
    private UUID businessEntityFieldId;
    @Column(name="function")
    private String calculatedOrStateFunction;
    @Column(name="latest_telemetry_point_ts")
    private long latestTelemetryPointTs;

    public CachedTelemetry toData() {
        return CachedTelemetry.builder().id(this.id).itemId(this.itemId).tenantId(this.tenantId).uploadTime(this.uploadTime).calculatedField(this.calculatedField).stateField(this.stateField).startTs(this.startTs).endTs(this.endTs).fieldType(this.fieldType).fieldAggregation(this.fieldAggregation).dateAggregationType(this.dateAggregationType).businessEntityId(this.businessEntityId).businessEntityFieldId(this.businessEntityFieldId).calculatedOrStateFunction(this.calculatedOrStateFunction).points(new ArrayList()).latestTelemetryPoint(this.latestTelemetryPointTs).build();
    }

    public static CachedTelemetryDto from(CachedTelemetry entity) {
        return CachedTelemetryDto.builder().id(entity.getId()).itemId(entity.getItemId()).tenantId(entity.getTenantId()).uploadTime(entity.getUploadTime()).calculatedField(entity.isCalculatedField()).stateField(entity.isStateField()).startTs(entity.getStartTs()).endTs(entity.getEndTs()).fieldType(entity.getFieldType()).fieldAggregation(entity.getFieldAggregation()).dateAggregationType(entity.getDateAggregationType()).businessEntityId(entity.getBusinessEntityId()).businessEntityFieldId(entity.getBusinessEntityFieldId()).calculatedOrStateFunction(entity.getCalculatedOrStateFunction()).latestTelemetryPointTs(entity.getLatestTelemetryPoint()).build();
    }

    public static CachedTelemetryDtoBuilder builder() {
        return new CachedTelemetryDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getItemId() {
        return this.itemId;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public long getUploadTime() {
        return this.uploadTime;
    }

    public boolean isCalculatedField() {
        return this.calculatedField;
    }

    public boolean isStateField() {
        return this.stateField;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public FieldAggregation getFieldAggregation() {
        return this.fieldAggregation;
    }

    public DateAggregationType getDateAggregationType() {
        return this.dateAggregationType;
    }

    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    public UUID getBusinessEntityFieldId() {
        return this.businessEntityFieldId;
    }

    public String getCalculatedOrStateFunction() {
        return this.calculatedOrStateFunction;
    }

    public long getLatestTelemetryPointTs() {
        return this.latestTelemetryPointTs;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setItemId(UUID itemId) {
        this.itemId = itemId;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setUploadTime(long uploadTime) {
        this.uploadTime = uploadTime;
    }

    public void setCalculatedField(boolean calculatedField) {
        this.calculatedField = calculatedField;
    }

    public void setStateField(boolean stateField) {
        this.stateField = stateField;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public void setFieldAggregation(FieldAggregation fieldAggregation) {
        this.fieldAggregation = fieldAggregation;
    }

    public void setDateAggregationType(DateAggregationType dateAggregationType) {
        this.dateAggregationType = dateAggregationType;
    }

    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    public void setBusinessEntityFieldId(UUID businessEntityFieldId) {
        this.businessEntityFieldId = businessEntityFieldId;
    }

    public void setCalculatedOrStateFunction(String calculatedOrStateFunction) {
        this.calculatedOrStateFunction = calculatedOrStateFunction;
    }

    public void setLatestTelemetryPointTs(long latestTelemetryPointTs) {
        this.latestTelemetryPointTs = latestTelemetryPointTs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachedTelemetryDto)) {
            return false;
        }
        CachedTelemetryDto other = (CachedTelemetryDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getUploadTime() != other.getUploadTime()) {
            return false;
        }
        if (this.isCalculatedField() != other.isCalculatedField()) {
            return false;
        }
        if (this.isStateField() != other.isStateField()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        if (this.getLatestTelemetryPointTs() != other.getLatestTelemetryPointTs()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$itemId = this.getItemId();
        UUID other$itemId = other.getItemId();
        if (this$itemId == null ? other$itemId != null : !((Object)this$itemId).equals(other$itemId)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        FieldType this$fieldType = this.getFieldType();
        FieldType other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
            return false;
        }
        FieldAggregation this$fieldAggregation = this.getFieldAggregation();
        FieldAggregation other$fieldAggregation = other.getFieldAggregation();
        if (this$fieldAggregation == null ? other$fieldAggregation != null : !this$fieldAggregation.equals(other$fieldAggregation)) {
            return false;
        }
        DateAggregationType this$dateAggregationType = this.getDateAggregationType();
        DateAggregationType other$dateAggregationType = other.getDateAggregationType();
        if (this$dateAggregationType == null ? other$dateAggregationType != null : !this$dateAggregationType.equals(other$dateAggregationType)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        UUID this$businessEntityFieldId = this.getBusinessEntityFieldId();
        UUID other$businessEntityFieldId = other.getBusinessEntityFieldId();
        if (this$businessEntityFieldId == null ? other$businessEntityFieldId != null : !((Object)this$businessEntityFieldId).equals(other$businessEntityFieldId)) {
            return false;
        }
        String this$calculatedOrStateFunction = this.getCalculatedOrStateFunction();
        String other$calculatedOrStateFunction = other.getCalculatedOrStateFunction();
        return !(this$calculatedOrStateFunction == null ? other$calculatedOrStateFunction != null : !this$calculatedOrStateFunction.equals(other$calculatedOrStateFunction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CachedTelemetryDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $uploadTime = this.getUploadTime();
        result = result * 59 + (int)($uploadTime >>> 32 ^ $uploadTime);
        result = result * 59 + (this.isCalculatedField() ? 79 : 97);
        result = result * 59 + (this.isStateField() ? 79 : 97);
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        long $latestTelemetryPointTs = this.getLatestTelemetryPointTs();
        result = result * 59 + (int)($latestTelemetryPointTs >>> 32 ^ $latestTelemetryPointTs);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $itemId = this.getItemId();
        result = result * 59 + ($itemId == null ? 43 : ((Object)$itemId).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        FieldType $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
        FieldAggregation $fieldAggregation = this.getFieldAggregation();
        result = result * 59 + ($fieldAggregation == null ? 43 : $fieldAggregation.hashCode());
        DateAggregationType $dateAggregationType = this.getDateAggregationType();
        result = result * 59 + ($dateAggregationType == null ? 43 : $dateAggregationType.hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        UUID $businessEntityFieldId = this.getBusinessEntityFieldId();
        result = result * 59 + ($businessEntityFieldId == null ? 43 : ((Object)$businessEntityFieldId).hashCode());
        String $calculatedOrStateFunction = this.getCalculatedOrStateFunction();
        result = result * 59 + ($calculatedOrStateFunction == null ? 43 : $calculatedOrStateFunction.hashCode());
        return result;
    }

    public String toString() {
        return "CachedTelemetryDto(id=" + String.valueOf(this.getId()) + ", itemId=" + String.valueOf(this.getItemId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", uploadTime=" + this.getUploadTime() + ", calculatedField=" + this.isCalculatedField() + ", stateField=" + this.isStateField() + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", fieldType=" + String.valueOf(this.getFieldType()) + ", fieldAggregation=" + String.valueOf(this.getFieldAggregation()) + ", dateAggregationType=" + String.valueOf(this.getDateAggregationType()) + ", businessEntityId=" + String.valueOf(this.getBusinessEntityId()) + ", businessEntityFieldId=" + String.valueOf(this.getBusinessEntityFieldId()) + ", calculatedOrStateFunction=" + this.getCalculatedOrStateFunction() + ", latestTelemetryPointTs=" + this.getLatestTelemetryPointTs() + ")";
    }

    public CachedTelemetryDto() {
    }

    public CachedTelemetryDto(UUID id, UUID itemId, UUID tenantId, long uploadTime, boolean calculatedField, boolean stateField, long startTs, long endTs, FieldType fieldType, FieldAggregation fieldAggregation, DateAggregationType dateAggregationType, UUID businessEntityId, UUID businessEntityFieldId, String calculatedOrStateFunction, long latestTelemetryPointTs) {
        this.id = id;
        this.itemId = itemId;
        this.tenantId = tenantId;
        this.uploadTime = uploadTime;
        this.calculatedField = calculatedField;
        this.stateField = stateField;
        this.startTs = startTs;
        this.endTs = endTs;
        this.fieldType = fieldType;
        this.fieldAggregation = fieldAggregation;
        this.dateAggregationType = dateAggregationType;
        this.businessEntityId = businessEntityId;
        this.businessEntityFieldId = businessEntityFieldId;
        this.calculatedOrStateFunction = calculatedOrStateFunction;
        this.latestTelemetryPointTs = latestTelemetryPointTs;
    }
}

