/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.cache;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.cache.CachedTelemetryDao;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import reactor.core.publisher.Mono;

@Service
public class CachedTelemetryDaoAsync {
    private static final Logger log = LoggerFactory.getLogger(CachedTelemetryDaoAsync.class);
    private final ExecutorManagementService executorManagementService;
    private final CachedTelemetryDao cachedTelemetryDao;

    @Autowired
    public CachedTelemetryDaoAsync(ExecutorManagementService executorManagementService, CachedTelemetryDao cachedTelemetryDao) {
        this.executorManagementService = executorManagementService;
        this.cachedTelemetryDao = cachedTelemetryDao;
    }

    public Mono<List<CachedTelemetry>> findAllCompatibleCachedTelemetriesAsync(Set<UUID> itemIds, long startTs, long endTs, FieldAggregation fieldAggregation, DateAggregationType equalDateAggregationType, UUID businessEntityFieldId, String function) {
        return Mono.fromFuture(CompletableFuture.supplyAsync(() -> this.cachedTelemetryDao.findAllCompatibleCachedTelemetries(itemIds, startTs, endTs, fieldAggregation, equalDateAggregationType, businessEntityFieldId, function), this.executorManagementService.getExecutorByName(ExecutorName.ASYNC_DAO)));
    }

    public Mono<UUID> saveAndMergeCachesAsync(CachedTelemetry cachedTelemetry, List<CachedTelemetry> oldTelemetryCaches) {
        return Mono.fromFuture(CompletableFuture.supplyAsync(() -> {
            try {
                return this.cachedTelemetryDao.saveAndMergeCaches(cachedTelemetry, oldTelemetryCaches);
            }
            catch (DataIntegrityViolationException e) {
                if (!(e.getCause() instanceof ConstraintViolationException)) {
                    throw new TrendzInternalException("There is unexpected exception:" + String.valueOf((Object)e));
                }
                log.warn("There is cache telemetry header saving error by violating unique constrain (async saving same data)");
                return EntityId.NULL_UUID;
            }
        }, this.executorManagementService.getExecutorByName(ExecutorName.ASYNC_DAO)));
    }

    public Mono<UUID> saveCachedTelemetryAsync(CachedTelemetry cachedTelemetry) {
        return Mono.fromFuture(CompletableFuture.supplyAsync(() -> {
            try {
                return this.cachedTelemetryDao.saveCachedTelemetry(cachedTelemetry);
            }
            catch (DataIntegrityViolationException e) {
                if (!(e.getCause() instanceof ConstraintViolationException)) {
                    throw new TrendzInternalException("There is unexpected exception:" + String.valueOf((Object)e));
                }
                log.warn("There is cache telemetry header saving error by violating unique constrain (async saving same data)");
                return EntityId.NULL_UUID;
            }
        }, this.executorManagementService.getExecutorByName(ExecutorName.ASYNC_DAO)));
    }

    public Mono<Boolean> removeAllByTenantIdAsync(TenantId tenantId) {
        return Mono.fromFuture(CompletableFuture.supplyAsync(() -> {
            this.cachedTelemetryDao.removeAllByTenantId(tenantId);
            return true;
        }, this.executorManagementService.getExecutorByName(ExecutorName.ASYNC_DAO)));
    }

    public Mono<Boolean> removeAllCacheAsync() {
        return Mono.fromFuture(CompletableFuture.supplyAsync(() -> {
            this.cachedTelemetryDao.removeAllCache();
            return true;
        }, this.executorManagementService.getExecutorByName(ExecutorName.ASYNC_DAO)));
    }

    public Mono<Boolean> removeTelemetries(List<CachedTelemetry> telemetries) {
        return Mono.fromFuture(CompletableFuture.supplyAsync(() -> {
            this.cachedTelemetryDao.removeCachedTelemetryListWithTransaction(telemetries);
            return true;
        }, this.executorManagementService.getExecutorByName(ExecutorName.ASYNC_DAO)));
    }
}

