/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.business;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.UUID;
import org.thingsboard.trendz.dao.business.RelationDto;
import org.thingsboard.trendz.dao.business.RelationId;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity(name="relation")
@Table(name="relation")
public class RelationDto {
    private static ObjectMapper mapper;
    @EmbeddedId
    private RelationId relationId;
    private boolean enabled;
    @JsonDeserialize(as=Relation.class)
    private String query;

    public Relation toData() {
        Relation relation;
        try {
            relation = (Relation)mapper.readValue(this.query, Relation.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return Relation.builder().name(this.relationId.getName()).enabled(this.enabled).relatedEntityId(this.relationId.getRelatedEntityId()).relationType(relation.getRelationType()).direction(relation.getDirection()).build();
    }

    public static RelationDto from(UUID beId, Relation entity) {
        return RelationDto.builder().relationId(entity.makeRelationId(beId)).enabled(entity.isEnabled()).query(JsonUtils.toJson((Object)entity)).build();
    }

    public static RelationDtoBuilder builder() {
        return new RelationDtoBuilder();
    }

    public RelationId getRelationId() {
        return this.relationId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getQuery() {
        return this.query;
    }

    public void setRelationId(RelationId relationId) {
        this.relationId = relationId;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonDeserialize(as=Relation.class)
    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationDto)) {
            return false;
        }
        RelationDto other = (RelationDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        RelationId this$relationId = this.getRelationId();
        RelationId other$relationId = other.getRelationId();
        if (this$relationId == null ? other$relationId != null : !this$relationId.equals(other$relationId)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelationDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        RelationId $relationId = this.getRelationId();
        result = result * 59 + ($relationId == null ? 43 : $relationId.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    public String toString() {
        return "RelationDto(relationId=" + String.valueOf(this.getRelationId()) + ", enabled=" + this.isEnabled() + ", query=" + this.getQuery() + ")";
    }

    public RelationDto() {
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public RelationDto(RelationId relationId, boolean enabled, String query) {
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.relationId = relationId;
        this.enabled = enabled;
        this.query = query;
    }
}

