/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.business;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.List;
import java.util.UUID;
import org.thingsboard.trendz.dao.business.BusinessEntityFieldDto;
import org.thingsboard.trendz.dao.business.metadata.BusinessEntityFieldMetadataDto;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="business_entity_field")
public class BusinessEntityFieldDto {
    @Id
    private UUID id;
    @Column(name="business_entity_id")
    private UUID businessEntityId;
    private String name;
    private String description;
    private String calcFunction;
    private boolean hidden;
    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    private FieldType type;
    private String query;
    @Column(name="sql_id_key")
    private boolean sqlIdKey;
    @Column(name="sql_ts_key")
    private boolean sqlTsKey;
    @OneToMany(mappedBy="businessEntityFieldId", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<BusinessEntityFieldMetadataDto> metadata;

    public BusinessEntityField toData() {
        BusinessEntityFieldQuery fieldQuery = (BusinessEntityFieldQuery)JsonUtils.fromJson((String)this.query, BusinessEntityFieldQuery.class);
        fieldQuery.setSqlIdKey(this.sqlIdKey);
        fieldQuery.setSqlTsKey(this.sqlTsKey);
        return BusinessEntityField.builder().id(this.id).businessEntityId(this.businessEntityId).name(this.name).description(this.description).hidden(this.hidden).type(this.type).calcFunction(this.calcFunction).query(fieldQuery).build();
    }

    public static BusinessEntityFieldDto from(BusinessEntityField entity) {
        return BusinessEntityFieldDto.builder().id(entity.getId()).businessEntityId(entity.getBusinessEntityId()).description(entity.getDescription()).name(entity.getName()).hidden(entity.isHidden()).calcFunction(entity.getCalcFunction()).query(JsonUtils.toJson((Object)entity.getQuery())).type(entity.getType()).sqlIdKey(entity.getQuery().isSqlIdKey()).sqlTsKey(entity.getQuery().isSqlTsKey()).build();
    }

    public static BusinessEntityFieldDtoBuilder builder() {
        return new BusinessEntityFieldDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCalcFunction() {
        return this.calcFunction;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public FieldType getType() {
        return this.type;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isSqlIdKey() {
        return this.sqlIdKey;
    }

    public boolean isSqlTsKey() {
        return this.sqlTsKey;
    }

    public List<BusinessEntityFieldMetadataDto> getMetadata() {
        return this.metadata;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCalcFunction(String calcFunction) {
        this.calcFunction = calcFunction;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setSqlIdKey(boolean sqlIdKey) {
        this.sqlIdKey = sqlIdKey;
    }

    public void setSqlTsKey(boolean sqlTsKey) {
        this.sqlTsKey = sqlTsKey;
    }

    public void setMetadata(List<BusinessEntityFieldMetadataDto> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessEntityFieldDto)) {
            return false;
        }
        BusinessEntityFieldDto other = (BusinessEntityFieldDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        if (this.isSqlIdKey() != other.isSqlIdKey()) {
            return false;
        }
        if (this.isSqlTsKey() != other.isSqlTsKey()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$calcFunction = this.getCalcFunction();
        String other$calcFunction = other.getCalcFunction();
        if (this$calcFunction == null ? other$calcFunction != null : !this$calcFunction.equals(other$calcFunction)) {
            return false;
        }
        FieldType this$type = this.getType();
        FieldType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        List this$metadata = this.getMetadata();
        List other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessEntityFieldDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHidden() ? 79 : 97);
        result = result * 59 + (this.isSqlIdKey() ? 79 : 97);
        result = result * 59 + (this.isSqlTsKey() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $calcFunction = this.getCalcFunction();
        result = result * 59 + ($calcFunction == null ? 43 : $calcFunction.hashCode());
        FieldType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        List $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "BusinessEntityFieldDto(id=" + String.valueOf(this.getId()) + ", businessEntityId=" + String.valueOf(this.getBusinessEntityId()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", calcFunction=" + this.getCalcFunction() + ", hidden=" + this.isHidden() + ", type=" + String.valueOf(this.getType()) + ", query=" + this.getQuery() + ", sqlIdKey=" + this.isSqlIdKey() + ", sqlTsKey=" + this.isSqlTsKey() + ", metadata=" + String.valueOf(this.getMetadata()) + ")";
    }

    public BusinessEntityFieldDto() {
    }

    public BusinessEntityFieldDto(UUID id, UUID businessEntityId, String name, String description, String calcFunction, boolean hidden, FieldType type, String query, boolean sqlIdKey, boolean sqlTsKey, List<BusinessEntityFieldMetadataDto> metadata) {
        this.id = id;
        this.businessEntityId = businessEntityId;
        this.name = name;
        this.description = description;
        this.calcFunction = calcFunction;
        this.hidden = hidden;
        this.type = type;
        this.query = query;
        this.sqlIdKey = sqlIdKey;
        this.sqlTsKey = sqlTsKey;
        this.metadata = metadata;
    }
}

