/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.business;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.dao.business.BusinessEntityDto;
import org.thingsboard.trendz.dao.business.BusinessEntityFieldDto;
import org.thingsboard.trendz.dao.business.RelationDto;
import org.thingsboard.trendz.dao.business.metadata.BusinessEntityMetadataDto;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity(name="business_entity")
@Table(name="business_entity")
public class BusinessEntityDto {
    @Id
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    private String name;
    private String description;
    private boolean hidden;
    private String query;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="business_entity_id", updatable=false)
    private Set<BusinessEntityFieldDto> fields;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="business_entity_id", updatable=false)
    private Set<RelationDto> relations;
    @OneToMany(mappedBy="businessEntityId", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<BusinessEntityMetadataDto> metadata;
    private boolean sharedWithCustomers;

    public BusinessEntity toData() {
        return BusinessEntity.builder().id(this.id).tenantId(this.tenantId).name(this.name).description(this.description).hidden(this.hidden).fields(this.fields.stream().map(BusinessEntityFieldDto::toData).peek(f -> f.setBusinessEntityId(this.id)).collect(Collectors.toList())).relations(this.relations.stream().map(RelationDto::toData).collect(Collectors.toList())).query((BusinessEntityQuery)JsonUtils.fromJson((String)this.query, BusinessEntityQuery.class)).sharedWithCustomers(this.sharedWithCustomers).build();
    }

    public static BusinessEntityDto from(UUID tenantId, BusinessEntity entity) {
        return BusinessEntityDto.builder().id(entity.getId()).tenantId(tenantId).name(entity.getName()).description(entity.getDescription()).hidden(entity.isHidden()).fields(Optional.ofNullable(entity.getFields()).orElse(Collections.emptyList()).stream().map(BusinessEntityFieldDto::from).peek(f -> f.setBusinessEntityId(entity.getId())).collect(Collectors.toSet())).relations(Optional.ofNullable(entity.getRelations()).orElse(Collections.emptyList()).stream().map(relation -> RelationDto.from((UUID)entity.getId(), (Relation)relation)).collect(Collectors.toSet())).query(JsonUtils.toJson((Object)entity.getQuery())).sharedWithCustomers(entity.isSharedWithCustomers()).build();
    }

    public static BusinessEntityDtoBuilder builder() {
        return new BusinessEntityDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getQuery() {
        return this.query;
    }

    public Set<BusinessEntityFieldDto> getFields() {
        return this.fields;
    }

    public Set<RelationDto> getRelations() {
        return this.relations;
    }

    public List<BusinessEntityMetadataDto> getMetadata() {
        return this.metadata;
    }

    public boolean isSharedWithCustomers() {
        return this.sharedWithCustomers;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setFields(Set<BusinessEntityFieldDto> fields) {
        this.fields = fields;
    }

    public void setRelations(Set<RelationDto> relations) {
        this.relations = relations;
    }

    public void setMetadata(List<BusinessEntityMetadataDto> metadata) {
        this.metadata = metadata;
    }

    public void setSharedWithCustomers(boolean sharedWithCustomers) {
        this.sharedWithCustomers = sharedWithCustomers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessEntityDto)) {
            return false;
        }
        BusinessEntityDto other = (BusinessEntityDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        if (this.isSharedWithCustomers() != other.isSharedWithCustomers()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        Set this$fields = this.getFields();
        Set other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Set this$relations = this.getRelations();
        Set other$relations = other.getRelations();
        if (this$relations == null ? other$relations != null : !((Object)this$relations).equals(other$relations)) {
            return false;
        }
        List this$metadata = this.getMetadata();
        List other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessEntityDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHidden() ? 79 : 97);
        result = result * 59 + (this.isSharedWithCustomers() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        Set $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Set $relations = this.getRelations();
        result = result * 59 + ($relations == null ? 43 : ((Object)$relations).hashCode());
        List $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "BusinessEntityDto(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", hidden=" + this.isHidden() + ", query=" + this.getQuery() + ", fields=" + String.valueOf(this.getFields()) + ", relations=" + String.valueOf(this.getRelations()) + ", metadata=" + String.valueOf(this.getMetadata()) + ", sharedWithCustomers=" + this.isSharedWithCustomers() + ")";
    }

    public BusinessEntityDto() {
    }

    public BusinessEntityDto(UUID id, UUID tenantId, String name, String description, boolean hidden, String query, Set<BusinessEntityFieldDto> fields, Set<RelationDto> relations, List<BusinessEntityMetadataDto> metadata, boolean sharedWithCustomers) {
        this.id = id;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.hidden = hidden;
        this.query = query;
        this.fields = fields;
        this.relations = relations;
        this.metadata = metadata;
        this.sharedWithCustomers = sharedWithCustomers;
    }
}

