/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance.model;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.dao.assistance.model.LlmSettingsChatTypeLinkDto;
import org.thingsboard.trendz.dao.assistance.model.LlmSettingsDto;
import org.thingsboard.trendz.domain.assistance.model.LlmSettings;
import org.thingsboard.trendz.domain.chat.ChatType;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="llm_settings")
public class LlmSettingsDto {
    @Id
    @Column(name="id")
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="active")
    private boolean active;
    @Column(name="use_default")
    private boolean useDefault;
    @Column(name="default_llm_config_id")
    private UUID defaultLlmConfigId;
    @OneToMany(mappedBy="llmSettingId", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    private Set<LlmSettingsChatTypeLinkDto> chatTypeToLlmConfigLinks;

    public LlmSettings toData() {
        return LlmSettings.builder().id(this.id).tenantId(this.tenantId).active(this.active).useDefault(this.useDefault).defaultLlmConfigId(this.defaultLlmConfigId).chatTypeToLlmConfigMap((Map)Optional.ofNullable(this.chatTypeToLlmConfigLinks).orElse(Collections.emptySet()).stream().collect(Collectors.toMap(LlmSettingsChatTypeLinkDto::getChatType, LlmSettingsChatTypeLinkDto::getLlmConfigId, (a, b) -> a, () -> new EnumMap(ChatType.class)))).build();
    }

    public static LlmSettingsDto fromData(LlmSettings entity) {
        return LlmSettingsDto.builder().id(entity.getId()).tenantId(entity.getTenantId()).active(entity.isActive()).useDefault(entity.isUseDefault()).defaultLlmConfigId(entity.getDefaultLlmConfigId()).chatTypeToLlmConfigLinks(entity.getChatTypeToLlmConfigMap().entrySet().stream().map(entry -> new LlmSettingsChatTypeLinkDto(entity.getId(), (ChatType)entry.getKey(), (UUID)entry.getValue())).collect(Collectors.toSet())).build();
    }

    public static LlmSettingsDtoBuilder builder() {
        return new LlmSettingsDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    public UUID getDefaultLlmConfigId() {
        return this.defaultLlmConfigId;
    }

    public Set<LlmSettingsChatTypeLinkDto> getChatTypeToLlmConfigLinks() {
        return this.chatTypeToLlmConfigLinks;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setUseDefault(boolean useDefault) {
        this.useDefault = useDefault;
    }

    public void setDefaultLlmConfigId(UUID defaultLlmConfigId) {
        this.defaultLlmConfigId = defaultLlmConfigId;
    }

    public void setChatTypeToLlmConfigLinks(Set<LlmSettingsChatTypeLinkDto> chatTypeToLlmConfigLinks) {
        this.chatTypeToLlmConfigLinks = chatTypeToLlmConfigLinks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LlmSettingsDto)) {
            return false;
        }
        LlmSettingsDto other = (LlmSettingsDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isUseDefault() != other.isUseDefault()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$defaultLlmConfigId = this.getDefaultLlmConfigId();
        UUID other$defaultLlmConfigId = other.getDefaultLlmConfigId();
        if (this$defaultLlmConfigId == null ? other$defaultLlmConfigId != null : !((Object)this$defaultLlmConfigId).equals(other$defaultLlmConfigId)) {
            return false;
        }
        Set this$chatTypeToLlmConfigLinks = this.getChatTypeToLlmConfigLinks();
        Set other$chatTypeToLlmConfigLinks = other.getChatTypeToLlmConfigLinks();
        return !(this$chatTypeToLlmConfigLinks == null ? other$chatTypeToLlmConfigLinks != null : !((Object)this$chatTypeToLlmConfigLinks).equals(other$chatTypeToLlmConfigLinks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LlmSettingsDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isUseDefault() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $defaultLlmConfigId = this.getDefaultLlmConfigId();
        result = result * 59 + ($defaultLlmConfigId == null ? 43 : ((Object)$defaultLlmConfigId).hashCode());
        Set $chatTypeToLlmConfigLinks = this.getChatTypeToLlmConfigLinks();
        result = result * 59 + ($chatTypeToLlmConfigLinks == null ? 43 : ((Object)$chatTypeToLlmConfigLinks).hashCode());
        return result;
    }

    public String toString() {
        return "LlmSettingsDto(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", active=" + this.isActive() + ", useDefault=" + this.isUseDefault() + ", defaultLlmConfigId=" + String.valueOf(this.getDefaultLlmConfigId()) + ", chatTypeToLlmConfigLinks=" + String.valueOf(this.getChatTypeToLlmConfigLinks()) + ")";
    }

    public LlmSettingsDto() {
    }

    public LlmSettingsDto(UUID id, UUID tenantId, boolean active, boolean useDefault, UUID defaultLlmConfigId, Set<LlmSettingsChatTypeLinkDto> chatTypeToLlmConfigLinks) {
        this.id = id;
        this.tenantId = tenantId;
        this.active = active;
        this.useDefault = useDefault;
        this.defaultLlmConfigId = defaultLlmConfigId;
        this.chatTypeToLlmConfigLinks = chatTypeToLlmConfigLinks;
    }
}

