/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance.model;

import jakarta.transaction.Transactional;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.assistance.model.LlmSettingsDto;
import org.thingsboard.trendz.dao.assistance.model.LlmSettingsRepository;
import org.thingsboard.trendz.domain.assistance.model.LlmSettings;

@Service
@Transactional
public class LlmSettingsDao {
    private static final Logger log = LoggerFactory.getLogger(LlmSettingsDao.class);
    private final LlmSettingsRepository llmSettingsRepository;

    @Autowired
    public LlmSettingsDao(LlmSettingsRepository llmSettingsRepository) {
        this.llmSettingsRepository = llmSettingsRepository;
    }

    public Optional<LlmSettings> findByTenantId(UUID tenantId) {
        return this.llmSettingsRepository.findByTenantId(tenantId).map(LlmSettingsDto::toData);
    }

    public LlmSettings save(LlmSettings entity) {
        LlmSettingsDto dto = LlmSettingsDto.fromData((LlmSettings)entity);
        LlmSettingsDto saved = (LlmSettingsDto)this.llmSettingsRepository.save((Object)dto);
        return saved.toData();
    }
}

