/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.UUID;
import org.thingsboard.trendz.dao.assistance.model.LlmConfigDto;
import org.thingsboard.trendz.domain.assistance.model.LlmConfig;
import org.thingsboard.trendz.domain.assistance.model.LlmName;
import org.thingsboard.trendz.domain.assistance.model.LlmProvider;
import org.thingsboard.trendz.domain.assistance.model.properties.LlmProviderProperties;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="llm_config")
public class LlmConfigDto {
    @Id
    @Column(name="id")
    private UUID id;
    @Column(name="created_ts")
    private long createdTs;
    @Column(name="updated_ts")
    private long updatedTs;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="name")
    private String name;
    @Column(name="model_provider")
    private String modelProvider;
    @Column(name="model_name")
    private String modelName;
    @Column(name="json_properties")
    private String jsonProperties;

    public LlmConfig toData() {
        LlmProvider llmProvider = LlmProvider.from((String)this.modelProvider);
        LlmName llmName = LlmName.from((LlmProvider)llmProvider, (String)this.modelName);
        JsonNode nodeProperties = JsonUtils.toNodeFromRaw((String)this.jsonProperties);
        double temperature = nodeProperties.path("temperature").asDouble(0.0);
        double topP = nodeProperties.path("topP").asDouble(0.0);
        JsonNode providerProperties = nodeProperties.path("providerProperties");
        LlmProviderProperties llmProviderProperties = LlmProviderProperties.fromJson((JsonNode)providerProperties, (LlmProvider)llmProvider);
        return LlmConfig.builder().id(this.id).createdTs(this.createdTs).updatedTs(this.updatedTs).tenantId(this.tenantId).name(this.name).llmProvider(llmProvider).llmName(llmName).temperature(temperature).topP(topP).llmProviderProperties(llmProviderProperties).build();
    }

    public static LlmConfigDto fromData(LlmConfig entity) {
        ObjectNode objectNode = JsonUtils.getObjectMapper().createObjectNode();
        objectNode.put("temperature", entity.getTemperature());
        objectNode.put("topP", entity.getTopP());
        objectNode.set("providerProperties", JsonUtils.toNodeFromObject((Object)entity.getLlmProviderProperties()));
        return LlmConfigDto.builder().id(entity.getId()).createdTs(entity.getCreatedTs()).updatedTs(entity.getUpdatedTs()).tenantId(entity.getTenantId()).name(entity.getName()).modelProvider(entity.getLlmProvider().toString()).modelName(entity.getLlmName().getModelName()).jsonProperties(JsonUtils.fromNodeToRaw((JsonNode)objectNode)).build();
    }

    public static LlmConfigDtoBuilder builder() {
        return new LlmConfigDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public long getCreatedTs() {
        return this.createdTs;
    }

    public long getUpdatedTs() {
        return this.updatedTs;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public String getModelProvider() {
        return this.modelProvider;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getJsonProperties() {
        return this.jsonProperties;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    public void setUpdatedTs(long updatedTs) {
        this.updatedTs = updatedTs;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setModelProvider(String modelProvider) {
        this.modelProvider = modelProvider;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setJsonProperties(String jsonProperties) {
        this.jsonProperties = jsonProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LlmConfigDto)) {
            return false;
        }
        LlmConfigDto other = (LlmConfigDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getUpdatedTs() != other.getUpdatedTs()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$modelProvider = this.getModelProvider();
        String other$modelProvider = other.getModelProvider();
        if (this$modelProvider == null ? other$modelProvider != null : !this$modelProvider.equals(other$modelProvider)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$jsonProperties = this.getJsonProperties();
        String other$jsonProperties = other.getJsonProperties();
        return !(this$jsonProperties == null ? other$jsonProperties != null : !this$jsonProperties.equals(other$jsonProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LlmConfigDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $updatedTs = this.getUpdatedTs();
        result = result * 59 + (int)($updatedTs >>> 32 ^ $updatedTs);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $modelProvider = this.getModelProvider();
        result = result * 59 + ($modelProvider == null ? 43 : $modelProvider.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $jsonProperties = this.getJsonProperties();
        result = result * 59 + ($jsonProperties == null ? 43 : $jsonProperties.hashCode());
        return result;
    }

    public String toString() {
        return "LlmConfigDto(id=" + String.valueOf(this.getId()) + ", createdTs=" + this.getCreatedTs() + ", updatedTs=" + this.getUpdatedTs() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", modelProvider=" + this.getModelProvider() + ", modelName=" + this.getModelName() + ", jsonProperties=" + this.getJsonProperties() + ")";
    }

    public LlmConfigDto() {
    }

    public LlmConfigDto(UUID id, long createdTs, long updatedTs, UUID tenantId, String name, String modelProvider, String modelName, String jsonProperties) {
        this.id = id;
        this.createdTs = createdTs;
        this.updatedTs = updatedTs;
        this.tenantId = tenantId;
        this.name = name;
        this.modelProvider = modelProvider;
        this.modelName = modelName;
        this.jsonProperties = jsonProperties;
    }
}

