/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance.model;

import jakarta.transaction.Transactional;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.assistance.model.LlmConfigDto;
import org.thingsboard.trendz.dao.assistance.model.LlmConfigRepository;
import org.thingsboard.trendz.domain.assistance.model.LlmConfig;
import org.thingsboard.trendz.domain.assistance.model.LlmConfigLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.tools.PaginationPage;

@Service
@Transactional
public class LlmConfigDao {
    private static final Logger log = LoggerFactory.getLogger(LlmConfigDao.class);
    private final LlmConfigRepository llmConfigRepository;

    @Autowired
    public LlmConfigDao(LlmConfigRepository llmConfigRepository) {
        this.llmConfigRepository = llmConfigRepository;
    }

    public PaginationPage<LlmConfigLite> findAllLiteByUser(JwtSecurityUser user, int page, int pageSize) {
        PageRequest pageRequest = PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdTs"}));
        Page result = this.llmConfigRepository.findAllByTenantId(user.getTenantId(), (Pageable)pageRequest);
        return new PaginationPage(result);
    }

    public Optional<LlmConfig> findByUserAndId(JwtSecurityUser user, UUID id) {
        return this.llmConfigRepository.findByIdAndTenantId(user.getTenantId(), id).map(LlmConfigDto::toData);
    }

    public Set<LlmConfig> findByUserAndIdSet(JwtSecurityUser user, Set<UUID> idSet) {
        if (idSet == null || idSet.isEmpty()) {
            return Collections.emptySet();
        }
        return this.llmConfigRepository.findByIdAndTenantIdSet(user.getTenantId(), idSet).stream().map(LlmConfigDto::toData).collect(Collectors.toSet());
    }

    public Optional<LlmConfig> findById(UUID id) {
        return this.llmConfigRepository.findById((Object)id).map(LlmConfigDto::toData);
    }

    public LlmConfig save(LlmConfig entity) {
        LlmConfigDto dto = LlmConfigDto.fromData((LlmConfig)entity);
        LlmConfigDto saved = (LlmConfigDto)this.llmConfigRepository.save((Object)dto);
        return saved.toData();
    }

    public void delete(UUID id) {
        this.llmConfigRepository.deleteById((Object)id);
    }
}

