/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance.metadata;

import jakarta.transaction.Transactional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.assistance.metadata.CustomPromptMetadataDto;
import org.thingsboard.trendz.dao.assistance.metadata.CustomPromptMetadataRepository;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;

@Service
@Transactional
public class CustomPromptMetadataDao {
    private static final Logger log = LoggerFactory.getLogger(CustomPromptMetadataDao.class);
    private final CustomPromptMetadataRepository customPromptMetadataRepository;

    @Autowired
    public CustomPromptMetadataDao(CustomPromptMetadataRepository customPromptMetadataRepository) {
        this.customPromptMetadataRepository = customPromptMetadataRepository;
    }

    public void save(String prompt, String data, String response, JwtSecurityUser user, long duration) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        UUID userId = EntityId.NULL_UUID.equals(user.getUserId()) ? null : user.getUserId();
        CustomPromptMetadataDto customPromptMetadataDto = CustomPromptMetadataDto.builder().id(UUID.randomUUID()).prompt(prompt).data(data).response(response).tenantId(tenantId).customerId(customerId).userId(userId).duration(duration).createdTs(System.currentTimeMillis()).build();
        this.customPromptMetadataRepository.save((Object)customPromptMetadataDto);
    }
}

