/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance.chat;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.List;
import java.util.UUID;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.assistance.chat.ChatDto;
import org.thingsboard.trendz.dao.assistance.chat.ChatMessageDto;
import org.thingsboard.trendz.domain.chat.Chat;
import org.thingsboard.trendz.domain.chat.ChatAvailableTopology;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity(name="view_assistance_chat")
@Table(name="view_assistance_chat")
public class ChatDto {
    @Id
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="customer_id")
    private UUID customerId;
    @Column(name="user_id")
    private UUID userId;
    @Column(name="type")
    private String type;
    @Column(name="metric_definition_id")
    private UUID metricDefinitionId;
    @Column(name="chat_summary")
    private String chatSummary;
    @Column(name="available_topology")
    private String availableTopology;
    @Column(name="reference_key")
    private String referenceKey;
    @Column(name="created_ts")
    private long createdTs;
    @Column(name="last_modified_ts")
    private long lastModifiedTs;
    @Column(name="is_deleted")
    private boolean isDeleted;
    @OneToMany(mappedBy="chatId", fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.JOIN)
    private List<ChatMessageDto> chatMessageDtoList;

    public Chat toData() {
        return Chat.builder().id(this.id).type(ChatType.valueOf((String)this.type)).metricDefinitionId(this.metricDefinitionId).tenantId(this.tenantId).customerId(this.customerId).userId(this.userId).chatSummary(this.chatSummary).referenceKey(this.referenceKey).availableTopology(this.availableTopology == null ? null : (ChatAvailableTopology)JsonUtils.fromJson((String)this.availableTopology, ChatAvailableTopology.class)).createdTs(Long.valueOf(this.createdTs)).lastModifiedTs(Long.valueOf(this.lastModifiedTs)).build();
    }

    public static ChatDto from(Chat entity) {
        return ChatDto.builder().id(entity.getId()).type(entity.getType().name()).metricDefinitionId(entity.getMetricDefinitionId()).tenantId(entity.getTenantId()).customerId(entity.getCustomerId() == null || entity.getCustomerId().equals(EntityId.NULL_UUID) ? null : entity.getCustomerId()).userId(entity.getUserId()).chatSummary(entity.getChatSummary()).referenceKey(entity.getReferenceKey()).availableTopology(JsonUtils.toJson((Object)entity.getAvailableTopology())).createdTs(entity.getCreatedTs().longValue()).lastModifiedTs(entity.getLastModifiedTs().longValue()).build();
    }

    public static ChatDtoBuilder builder() {
        return new ChatDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public UUID getCustomerId() {
        return this.customerId;
    }

    public UUID getUserId() {
        return this.userId;
    }

    public String getType() {
        return this.type;
    }

    public UUID getMetricDefinitionId() {
        return this.metricDefinitionId;
    }

    public String getChatSummary() {
        return this.chatSummary;
    }

    public String getAvailableTopology() {
        return this.availableTopology;
    }

    public String getReferenceKey() {
        return this.referenceKey;
    }

    public long getCreatedTs() {
        return this.createdTs;
    }

    public long getLastModifiedTs() {
        return this.lastModifiedTs;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public List<ChatMessageDto> getChatMessageDtoList() {
        return this.chatMessageDtoList;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMetricDefinitionId(UUID metricDefinitionId) {
        this.metricDefinitionId = metricDefinitionId;
    }

    public void setChatSummary(String chatSummary) {
        this.chatSummary = chatSummary;
    }

    public void setAvailableTopology(String availableTopology) {
        this.availableTopology = availableTopology;
    }

    public void setReferenceKey(String referenceKey) {
        this.referenceKey = referenceKey;
    }

    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    public void setLastModifiedTs(long lastModifiedTs) {
        this.lastModifiedTs = lastModifiedTs;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setChatMessageDtoList(List<ChatMessageDto> chatMessageDtoList) {
        this.chatMessageDtoList = chatMessageDtoList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatDto)) {
            return false;
        }
        ChatDto other = (ChatDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getLastModifiedTs() != other.getLastModifiedTs()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$metricDefinitionId = this.getMetricDefinitionId();
        UUID other$metricDefinitionId = other.getMetricDefinitionId();
        if (this$metricDefinitionId == null ? other$metricDefinitionId != null : !((Object)this$metricDefinitionId).equals(other$metricDefinitionId)) {
            return false;
        }
        String this$chatSummary = this.getChatSummary();
        String other$chatSummary = other.getChatSummary();
        if (this$chatSummary == null ? other$chatSummary != null : !this$chatSummary.equals(other$chatSummary)) {
            return false;
        }
        String this$availableTopology = this.getAvailableTopology();
        String other$availableTopology = other.getAvailableTopology();
        if (this$availableTopology == null ? other$availableTopology != null : !this$availableTopology.equals(other$availableTopology)) {
            return false;
        }
        String this$referenceKey = this.getReferenceKey();
        String other$referenceKey = other.getReferenceKey();
        if (this$referenceKey == null ? other$referenceKey != null : !this$referenceKey.equals(other$referenceKey)) {
            return false;
        }
        List this$chatMessageDtoList = this.getChatMessageDtoList();
        List other$chatMessageDtoList = other.getChatMessageDtoList();
        return !(this$chatMessageDtoList == null ? other$chatMessageDtoList != null : !((Object)this$chatMessageDtoList).equals(other$chatMessageDtoList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $lastModifiedTs = this.getLastModifiedTs();
        result = result * 59 + (int)($lastModifiedTs >>> 32 ^ $lastModifiedTs);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $metricDefinitionId = this.getMetricDefinitionId();
        result = result * 59 + ($metricDefinitionId == null ? 43 : ((Object)$metricDefinitionId).hashCode());
        String $chatSummary = this.getChatSummary();
        result = result * 59 + ($chatSummary == null ? 43 : $chatSummary.hashCode());
        String $availableTopology = this.getAvailableTopology();
        result = result * 59 + ($availableTopology == null ? 43 : $availableTopology.hashCode());
        String $referenceKey = this.getReferenceKey();
        result = result * 59 + ($referenceKey == null ? 43 : $referenceKey.hashCode());
        List $chatMessageDtoList = this.getChatMessageDtoList();
        result = result * 59 + ($chatMessageDtoList == null ? 43 : ((Object)$chatMessageDtoList).hashCode());
        return result;
    }

    public String toString() {
        return "ChatDto(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", userId=" + String.valueOf(this.getUserId()) + ", type=" + this.getType() + ", metricDefinitionId=" + String.valueOf(this.getMetricDefinitionId()) + ", chatSummary=" + this.getChatSummary() + ", availableTopology=" + this.getAvailableTopology() + ", referenceKey=" + this.getReferenceKey() + ", createdTs=" + this.getCreatedTs() + ", lastModifiedTs=" + this.getLastModifiedTs() + ", isDeleted=" + this.isDeleted() + ", chatMessageDtoList=" + String.valueOf(this.getChatMessageDtoList()) + ")";
    }

    public ChatDto() {
    }

    public ChatDto(UUID id, UUID tenantId, UUID customerId, UUID userId, String type, UUID metricDefinitionId, String chatSummary, String availableTopology, String referenceKey, long createdTs, long lastModifiedTs, boolean isDeleted, List<ChatMessageDto> chatMessageDtoList) {
        this.id = id;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.userId = userId;
        this.type = type;
        this.metricDefinitionId = metricDefinitionId;
        this.chatSummary = chatSummary;
        this.availableTopology = availableTopology;
        this.referenceKey = referenceKey;
        this.createdTs = createdTs;
        this.lastModifiedTs = lastModifiedTs;
        this.isDeleted = isDeleted;
        this.chatMessageDtoList = chatMessageDtoList;
    }
}

