/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance.chat;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.assistance.chat.ChatDao;
import org.thingsboard.trendz.dao.assistance.chat.ChatDto;
import org.thingsboard.trendz.dao.assistance.chat.ChatMessageDto;
import org.thingsboard.trendz.dao.assistance.chat.ChatMessageRepository;
import org.thingsboard.trendz.dao.assistance.chat.ChatRepository;
import org.thingsboard.trendz.domain.assistance.ErrorMetadata;
import org.thingsboard.trendz.domain.chat.Chat;
import org.thingsboard.trendz.domain.chat.ChatAvailableTopology;
import org.thingsboard.trendz.domain.chat.ChatConfig;
import org.thingsboard.trendz.domain.chat.ChatFilteringField;
import org.thingsboard.trendz.domain.chat.ChatInitRequest;
import org.thingsboard.trendz.domain.chat.ChatLite;
import org.thingsboard.trendz.domain.chat.ChatMessage;
import org.thingsboard.trendz.domain.chat.ChatMessageLite;
import org.thingsboard.trendz.domain.chat.ChatMessagePostRequest;
import org.thingsboard.trendz.domain.chat.ChatMessageSortingField;
import org.thingsboard.trendz.domain.chat.ChatSortingField;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.chat.ChatMessageNotFoundException;
import org.thingsboard.trendz.exception.chat.ChatNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.tools.UUIDUtils;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Service
@Transactional
public class ChatDao {
    private static final Logger log = LoggerFactory.getLogger(ChatDao.class);
    private final ChatRepository chatRepository;
    private final ChatMessageRepository chatMessageRepository;
    private final ObjectMapper objectMapper;

    @Autowired
    public ChatDao(ChatRepository chatRepository, ChatMessageRepository chatMessageRepository, ObjectMapper objectMapper) {
        this.chatRepository = chatRepository;
        this.chatMessageRepository = chatMessageRepository;
        this.objectMapper = objectMapper;
    }

    public Page<ChatLite> getAllChatLite(int page, int pageSize, JwtSecurityUser user, List<ChatFilteringField> filteringFields, List<ChatSortingField> sortingFields) {
        long startTime = System.currentTimeMillis();
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        Map<ChatFilteringField.Type, String> filterMap = filteringFields.stream().collect(Collectors.toMap(ChatFilteringField::getType, ChatFilteringField::getValue));
        String referenceKey = filterMap.get(ChatFilteringField.Type.REFERENCE_KEY);
        String type = filterMap.get(ChatFilteringField.Type.TYPE);
        String metricIdStr = filterMap.get(ChatFilteringField.Type.METRIC_ID);
        UUID metricId = metricIdStr == null ? null : UUIDUtils.parse((String)metricIdStr);
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).collect(Collectors.toList());
        Page chatLites = this.chatRepository.findAllChatLiteByTenantIdAndCustomerId(tenantId, customerId, referenceKey, type, metricId, PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
        long endTime = System.currentTimeMillis();
        log.debug("Chats' page has been loaded, count = {}, time = {}", (Object)chatLites.getSize(), (Object)(endTime - startTime));
        return chatLites;
    }

    public ChatLite initChat(ChatInitRequest chatInitRequest, JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        UUID userId = EntityId.NULL_UUID.equals(user.getUserId()) ? null : user.getUserId();
        long now = System.currentTimeMillis();
        String code = chatInitRequest.getMessageData().getMetricCodeAssistanceParams() == null ? null : chatInitRequest.getMessageData().getMetricCodeAssistanceParams().getCode();
        ChatType chatType = ChatType.valueOf((String)chatInitRequest.getInitData().getChatType());
        ChatDto chatDto = ChatDto.builder().id(UUID.randomUUID()).type(chatInitRequest.getInitData().getChatType()).createdTs(now).lastModifiedTs(now).tenantId(tenantId).customerId(customerId).userId(userId).build();
        ChatMessageDto chatMessageDto = ChatMessageDto.builder().id(UUID.randomUUID()).chatId(chatDto.getId()).userQuestion(chatInitRequest.getMessageData().getQuestion()).code(code).createdTs(now).lastModifiedTs(now).lastModifiedBy(user.getUserId().toString()).version(1L).build();
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$chat$ChatType[chatType.ordinal()]) {
            case 1: {
                ChatConfig.ViewAssistanceChatConfig createConfig = chatInitRequest.getInitData().getViewAssistantChatConfig();
                chatDto.setReferenceKey(createConfig.getReferenceKey());
                chatDto.setAvailableTopology(createConfig.getAvailableTopology() == null ? null : JsonUtils.toJson((Object)createConfig.getAvailableTopology()));
                break;
            }
            case 2: {
                ChatConfig.MetricExplorationChatConfig createConfig = chatInitRequest.getInitData().getMetricExplorationChatConfig();
                chatDto.setMetricDefinitionId(UUIDUtils.parse((String)createConfig.getMetricId()));
            }
        }
        chatDto = (ChatDto)this.chatRepository.save((Object)chatDto);
        chatMessageDto = (ChatMessageDto)this.chatMessageRepository.save((Object)chatMessageDto);
        return new ChatLite(chatDto, chatMessageDto, Long.valueOf(1L));
    }

    public ChatLite postNewMessage(UUID chatId, ChatMessagePostRequest postRequest, JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        ChatDto chatDto = (ChatDto)this.chatRepository.findByIdAndTenantIdAndCustomerId(chatId, tenantId, customerId).orElseThrow(() -> new ChatNotFoundException(chatId));
        String code = postRequest.getMetricCodeAssistanceParams() == null ? null : postRequest.getMetricCodeAssistanceParams().getCode();
        long now = System.currentTimeMillis();
        chatDto.setLastModifiedTs(now);
        ChatMessageDto chatMessageDto = ChatMessageDto.builder().id(UUID.randomUUID()).chatId(chatDto.getId()).userQuestion(postRequest.getQuestion()).code(code).createdTs(now).lastModifiedTs(now).lastModifiedBy(user.getUserId().toString()).version(1L).build();
        chatDto = (ChatDto)this.chatRepository.save((Object)chatDto);
        chatMessageDto = (ChatMessageDto)this.chatMessageRepository.save((Object)chatMessageDto);
        return new ChatLite(chatDto, chatMessageDto, Long.valueOf(chatDto.getChatMessageDtoList().size()));
    }

    public ChatLite editLastMessage(UUID chatId, String userQuestion, JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        ChatDto chatDto = (ChatDto)this.chatRepository.findByIdAndTenantIdAndCustomerId(chatId, tenantId, customerId).orElseThrow(() -> new ChatNotFoundException(chatId));
        ChatMessageDto lastChatMessageDto = (ChatMessageDto)this.chatMessageRepository.findLastByChatId(chatId).orElseThrow(() -> new ChatMessageNotFoundException(chatId, null));
        long now = System.currentTimeMillis();
        ChatMessageDto oldChatMessageDto = ChatMessageDto.builder().id(UUID.randomUUID()).lastModifiedTs(lastChatMessageDto.getLastModifiedTs()).createdTs(lastChatMessageDto.getCreatedTs()).userQuestion(lastChatMessageDto.getUserQuestion()).code(lastChatMessageDto.getCode()).version(lastChatMessageDto.getVersion()).chatId(lastChatMessageDto.getChatId()).lastModifiedBy(lastChatMessageDto.getLastModifiedBy()).isDeleted(true).jsonJobResponse(lastChatMessageDto.getJsonJobResponse()).aiAnswer(lastChatMessageDto.getAiAnswer()).build();
        lastChatMessageDto.setLastModifiedBy(user.getUserId().toString());
        lastChatMessageDto.setLastModifiedTs(now);
        lastChatMessageDto.setJsonJobResponse(null);
        lastChatMessageDto.setAiAnswer(null);
        lastChatMessageDto.setVersion(lastChatMessageDto.getVersion() + 1L);
        lastChatMessageDto.setUserQuestion(userQuestion);
        chatDto.setLastModifiedTs(now);
        chatDto = (ChatDto)this.chatRepository.save((Object)chatDto);
        ChatMessageDto newChatMessageDto = (ChatMessageDto)this.chatMessageRepository.save((Object)lastChatMessageDto);
        this.chatMessageRepository.save((Object)oldChatMessageDto);
        return new ChatLite(chatDto, newChatMessageDto, Long.valueOf(chatDto.getChatMessageDtoList().size()));
    }

    public Optional<ChatLite> getChatLiteByIdAndUser(UUID chatId, JwtSecurityUser user) {
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.chatRepository.findLiteByIdAndTenantIdAndCustomerId(chatId, user.getTenantId(), customerId);
    }

    public Page<ChatMessageLite> getAllChatMessageLite(UUID chatId, int page, int pageSize, JwtSecurityUser user, List<ChatMessageSortingField> sortingFields) {
        long startTime = System.currentTimeMillis();
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        long endTime = System.currentTimeMillis();
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).collect(Collectors.toList());
        Page chatMessageLites = this.chatMessageRepository.findAllChatMessageLiteByChatIdAndTenantIdAndCustomerId(chatId, tenantId, customerId, PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
        log.debug("Chat Messages' page has been loaded, count = {}, time = {}", (Object)chatMessageLites.getSize(), (Object)(endTime - startTime));
        return chatMessageLites;
    }

    public List<ChatMessageLite> getAllChatMessageLite(UUID chatId, JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.chatMessageRepository.findAllChatMessageLiteByChatIdAndTenantIdAndCustomerId(chatId, tenantId, customerId);
    }

    public ChatMessage getChatMessage(UUID chatId, UUID messageId, JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.chatRepository.findChatMessageByChatIdAndMessageIdAndTenantIdAndCustomerId(chatId, messageId, tenantId, customerId).map(ChatMessageDto::toData).orElseThrow(() -> new ChatMessageNotFoundException(chatId, messageId));
    }

    public void populateChatMessageJsonJobResponse(UUID messageId, Object jsonJobResponse, ErrorMetadata errorMetadata, String aiMemory) {
        try {
            String json = this.objectMapper.writeValueAsString(jsonJobResponse);
            String aiAnswer = errorMetadata == null || errorMetadata.getFailedAgent() == null ? null : errorMetadata.getComment();
            this.chatMessageRepository.updateJsonJobResponseAndAiAnswer(messageId, json, aiAnswer, aiMemory);
        }
        catch (JsonProcessingException e) {
            throw new TrendzException("This exception shouldn't be thrown", (Throwable)e);
        }
    }

    public void populateChatSummary(UUID chatId, String chatSummary) {
        this.chatRepository.updateChatSummaryById(chatId, chatSummary);
    }

    public void deleteChat(UUID chatId, JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        this.chatRepository.deleteByIdAndTenantIdAndCustomerId(chatId, tenantId, customerId);
        this.chatMessageRepository.deleteByChatId(chatId);
    }

    public ChatLite updateChat(UUID chatId, ChatConfig.ViewAssistanceChatConfig chatConfig, JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        ChatDto chatDto = (ChatDto)this.chatRepository.findByIdAndTenantIdAndCustomerId(chatId, tenantId, customerId).orElseThrow(() -> new ChatNotFoundException(chatId));
        chatDto.setLastModifiedTs(System.currentTimeMillis());
        if (chatConfig.getReferenceKey() != null) {
            chatDto.setReferenceKey(chatConfig.getReferenceKey());
        }
        if (chatConfig.getAvailableTopology() != null) {
            chatDto.setAvailableTopology(JsonUtils.toJson((Object)chatConfig.getAvailableTopology()));
        }
        chatDto = (ChatDto)this.chatRepository.save((Object)chatDto);
        return ChatLite.builder().id(chatDto.getId()).chatSummary(chatDto.getChatSummary()).lastModifiedTs(Long.valueOf(chatDto.getLastModifiedTs())).referenceKey(chatDto.getReferenceKey()).availableTopology((ChatAvailableTopology)JsonUtils.fromJson((String)chatDto.getAvailableTopology(), ChatAvailableTopology.class)).build();
    }

    public List<Chat> exportAllChats(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.chatRepository.findAllByTenantIdAndCustomerId(tenantId, customerId).stream().map(ChatDto::toData).toList();
    }

    public List<ChatMessage> exportAllChatMessages(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        return this.chatMessageRepository.findAllByTenantId(tenantId).stream().map(ChatMessageDto::toData).toList();
    }

    public List<Chat> importAllChats(List<Chat> newChats) {
        List<ChatDto> chatDtos = newChats.stream().map(ChatDto::from).toList();
        return StreamSupport.stream(this.chatRepository.saveAll(chatDtos).spliterator(), false).map(ChatDto::toData).toList();
    }

    public List<ChatMessage> importAllChatMessages(List<ChatMessage> newChatMessages) {
        List<ChatMessageDto> chatMessageDtos = newChatMessages.stream().map(ChatMessageDto::from).toList();
        return StreamSupport.stream(this.chatMessageRepository.saveAll(chatMessageDtos).spliterator(), false).map(ChatMessageDto::toData).toList();
    }

    public Optional<ChatMessage> getLastChatMessage(JwtSecurityUser user, UUID chatId, Set<UUID> toExclude) {
        UUID tenantId = user.getTenantId();
        UUID customerId = EntityId.NULL_UUID.equals(user.getCustomerId()) ? null : user.getCustomerId();
        return this.chatMessageRepository.getLastChatMessage(tenantId, customerId, chatId, toExclude).map(ChatMessageDto::toData);
    }
}

