/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.UUID;
import org.thingsboard.trendz.dao.assistance.TokenUsageDto;
import org.thingsboard.trendz.domain.assistance.model.TokenUsageRecord;

@Entity(name="view_assistance_token_usage")
@Table(name="view_assistance_token_usage")
public class TokenUsageDto {
    @Id
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="input_token_used")
    private long inputTokenUsed;
    @Column(name="output_token_used")
    private long outputTokenUsed;
    @Column(name="model_name")
    private String modelName;
    @Column(name="start_of_month_ts")
    private long startOfMonthTs;
    @Column(name="is_system_model")
    private boolean isSystemModel;

    public TokenUsageDto(long inputTokenUsed, long outputTokenUsed, String modelName, long startOfMonthTs) {
        this.inputTokenUsed = inputTokenUsed;
        this.outputTokenUsed = outputTokenUsed;
        this.modelName = modelName;
        this.startOfMonthTs = startOfMonthTs;
    }

    public TokenUsageRecord toData() {
        return TokenUsageRecord.builder().tenantId(this.tenantId).inputUsed(this.inputTokenUsed).outputUsed(this.outputTokenUsed).modelName(this.modelName).startOfMonthTs(this.startOfMonthTs).isSystemModel(this.isSystemModel).build();
    }

    public static TokenUsageDtoBuilder builder() {
        return new TokenUsageDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public long getInputTokenUsed() {
        return this.inputTokenUsed;
    }

    public long getOutputTokenUsed() {
        return this.outputTokenUsed;
    }

    public String getModelName() {
        return this.modelName;
    }

    public long getStartOfMonthTs() {
        return this.startOfMonthTs;
    }

    public boolean isSystemModel() {
        return this.isSystemModel;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setInputTokenUsed(long inputTokenUsed) {
        this.inputTokenUsed = inputTokenUsed;
    }

    public void setOutputTokenUsed(long outputTokenUsed) {
        this.outputTokenUsed = outputTokenUsed;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setStartOfMonthTs(long startOfMonthTs) {
        this.startOfMonthTs = startOfMonthTs;
    }

    public void setSystemModel(boolean isSystemModel) {
        this.isSystemModel = isSystemModel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenUsageDto)) {
            return false;
        }
        TokenUsageDto other = (TokenUsageDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getInputTokenUsed() != other.getInputTokenUsed()) {
            return false;
        }
        if (this.getOutputTokenUsed() != other.getOutputTokenUsed()) {
            return false;
        }
        if (this.getStartOfMonthTs() != other.getStartOfMonthTs()) {
            return false;
        }
        if (this.isSystemModel() != other.isSystemModel()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        return !(this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenUsageDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $inputTokenUsed = this.getInputTokenUsed();
        result = result * 59 + (int)($inputTokenUsed >>> 32 ^ $inputTokenUsed);
        long $outputTokenUsed = this.getOutputTokenUsed();
        result = result * 59 + (int)($outputTokenUsed >>> 32 ^ $outputTokenUsed);
        long $startOfMonthTs = this.getStartOfMonthTs();
        result = result * 59 + (int)($startOfMonthTs >>> 32 ^ $startOfMonthTs);
        result = result * 59 + (this.isSystemModel() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        return result;
    }

    public String toString() {
        return "TokenUsageDto(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", inputTokenUsed=" + this.getInputTokenUsed() + ", outputTokenUsed=" + this.getOutputTokenUsed() + ", modelName=" + this.getModelName() + ", startOfMonthTs=" + this.getStartOfMonthTs() + ", isSystemModel=" + this.isSystemModel() + ")";
    }

    public TokenUsageDto() {
    }

    public TokenUsageDto(UUID id, UUID tenantId, long inputTokenUsed, long outputTokenUsed, String modelName, long startOfMonthTs, boolean isSystemModel) {
        this.id = id;
        this.tenantId = tenantId;
        this.inputTokenUsed = inputTokenUsed;
        this.outputTokenUsed = outputTokenUsed;
        this.modelName = modelName;
        this.startOfMonthTs = startOfMonthTs;
        this.isSystemModel = isSystemModel;
    }
}

